/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl2;
import net.i2p.crypto.KeyGenerator;
import net.i2p.data.Certificate;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

class I2PClientImpl
implements I2PClient {
    I2PClientImpl() {
    }

    public Destination createDestination(OutputStream destKeyStream) throws I2PException, IOException {
        Certificate cert = new Certificate();
        cert.setCertificateType(0);
        cert.setPayload(null);
        return this.createDestination(destKeyStream, cert);
    }

    public Destination createDestination(OutputStream destKeyStream, Certificate cert) throws I2PException, IOException {
        Destination d = new Destination();
        d.setCertificate(cert);
        Object[] keypair = KeyGenerator.getInstance().generatePKIKeypair();
        PublicKey publicKey = (PublicKey)keypair[0];
        PrivateKey privateKey = (PrivateKey)keypair[1];
        Object[] signingKeys = KeyGenerator.getInstance().generateSigningKeypair();
        SigningPublicKey signingPubKey = (SigningPublicKey)signingKeys[0];
        SigningPrivateKey signingPrivKey = (SigningPrivateKey)signingKeys[1];
        d.setPublicKey(publicKey);
        d.setSigningPublicKey(signingPubKey);
        d.writeBytes(destKeyStream);
        privateKey.writeBytes(destKeyStream);
        signingPrivKey.writeBytes(destKeyStream);
        destKeyStream.flush();
        return d;
    }

    public I2PSession createSession(InputStream destKeyStream, Properties options) throws I2PSessionException {
        return this.createSession(I2PAppContext.getGlobalContext(), destKeyStream, options);
    }

    public I2PSession createSession(I2PAppContext context, InputStream destKeyStream, Properties options) throws I2PSessionException {
        return new I2PSessionImpl2(context, destKeyStream, options);
    }
}

