/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;

class MessageStatusMessageHandler
extends HandlerImpl {
    public MessageStatusMessageHandler(I2PAppContext context) {
        super(context, 22);
    }

    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        boolean skipStatus = true;
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        MessageStatusMessage msg = (MessageStatusMessage)message;
        switch (msg.getStatus()) {
            case 0: {
                ReceiveMessageBeginMessage m = new ReceiveMessageBeginMessage();
                m.setMessageId(msg.getMessageId());
                m.setSessionId(msg.getSessionId());
                try {
                    session.sendMessage(m);
                }
                catch (I2PSessionException ise) {
                    this._log.error("Error asking for the message", ise);
                }
                return;
            }
            case 1: {
                session.receiveStatus((int)msg.getMessageId(), msg.getNonce(), msg.getStatus());
                return;
            }
            case 2: 
            case 4: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Message delivery succeeded for message " + msg.getMessageId());
                }
                session.receiveStatus((int)msg.getMessageId(), msg.getNonce(), msg.getStatus());
                return;
            }
            case 3: 
            case 5: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Message delivery FAILED for message " + msg.getMessageId());
                }
                session.receiveStatus((int)msg.getMessageId(), msg.getNonce(), msg.getStatus());
                return;
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Invalid message delivery status received: " + msg.getStatus());
        }
    }
}

