/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.AddressDB;
import net.i2p.data.Address;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

public class FilesystemAddressDB
extends AddressDB {
    public static final String PROP_ADDRESS_DIR = "i2p.addressdir";
    public static final String DEFAULT_ADDRESS_DIR = "addressDb";
    private static final Log _log = new Log(FilesystemAddressDB.class);

    public FilesystemAddressDB(I2PAppContext context) {
        super(context);
        String dir = this._context.getProperty(PROP_ADDRESS_DIR, DEFAULT_ADDRESS_DIR);
        File addrDir = new File(dir);
        if (!addrDir.exists()) {
            addrDir.mkdir();
            Properties hosts = new Properties();
            File hostsFile = new File("hosts.txt");
            if (hostsFile.exists() && hostsFile.canRead()) {
                try {
                    DataHelper.loadProps(hosts, hostsFile);
                }
                catch (IOException ioe) {
                    _log.error("Error loading hosts file " + hostsFile, ioe);
                }
            }
            for (String string : hosts.keySet()) {
                Address addr = new Address();
                addr.setHostname(string);
                addr.setDestination(hosts.getProperty(string));
                this.put(addr);
            }
        }
    }

    public Address get(String hostname) {
        String dir = this._context.getProperty(PROP_ADDRESS_DIR, DEFAULT_ADDRESS_DIR);
        File f = new File(dir, hostname);
        if (f.exists() && f.canRead()) {
            Address addr = new Address();
            try {
                addr.readBytes(new FileInputStream(f));
            }
            catch (FileNotFoundException exp) {
                return null;
            }
            catch (DataFormatException exp) {
                _log.error(f.getPath() + " is not a valid address file.");
                return null;
            }
            catch (IOException exp) {
                _log.error("Error reading " + f.getPath());
                return null;
            }
            return addr;
        }
        _log.warn(f.getPath() + " does not exist.");
        return null;
    }

    public Address put(Address address) {
        Address previous = this.get(address.getHostname());
        String dir = this._context.getProperty(PROP_ADDRESS_DIR, DEFAULT_ADDRESS_DIR);
        File f = new File(dir, address.getHostname());
        try {
            address.writeBytes(new FileOutputStream(f));
        }
        catch (Exception exp) {
            _log.error("Error writing " + f.getPath(), exp);
        }
        return previous;
    }

    public Address remove(String hostname) {
        Address previous = this.get(hostname);
        String dir = this._context.getProperty(PROP_ADDRESS_DIR, DEFAULT_ADDRESS_DIR);
        File f = new File(dir, hostname);
        f.delete();
        return previous;
    }

    public Address remove(Address address) {
        if (this.contains(address)) {
            return this.remove(address.getHostname());
        }
        return null;
    }

    public boolean contains(Address address) {
        Address inDb = this.get(address.getHostname());
        return inDb.equals(address);
    }

    public boolean contains(String hostname) {
        return this.hostnames().contains(hostname);
    }

    public Collection hostnames() {
        String dir = this._context.getProperty(PROP_ADDRESS_DIR, DEFAULT_ADDRESS_DIR);
        File f = new File(dir);
        return Arrays.asList(f.list());
    }
}

