/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.util.ArrayList;
import java.util.List;
import net.i2p.crypto.CryptixRijndael_Algorithm;

public final class CryptixAESKeyCache {
    private List _availableKeys = new ArrayList(64);
    private static final int KEYSIZE = 32;
    private static final int BLOCKSIZE = 16;
    private static final int ROUNDS = CryptixRijndael_Algorithm.getRounds(32, 16);
    private static final int BC = 4;
    private static final int KC = 8;
    private static final int MAX_KEYS = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final KeyCacheEntry acquireKey() {
        List list = this._availableKeys;
        synchronized (list) {
            if (this._availableKeys.size() > 0) {
                return (KeyCacheEntry)this._availableKeys.remove(0);
            }
        }
        return CryptixAESKeyCache.createNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseKey(KeyCacheEntry key) {
        List list = this._availableKeys;
        synchronized (list) {
            if (this._availableKeys.size() < 64) {
                this._availableKeys.add(key);
            }
        }
    }

    public static final KeyCacheEntry createNew() {
        KeyCacheEntry e = new KeyCacheEntry();
        e.Ke = new int[ROUNDS + 1][4];
        e.Kd = new int[ROUNDS + 1][4];
        e.tk = new int[8];
        e.key = new Object[]{e.Ke, e.Kd};
        return e;
    }

    public static final class KeyCacheEntry {
        int[][] Ke;
        int[][] Kd;
        int[] tk;
        Object[] key;
    }
}

