/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import gnu.crypto.hash.Sha256Standalone;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HMACGenerator;
import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;

public class HMAC256Generator
extends HMACGenerator {
    public HMAC256Generator(I2PAppContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HMac acquire() {
        List list = this._available;
        synchronized (list) {
            if (this._available.size() > 0) {
                return (HMac)this._available.remove(0);
            }
        }
        return new HMac(new Sha256ForMAC());
    }

    public static void main(String[] args) {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] data = new byte[64];
        ctx.random().nextBytes(data);
        SessionKey key = ctx.keyGenerator().generateSessionKey();
        Hash mac = ctx.hmac256().calculate(key, data);
        System.out.println(Base64.encode(mac.getData()));
    }

    private class Sha256ForMAC
    extends Sha256Standalone
    implements Digest {
        private Sha256ForMAC() {
        }

        public String getAlgorithmName() {
            return "sha256 for hmac";
        }

        public int getDigestSize() {
            return 32;
        }

        public int doFinal(byte[] out, int outOff) {
            byte[] rv = this.digest();
            System.arraycopy(rv, 0, out, outOff, rv.length);
            this.reset();
            return rv.length;
        }
    }
}

