/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class TransientSessionKeyManager
extends SessionKeyManager {
    private Log _log;
    private Map _outboundSessions;
    private Map _inboundTagSets;
    protected I2PAppContext _context;
    public static final long SESSION_TAG_DURATION_MS = 600000L;
    public static final long SESSION_LIFETIME_MAX_MS = 900000L;
    public static final int MAX_INBOUND_SESSION_TAGS = 500000;

    public TransientSessionKeyManager(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(TransientSessionKeyManager.class);
        this._context = context;
        this._outboundSessions = new HashMap(1024);
        this._inboundTagSets = new HashMap(1024);
        context.statManager().createRateStat("crypto.sessionTagsExpired", "How many tags/sessions are expired?", "Encryption", new long[]{600000L, 3600000L, 10800000L});
        context.statManager().createRateStat("crypto.sessionTagsRemaining", "How many tags/sessions are remaining after a cleanup?", "Encryption", new long[]{600000L, 3600000L, 10800000L});
        SimpleTimer.getInstance().addEvent(new CleanupEvent(), 60000L);
    }

    private TransientSessionKeyManager() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getInboundTagSets() {
        Map map = this._inboundTagSets;
        synchronized (map) {
            return new HashSet(this._inboundTagSets.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getOutboundSessions() {
        Map map = this._outboundSessions;
        synchronized (map) {
            return new HashSet(this._outboundSessions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData(Set inboundTagSets, Set outboundSessions) {
        if (this._log.shouldLog(20)) {
            this._log.info("Loading " + inboundTagSets.size() + " inbound tag sets, and " + outboundSessions.size() + " outbound sessions");
        }
        HashMap<SessionTag, TagSet> tagSets = new HashMap<SessionTag, TagSet>(inboundTagSets.size());
        for (TagSet ts : inboundTagSets) {
            for (SessionTag tag : ts.getTags()) {
                tagSets.put(tag, ts);
            }
        }
        Map iter = this._inboundTagSets;
        synchronized (iter) {
            this._inboundTagSets.clear();
            this._inboundTagSets.putAll(tagSets);
        }
        HashMap<PublicKey, OutboundSession> sessions = new HashMap<PublicKey, OutboundSession>(outboundSessions.size());
        for (OutboundSession sess : outboundSessions) {
            sessions.put(sess.getTarget(), sess);
        }
        Map map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.clear();
            this._outboundSessions.putAll(sessions);
        }
    }

    public SessionKey getCurrentKey(PublicKey target) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return null;
        }
        long now = this._context.clock().now();
        if (sess.getLastUsedDate() < now - 900000L) {
            if (this._log.shouldLog(20)) {
                this._log.info("Expiring old session key established on " + new Date(sess.getEstablishedDate()) + " but not used for " + (now - sess.getLastUsedDate()) + "ms with target " + target);
            }
            return null;
        }
        return sess.getCurrentKey();
    }

    public void createSession(PublicKey target, SessionKey key) {
        OutboundSession sess = new OutboundSession(target);
        sess.setCurrentKey(key);
        this.addSession(sess);
    }

    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No session for " + target);
            }
            return null;
        }
        if (sess.getCurrentKey().equals(key)) {
            SessionTag nxt = sess.consumeNext();
            if (this._log.shouldLog(10)) {
                this._log.debug("Tag consumed: " + nxt + " with key: " + key.toBase64());
            }
            return nxt;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Key does not match existing key, no tag");
        }
        return null;
    }

    public int getAvailableTags(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0;
        }
        if (sess.getCurrentKey().equals(key)) {
            return sess.availableTags();
        }
        return 0;
    }

    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0L;
        }
        if (sess.getCurrentKey().equals(key)) {
            long end = sess.getLastExpirationDate();
            if (end <= 0L) {
                return 0L;
            }
            return end - this._context.clock().now();
        }
        return 0L;
    }

    public void tagsDelivered(PublicKey target, SessionKey key, Set sessionTags) {
        OutboundSession sess;
        if (this._log.shouldLog(10) && sessionTags.size() > 0) {
            this._log.debug("Tags delivered: " + sessionTags.size() + " for key: " + key.toBase64() + ": " + sessionTags);
        }
        if ((sess = this.getSession(target)) == null) {
            this.createSession(target, key);
            sess = this.getSession(target);
        }
        sess.setCurrentKey(key);
        TagSet set = new TagSet(sessionTags, key, this._context.clock().now());
        sess.addTags(set);
    }

    public void failTags(PublicKey target) {
        this.removeSession(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tagsReceived(SessionKey key, Set sessionTags) {
        int overage = 0;
        TagSet tagSet = new TagSet(sessionTags, key, this._context.clock().now());
        TagSet old = null;
        SessionTag dupTag = null;
        for (SessionTag tag : sessionTags) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Receiving tag " + tag + " for key " + key.toBase64() + " / " + key.toString() + ": tagSet: " + tagSet);
            }
            Map map = this._inboundTagSets;
            synchronized (map) {
                old = this._inboundTagSets.put(tag, tagSet);
                overage = this._inboundTagSets.size() - 500000;
                if (old != null) {
                    if (!old.getAssociatedKey().equals(tagSet.getAssociatedKey())) {
                        this._inboundTagSets.remove(tag);
                        dupTag = tag;
                        break;
                    }
                    old = null;
                }
            }
        }
        if (old != null) {
            Map map = this._inboundTagSets;
            synchronized (map) {
                for (SessionTag tag : old.getTags()) {
                    this._inboundTagSets.remove(tag);
                }
                for (SessionTag tag : sessionTags) {
                    this._inboundTagSets.remove(tag);
                }
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple tags matching!  tagSet: " + tagSet + " and old tagSet: " + old + " tag: " + dupTag + "/" + dupTag.toBase64());
                this._log.warn("Earlier tag set creation: " + old + ": key=" + old.getAssociatedKey().toBase64(), old.getCreatedBy());
                this._log.warn("Current tag set creation: " + tagSet + ": key=" + tagSet.getAssociatedKey().toBase64(), tagSet.getCreatedBy());
            }
        }
        if (overage > 0) {
            this.clearExcess(overage);
        }
        if (sessionTags.size() <= 0 && this._log.shouldLog(10)) {
            this._log.debug("Received 0 tags for key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExcess(int overage) {
        long now = this._context.clock().now();
        int old = 0;
        int large = 0;
        int absurd = 0;
        int recent = 0;
        int tags = 0;
        int toRemove = overage * 2;
        ArrayList<TagSet> removed = new ArrayList<TagSet>(toRemove);
        Map map = this._inboundTagSets;
        synchronized (map) {
            for (TagSet set : this._inboundTagSets.values()) {
                int size = set.getTags().size();
                if (size > 1000) {
                    ++absurd;
                }
                if (size > 100) {
                    ++large;
                }
                if (now - set.getDate() > 900000L) {
                    ++old;
                } else if (now - set.getDate() < 60000L) {
                    ++recent;
                }
                if (removed.size() >= toRemove && now - set.getDate() <= 900000L) continue;
                removed.add(set);
            }
            for (int i = 0; i < removed.size(); ++i) {
                TagSet cur = (TagSet)removed.get(i);
                for (SessionTag tag : cur.getTags()) {
                    this._inboundTagSets.remove(tag);
                    ++tags;
                }
            }
        }
        if (this._log.shouldLog(50)) {
            this._log.log(50, "TOO MANY SESSION TAGS!  removing " + removed + " tag sets arbitrarily, with " + tags + " tags," + "where there are " + old + " long lasting sessions, " + recent + " ones created in the last minute, and " + large + " sessions with more than 100 tags (and " + absurd + " with more than 1000!), leaving a total of " + this._inboundTagSets.size() + " tags behind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionKey consumeTag(SessionTag tag) {
        Map map = this._inboundTagSets;
        synchronized (map) {
            TagSet tagSet = (TagSet)this._inboundTagSets.remove(tag);
            if (tagSet == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Cannot consume tag " + tag + " as it is not known");
                }
                return null;
            }
            tagSet.consume(tag);
            SessionKey key = tagSet.getAssociatedKey();
            if (this._log.shouldLog(10)) {
                this._log.debug("Consuming tag " + tag.toString() + " for sessionKey " + key.toBase64() + " / " + key.toString() + " on tagSet: " + tagSet);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundSession getSession(PublicKey target) {
        Map map = this._outboundSessions;
        synchronized (map) {
            return (OutboundSession)this._outboundSessions.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(OutboundSession sess) {
        Map map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.put(sess.getTarget(), sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(PublicKey target) {
        if (target == null) {
            return;
        }
        OutboundSession session = null;
        Map map = this._outboundSessions;
        synchronized (map) {
            session = (OutboundSession)this._outboundSessions.remove(target);
        }
        if (session != null && this._log.shouldLog(30)) {
            this._log.warn("Removing session tags with " + session.availableTags() + " available for " + (session.getLastExpirationDate() - this._context.clock().now()) + "ms more", new Exception("Removed by"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int aggressiveExpire() {
        Iterator iter;
        int removed = 0;
        int remaining = 0;
        long now = this._context.clock().now();
        StringBuffer buf = null;
        StringBuffer bufSummary = null;
        if (this._log.shouldLog(10)) {
            buf = new StringBuffer(128);
            buf.append("Expiring inbound: ");
            bufSummary = new StringBuffer(1024);
        }
        Map map = this._inboundTagSets;
        synchronized (map) {
            iter = this._inboundTagSets.keySet().iterator();
            while (iter.hasNext()) {
                SessionTag tag = (SessionTag)iter.next();
                TagSet ts = (TagSet)this._inboundTagSets.get(tag);
                long age = now - ts.getDate();
                if (age <= 900000L) continue;
                iter.remove();
                ++removed;
                if (buf == null) continue;
                buf.append(tag.toString()).append(" @ age ").append(DataHelper.formatDuration(age));
            }
            remaining = this._inboundTagSets.size();
        }
        this._context.statManager().addRateData("crypto.sessionTagsRemaining", remaining, 0L);
        if (buf != null && removed > 0) {
            this._log.debug(buf.toString());
        }
        if (bufSummary != null) {
            this._log.debug("Cleaning up with remaining: " + bufSummary.toString());
        }
        map = this._outboundSessions;
        synchronized (map) {
            iter = this._outboundSessions.keySet().iterator();
            while (iter.hasNext()) {
                PublicKey key = (PublicKey)iter.next();
                OutboundSession sess = (OutboundSession)this._outboundSessions.get(key);
                removed += sess.expireTags();
                if (sess.availableTags() > 0) continue;
                iter.remove();
                ++removed;
            }
        }
        return removed;
    }

    public String renderStatusHTML() {
        Set sets;
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<h2>Inbound sessions</h2>");
        buf.append("<table border=\"1\">");
        Set inbound = this.getInboundTagSets();
        HashMap inboundSets = new HashMap(inbound.size());
        for (TagSet ts : inbound) {
            if (!inboundSets.containsKey(ts.getAssociatedKey())) {
                inboundSets.put(ts.getAssociatedKey(), new HashSet());
            }
            sets = (Set)inboundSets.get(ts.getAssociatedKey());
            sets.add(ts);
        }
        for (SessionKey skey : inboundSets.keySet()) {
            sets = (Set)inboundSets.get(skey);
            buf.append("<tr><td><b>Session key</b>: ").append(skey.toBase64()).append("</td>");
            buf.append("<td><b># Sets:</b> ").append(sets.size()).append("</td></tr>");
            buf.append("<tr><td colspan=\"2\"><ul>");
            for (TagSet ts : sets) {
                buf.append("<li><b>Received on:</b> ").append(new Date(ts.getDate())).append(" with ").append(ts.getTags().size()).append(" tags remaining</li>");
            }
            buf.append("</ul></td></tr>");
        }
        buf.append("</table>");
        buf.append("<h2><b>Outbound sessions</b></h2>");
        buf.append("<table border=\"1\">");
        Set outbound = this.getOutboundSessions();
        for (OutboundSession sess : outbound) {
            buf.append("<tr><td><b>Target key:</b> ").append(sess.getTarget().toString()).append("<br />");
            buf.append("<b>Established:</b> ").append(new Date(sess.getEstablishedDate())).append("<br />");
            buf.append("<b>Last Used:</b> ").append(new Date(sess.getLastUsedDate())).append("<br />");
            buf.append("<b># Sets:</b> ").append(sess.getTagSets().size()).append("</td></tr>");
            buf.append("<tr><td><b>Session key:</b> ").append(sess.getCurrentKey().toBase64()).append("</td></tr>");
            buf.append("<tr><td><ul>");
            for (TagSet ts : sess.getTagSets()) {
                buf.append("<li><b>Sent on:</b> ").append(new Date(ts.getDate())).append(" with ").append(ts.getTags().size()).append(" tags remaining</li>");
            }
            buf.append("</ul></td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    static class TagSet {
        private Set _sessionTags;
        private SessionKey _key;
        private long _date;
        private Exception _createdBy;

        public TagSet(Set tags, SessionKey key, long date) {
            if (key == null) {
                throw new IllegalArgumentException("Missing key");
            }
            if (tags == null) {
                throw new IllegalArgumentException("Missing tags");
            }
            this._sessionTags = tags;
            this._key = key;
            this._date = date;
            long now = I2PAppContext.getGlobalContext().clock().now();
            this._createdBy = new Exception("Created by: key=" + this._key.toBase64() + " on " + new Date(now) + "/" + now + " via " + Thread.currentThread().getName());
        }

        public long getDate() {
            return this._date;
        }

        void setDate(long when) {
            this._date = when;
        }

        public Set getTags() {
            return this._sessionTags;
        }

        public SessionKey getAssociatedKey() {
            return this._key;
        }

        public boolean contains(SessionTag tag) {
            return this._sessionTags.contains(tag);
        }

        public void consume(SessionTag tag) {
            if (this.contains(tag)) {
                this._sessionTags.remove(tag);
            }
        }

        public SessionTag consumeNext() {
            if (this._sessionTags.size() <= 0) {
                return null;
            }
            SessionTag first = (SessionTag)this._sessionTags.iterator().next();
            this._sessionTags.remove(first);
            return first;
        }

        public Exception getCreatedBy() {
            return this._createdBy;
        }

        public int hashCode() {
            long rv = 0L;
            if (this._key != null) {
                rv = rv * 7L + (long)this._key.hashCode();
            }
            rv = rv * 7L + this._date;
            return (int)rv;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TagSet)) {
                return false;
            }
            TagSet ts = (TagSet)o;
            return DataHelper.eq(ts.getAssociatedKey(), this.getAssociatedKey()) && ts.getDate() == this.getDate();
        }
    }

    class OutboundSession {
        private PublicKey _target;
        private SessionKey _currentKey;
        private long _established;
        private long _lastUsed;
        private List _tagSets;

        public OutboundSession(PublicKey target) {
            this(target, null, transientSessionKeyManager._context.clock().now(), transientSessionKeyManager._context.clock().now(), new ArrayList());
        }

        OutboundSession(PublicKey target, SessionKey curKey, long established, long lastUsed, List tagSets) {
            this._target = target;
            this._currentKey = curKey;
            this._established = established;
            this._lastUsed = lastUsed;
            this._tagSets = tagSets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List getTagSets() {
            List list = this._tagSets;
            synchronized (list) {
                return new ArrayList(this._tagSets);
            }
        }

        public PublicKey getTarget() {
            return this._target;
        }

        public SessionKey getCurrentKey() {
            return this._currentKey;
        }

        public void setCurrentKey(SessionKey key) {
            this._lastUsed = TransientSessionKeyManager.this._context.clock().now();
            if (this._currentKey != null && !this._currentKey.equals(key)) {
                int dropped = 0;
                List sets = this._tagSets;
                this._tagSets = new ArrayList();
                for (int i = 0; i < sets.size(); ++i) {
                    TagSet set = (TagSet)sets.get(i);
                    dropped += set.getTags().size();
                }
                if (TransientSessionKeyManager.this._log.shouldLog(20)) {
                    TransientSessionKeyManager.this._log.info("Rekeyed from " + this._currentKey + " to " + key + ": dropping " + dropped + " session tags");
                }
            }
            this._currentKey = key;
        }

        public long getEstablishedDate() {
            return this._established;
        }

        public long getLastUsedDate() {
            return this._lastUsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int expireTags() {
            long now = TransientSessionKeyManager.this._context.clock().now();
            int removed = 0;
            List list = this._tagSets;
            synchronized (list) {
                for (int i = 0; i < this._tagSets.size(); ++i) {
                    TagSet set = (TagSet)this._tagSets.get(i);
                    if (set.getDate() + 600000L > now) continue;
                    this._tagSets.remove(i);
                    --i;
                    ++removed;
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionTag consumeNext() {
            long now;
            this._lastUsed = now = TransientSessionKeyManager.this._context.clock().now();
            List list = this._tagSets;
            synchronized (list) {
                while (this._tagSets.size() > 0) {
                    TagSet set = (TagSet)this._tagSets.get(0);
                    if (set.getDate() + 600000L > now) {
                        SessionTag tag = set.consumeNext();
                        if (tag != null) {
                            return tag;
                        }
                    } else if (TransientSessionKeyManager.this._log.shouldLog(20)) {
                        TransientSessionKeyManager.this._log.info("TagSet from " + new Date(set.getDate()) + " expired");
                    }
                    this._tagSets.remove(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int availableTags() {
            int tags = 0;
            long now = TransientSessionKeyManager.this._context.clock().now();
            List list = this._tagSets;
            synchronized (list) {
                for (int i = 0; i < this._tagSets.size(); ++i) {
                    TagSet set = (TagSet)this._tagSets.get(i);
                    if (set.getDate() + 600000L <= now) continue;
                    tags += set.getTags().size();
                }
            }
            return tags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastExpirationDate() {
            long last = 0L;
            List list = this._tagSets;
            synchronized (list) {
                for (TagSet set : this._tagSets) {
                    if (set.getDate() <= last || set.getTags().size() <= 0) continue;
                    last = set.getDate();
                }
            }
            if (last > 0L) {
                return last + 600000L;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTags(TagSet set) {
            this._lastUsed = TransientSessionKeyManager.this._context.clock().now();
            List list = this._tagSets;
            synchronized (list) {
                this._tagSets.add(set);
            }
        }
    }

    private class CleanupEvent
    implements SimpleTimer.TimedEvent {
        private CleanupEvent() {
        }

        public void timeReached() {
            long beforeExpire = TransientSessionKeyManager.this._context.clock().now();
            int expired = TransientSessionKeyManager.this.aggressiveExpire();
            long expireTime = TransientSessionKeyManager.this._context.clock().now() - beforeExpire;
            TransientSessionKeyManager.this._context.statManager().addRateData("crypto.sessionTagsExpired", expired, expireTime);
            SimpleTimer.getInstance().addEvent(this, 60000L);
        }
    }
}

