/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.PublicKey;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;

public class LeaseSet
extends DataStructureImpl {
    private static final Log _log = new Log(LeaseSet.class);
    private Destination _destination;
    private PublicKey _encryptionKey;
    private SigningPublicKey _signingKey;
    private List _leases;
    private Signature _signature;
    private volatile Hash _currentRoutingKey;
    private volatile byte[] _routingKeyGenMod;
    private boolean _receivedAsPublished;
    private long _firstExpiration;
    private long _lastExpiration;
    private static final int MAX_LEASES = 6;

    public LeaseSet() {
        this.setDestination(null);
        this.setEncryptionKey(null);
        this.setSigningKey(null);
        this.setSignature(null);
        this.setRoutingKey(null);
        this._leases = new ArrayList();
        this._routingKeyGenMod = null;
        this._receivedAsPublished = false;
        this._firstExpiration = Long.MAX_VALUE;
        this._lastExpiration = 0L;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination dest) {
        this._destination = dest;
    }

    public PublicKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public void setEncryptionKey(PublicKey encryptionKey) {
        this._encryptionKey = encryptionKey;
    }

    public SigningPublicKey getSigningKey() {
        return this._signingKey;
    }

    public void setSigningKey(SigningPublicKey key) {
        this._signingKey = key;
    }

    public boolean getReceivedAsPublished() {
        return this._receivedAsPublished;
    }

    public void setReceivedAsPublished(boolean received) {
        this._receivedAsPublished = received;
    }

    public void addLease(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("erm, null lease");
        }
        if (lease.getGateway() == null) {
            throw new IllegalArgumentException("erm, lease has no gateway");
        }
        if (lease.getTunnelId() == null) {
            throw new IllegalArgumentException("erm, lease has no tunnel");
        }
        if (this._leases.size() > 6) {
            throw new IllegalArgumentException("Too many leases - max is 6");
        }
        this._leases.add(lease);
        long expire = lease.getEndDate().getTime();
        if (expire < this._firstExpiration) {
            this._firstExpiration = expire;
        }
        if (expire > this._lastExpiration) {
            this._lastExpiration = expire;
        }
    }

    public int getLeaseCount() {
        return this._leases.size();
    }

    public Lease getLease(int index) {
        return (Lease)this._leases.get(index);
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature sig) {
        this._signature = sig;
    }

    public Hash getRoutingKey() {
        RoutingKeyGenerator gen = RoutingKeyGenerator.getInstance();
        if (gen.getModData() == null || this._routingKeyGenMod == null || !DataHelper.eq(gen.getModData(), this._routingKeyGenMod)) {
            this.setRoutingKey(gen.getRoutingKey(this.getDestination().calculateHash()));
            this._routingKeyGenMod = gen.getModData();
        }
        return this._currentRoutingKey;
    }

    public void setRoutingKey(Hash key) {
        this._currentRoutingKey = key;
    }

    public boolean validateRoutingKey() {
        Hash destKey = this.getDestination().calculateHash();
        Hash rk = RoutingKeyGenerator.getInstance().getRoutingKey(destKey);
        return rk.equals(this.getRoutingKey());
    }

    public long getEarliestLeaseDate() {
        if (this._leases.size() <= 0) {
            return -1L;
        }
        return this._firstExpiration;
    }

    public void sign(SigningPrivateKey key) throws DataFormatException {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            throw new DataFormatException("Not enough data to sign");
        }
        Signature sig = DSAEngine.getInstance().sign(bytes, key);
        this.setSignature(sig);
    }

    public boolean verifySignature() {
        if (this.getSignature() == null) {
            return false;
        }
        if (this.getDestination() == null) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        boolean signedByDest = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this.getDestination().getSigningPublicKey());
        boolean signedByRevoker = false;
        if (!signedByDest) {
            signedByRevoker = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this._signingKey);
        }
        return signedByDest || signedByRevoker;
    }

    public boolean verifySignature(SigningPublicKey signingKey) {
        if (this.getSignature() == null) {
            return false;
        }
        if (this.getDestination() == null) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        boolean signedByDest = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this.getDestination().getSigningPublicKey());
        boolean signedByRevoker = false;
        if (!signedByDest) {
            signedByRevoker = DSAEngine.getInstance().verifySignature(this.getSignature(), data, signingKey);
        }
        return signedByDest || signedByRevoker;
    }

    public boolean isCurrent(long fudge) {
        long now = Clock.getInstance().now();
        return this._lastExpiration > now - fudge;
    }

    private byte[] getBytes() {
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._leases == null) {
            return null;
        }
        int len = 773 + this._leases.size() * 44;
        ByteArrayOutputStream out = new ByteArrayOutputStream(len);
        try {
            this._destination.writeBytes(out);
            this._encryptionKey.writeBytes(out);
            this._signingKey.writeBytes(out);
            DataHelper.writeLong(out, 1, this._leases.size());
            for (Lease lease : this._leases) {
                lease.writeBytes(out);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        catch (DataFormatException dfe) {
            return null;
        }
        byte[] rv = out.toByteArray();
        return rv;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._destination = new Destination();
        this._destination.readBytes(in);
        this._encryptionKey = new PublicKey();
        this._encryptionKey.readBytes(in);
        this._signingKey = new SigningPublicKey();
        this._signingKey.readBytes(in);
        int numLeases = (int)DataHelper.readLong(in, 1);
        if (numLeases > 6) {
            throw new DataFormatException("Too many leases - max is 6");
        }
        this._leases.clear();
        for (int i = 0; i < numLeases; ++i) {
            Lease lease = new Lease();
            lease.readBytes(in);
            this.addLease(lease);
        }
        this._signature = new Signature();
        this._signature.readBytes(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._leases == null || this._signature == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this._destination.writeBytes(out);
        this._encryptionKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        DataHelper.writeLong(out, 1, this._leases.size());
        for (Lease lease : this._leases) {
            lease.writeBytes(out);
        }
        this._signature.writeBytes(out);
    }

    public int size() {
        return 771 + this._leases.size() * 44;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LeaseSet)) {
            return false;
        }
        LeaseSet ls = (LeaseSet)object;
        return DataHelper.eq(this.getEncryptionKey(), ls.getEncryptionKey()) && DataHelper.eq(this._leases, ls._leases) && DataHelper.eq(this.getSignature(), ls.getSignature()) && DataHelper.eq(this.getSigningKey(), ls.getSigningKey()) && DataHelper.eq(this.getDestination(), ls.getDestination());
    }

    public int hashCode() {
        return DataHelper.hashCode(this.getEncryptionKey()) + DataHelper.hashCode(this._leases) + DataHelper.hashCode(this.getSignature()) + DataHelper.hashCode(this.getSigningKey()) + DataHelper.hashCode(this.getDestination());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("[LeaseSet: ");
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tEncryptionKey: ").append(this.getEncryptionKey());
        buf.append("\n\tSigningKey: ").append(this.getSigningKey());
        buf.append("\n\tSignature: ").append(this.getSignature());
        buf.append("\n\tLeases: #").append(this.getLeaseCount());
        for (int i = 0; i < this.getLeaseCount(); ++i) {
            buf.append("\n\t\tLease (").append(i).append("): ").append(this.getLease(i));
        }
        buf.append("]");
        return buf.toString();
    }
}

