/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.crypto.KeyGenerator;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;

public class SigningPrivateKey
extends DataStructureImpl {
    private static final Log _log = new Log(SigningPrivateKey.class);
    private byte[] _data;
    public static final int KEYSIZE_BYTES = 20;

    public SigningPrivateKey() {
        this((byte[])null);
    }

    public SigningPrivateKey(byte[] data) {
        this.setData(data);
    }

    public SigningPrivateKey(String base64Data) throws DataFormatException {
        this();
        this.fromBase64(base64Data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._data = new byte[20];
        int read = this.read(in, this._data);
        if (read != 20) {
            throw new DataFormatException("Not enough bytes to read the private key");
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data in the private key to write out");
        }
        if (this._data.length != 20) {
            throw new DataFormatException("Invalid size of data in the private key");
        }
        out.write(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SigningPrivateKey)) {
            return false;
        }
        return DataHelper.eq(this._data, ((SigningPrivateKey)obj)._data);
    }

    public int hashCode() {
        return DataHelper.hashCode(this._data);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("[SigningPrivateKey: ");
        if (this._data == null) {
            buf.append("null key");
        } else {
            buf.append("size: ").append(this._data.length);
        }
        buf.append("]");
        return buf.toString();
    }

    public SigningPublicKey toPublic() {
        return KeyGenerator.getSigningPublicKey(this);
    }
}

