/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.util.Log;

public class ReceiveMessageEndMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(ReceiveMessageEndMessage.class);
    public static final int MESSAGE_TYPE = 7;
    private long _sessionId;
    private long _messageId;

    public ReceiveMessageEndMessage() {
        this.setSessionId(-1L);
        this.setMessageId(-1L);
    }

    public long getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(long id) {
        this._sessionId = id;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId < 0L || this._messageId < 0L) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        byte[] rv = new byte[6];
        DataHelper.toLong(rv, 0, 2, this._sessionId);
        DataHelper.toLong(rv, 2, 4, this._messageId);
        return rv;
    }

    public int getType() {
        return 7;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ReceiveMessageEndMessage) {
            ReceiveMessageEndMessage msg = (ReceiveMessageEndMessage)object;
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getMessageId(), msg.getMessageId());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ReceiveMessageEndMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tMessageId: ").append(this.getMessageId());
        buf.append("]");
        return buf.toString();
    }
}

