/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import net.i2p.stat.Frequency;
import net.i2p.stat.Rate;

public class SizeTest {
    public static void main(String[] args) {
        SizeTest.testRateSize(100);
        SizeTest.testRateSize(100000);
        SizeTest.testRateSize(440000);
    }

    private static void testRateSize(int num) {
        int i;
        Runtime.getRuntime().gc();
        Rate[] rate = new Rate[num];
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long usedPer = used / (long)num;
        System.out.println(num + ": create array - Used: " + used + " bytes (or " + usedPer + " bytes per array entry)");
        try {
            for (i = 0; i < num; ++i) {
                rate[i] = new Rate(1234L);
            }
        }
        catch (OutOfMemoryError oom) {
            rate = null;
            Runtime.getRuntime().gc();
            System.out.println("Ran out of memory when creating rate " + i);
            return;
        }
        Runtime.getRuntime().gc();
        long usedObjects = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        usedPer = usedObjects / (long)num;
        System.out.println(num + ": create objects - Used: " + usedObjects + " bytes (or " + usedPer + " bytes per rate)");
        rate = null;
        Runtime.getRuntime().gc();
    }

    private static void testFrequencySize(int num) {
        Runtime.getRuntime().gc();
        Frequency[] freq = new Frequency[num];
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long usedPer = used / (long)num;
        System.out.println(num + ": create array - Used: " + used + " bytes (or " + usedPer + " bytes per array entry)");
        for (int i = 0; i < num; ++i) {
            freq[i] = new Frequency(1234L);
        }
        Runtime.getRuntime().gc();
        long usedObjects = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        usedPer = usedObjects / (long)num;
        System.out.println(num + ": create objects - Used: " + usedObjects + " bytes (or " + usedPer + " bytes per frequency)");
        freq = null;
        Runtime.getRuntime().gc();
    }
}

