/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.stat.BufferedStatLog;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatLog;
import net.i2p.util.Log;

public class StatManager {
    private Log _log;
    private I2PAppContext _context;
    private Map _frequencyStats;
    private Map _rateStats;
    private StatLog _statLog;
    public static final String PROP_STAT_FILTER = "stat.logFilters";
    public static final String PROP_STAT_FILE = "stat.logFile";
    public static final String DEFAULT_STAT_FILE = "stats.log";
    public static final String PROP_STAT_FULL = "stat.full";
    public static final String DEFAULT_STAT_FULL = "true";
    public static final String PROP_STAT_REQUIRED = "stat.required";
    public static final String DEFAULT_STAT_REQUIRED = "bw.recvRate,bw.sendBps,bw.sendRate,client.sendAckTime,clock.skew,crypto.elGamal.encrypt,jobQueue.jobLag,netDb.successTime,router.fastPeers,prng.bufferFillTime,prng.bufferWaitTime,transport.receiveMessageSize,transport.sendMessageSize,transport.sendProcessingTime,tunnel.acceptLoad,tunnel.buildRequestTime,tunnel.rejectOverloaded,tunnel.rejectTimeouttunnel.buildClientExpire,tunnel.buildClientReject,tunnel.buildClientSuccess,tunnel.buildExploratoryExpire,tunnel.buildExploratoryReject,tunnel.buildExploratorySuccess,tunnel.buildRatio.*,tunnel.corruptMessage,tunnel.decryptRequestTime,tunnel.fragmentedDropped,tunnel.participatingMessageCount,tunnel.participatingTunnels,tunnel.testFailedTime,tunnel.testSuccessTime,tunnel.participatingBandwidth,udp.sendPacketSize,udp.packetsRetransmitted";

    public StatManager(I2PAppContext context) {
        this._log = context.logManager().getLog(StatManager.class);
        this._context = context;
        this._frequencyStats = Collections.synchronizedMap(new HashMap(128));
        this._rateStats = new HashMap(128);
        this._statLog = new BufferedStatLog(context);
    }

    public StatLog getStatLog() {
        return this._statLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatLog(StatLog log) {
        this._statLog = log;
        Map map = this._rateStats;
        synchronized (map) {
            for (RateStat rs : this._rateStats.values()) {
                rs.setStatLog(log);
            }
        }
    }

    public void createFrequencyStat(String name, String description, String group, long[] periods) {
        if (this.ignoreStat(name)) {
            return;
        }
        if (this._frequencyStats.containsKey(name)) {
            return;
        }
        this._frequencyStats.put(name, new FrequencyStat(name, description, group, periods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRateStat(String name, String description, String group, long[] periods) {
        if (this.ignoreStat(name)) {
            return;
        }
        Map map = this._rateStats;
        synchronized (map) {
            if (this._rateStats.containsKey(name)) {
                return;
            }
            RateStat rs = new RateStat(name, description, group, periods);
            if (this._statLog != null) {
                rs.setStatLog(this._statLog);
            }
            this._rateStats.put(name, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateStat(String name) {
        Map map = this._rateStats;
        synchronized (map) {
            this._rateStats.remove(name);
        }
    }

    public void updateFrequency(String name) {
        FrequencyStat freq = (FrequencyStat)this._frequencyStats.get(name);
        if (freq != null) {
            freq.eventOccurred();
        }
    }

    public void addRateData(String name, long data, long eventDuration) {
        RateStat stat = (RateStat)this._rateStats.get(name);
        if (stat != null) {
            stat.addData(data, eventDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalesceStats() {
        Map map = this._frequencyStats;
        synchronized (map) {
            for (Object stat : this._frequencyStats.values()) {
                if (stat == null) continue;
                ((FrequencyStat)stat).coalesceStats();
            }
        }
        map = this._rateStats;
        synchronized (map) {
            for (Object stat : this._rateStats.values()) {
                if (stat == null) continue;
                ((RateStat)stat).coalesceStats();
            }
        }
    }

    public FrequencyStat getFrequency(String name) {
        return (FrequencyStat)this._frequencyStats.get(name);
    }

    public RateStat getRate(String name) {
        return (RateStat)this._rateStats.get(name);
    }

    public Set getFrequencyNames() {
        return new HashSet(this._frequencyStats.keySet());
    }

    public Set getRateNames() {
        return new HashSet(this._rateStats.keySet());
    }

    public boolean isRate(String statName) {
        return this._rateStats.containsKey(statName);
    }

    public boolean isFrequency(String statName) {
        return this._frequencyStats.containsKey(statName);
    }

    public Map getStatsByGroup() {
        Set names;
        TreeMap groups = new TreeMap();
        for (Object stat : this._frequencyStats.values()) {
            if (!groups.containsKey(((FrequencyStat)stat).getGroupName())) {
                groups.put(((FrequencyStat)stat).getGroupName(), new TreeSet());
            }
            names = (Set)groups.get(((FrequencyStat)stat).getGroupName());
            names.add(((FrequencyStat)stat).getName());
        }
        for (Object stat : this._rateStats.values()) {
            if (!groups.containsKey(((RateStat)stat).getGroupName())) {
                groups.put(((RateStat)stat).getGroupName(), new TreeSet());
            }
            names = (Set)groups.get(((RateStat)stat).getGroupName());
            names.add(((RateStat)stat).getName());
        }
        return groups;
    }

    public String getStatFilter() {
        return this._context.getProperty(PROP_STAT_FILTER);
    }

    public String getStatFile() {
        return this._context.getProperty(PROP_STAT_FILE, DEFAULT_STAT_FILE);
    }

    public boolean ignoreStat(String statName) {
        if (this._context.getProperty(PROP_STAT_FULL, DEFAULT_STAT_FULL).equalsIgnoreCase(DEFAULT_STAT_FULL)) {
            return false;
        }
        String required = this._context.getProperty(PROP_STAT_REQUIRED, DEFAULT_STAT_REQUIRED);
        String[] req = required.split(",");
        for (int i = 0; i < req.length; ++i) {
            if (req[i].equals(statName)) {
                return false;
            }
            if (!req[i].endsWith("*") || !statName.startsWith(req[i].substring(0, req[i].length() - 2))) continue;
            return false;
        }
        return true;
    }
}

