/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    public static final boolean rmdir(String path, boolean failIfNotEmpty) {
        return FileUtil.rmdir(new File(path), failIfNotEmpty);
    }

    public static final boolean rmdir(File target, boolean failIfNotEmpty) {
        if (!target.exists()) {
            return true;
        }
        if (!target.isDirectory()) {
            return target.delete();
        }
        File[] children = target.listFiles();
        if (children == null) {
            return false;
        }
        if (failIfNotEmpty && children.length > 0) {
            return false;
        }
        for (int i = 0; i < children.length; ++i) {
            if (FileUtil.rmdir(children[i], failIfNotEmpty)) continue;
            return false;
        }
        return target.delete();
    }

    public static boolean extractZip(File zipfile, File targetDir) {
        try {
            byte[] buf = new byte[16384];
            ZipFile zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                boolean parentsOk;
                ZipEntry entry = entries.nextElement();
                if (entry.getName().indexOf("..") != -1) {
                    System.err.println("ERROR: Refusing to extract a zip entry with '..' in it [" + entry.getName() + "]");
                    return false;
                }
                File target = new File(targetDir, entry.getName());
                File parent = target.getParentFile();
                if (parent != null && !parent.exists() && !(parentsOk = parent.mkdirs())) {
                    System.err.println("ERROR: Unable to create the parent dir for " + entry.getName() + ": [" + parent.getAbsolutePath() + "]");
                    return false;
                }
                if (entry.isDirectory()) {
                    if (target.exists()) continue;
                    boolean created = target.mkdirs();
                    if (!created) {
                        System.err.println("ERROR: Unable to create the directory [" + entry.getName() + "]");
                        return false;
                    }
                    System.err.println("INFO: Creating directory [" + entry.getName() + "]");
                    continue;
                }
                try {
                    InputStream in = zip.getInputStream(entry);
                    FileOutputStream fos = new FileOutputStream(target);
                    int read = 0;
                    while ((read = in.read(buf)) != -1) {
                        fos.write(buf, 0, read);
                    }
                    fos.close();
                    in.close();
                    System.err.println("INFO: File [" + entry.getName() + "] extracted");
                }
                catch (IOException ioe) {
                    System.err.println("ERROR: Error extracting the zip entry (" + entry.getName() + "]");
                    ioe.printStackTrace();
                    return false;
                }
            }
            zip.close();
            return true;
        }
        catch (IOException ioe) {
            System.err.println("ERROR: Unable to extract the zip file");
            ioe.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String filename, int maxNumLines, boolean startAtBeginning) {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            ArrayList<String> lines = new ArrayList<String>(maxNumLines > 0 ? maxNumLines : 64);
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
                if (maxNumLines <= 0 || lines.size() < maxNumLines) continue;
                if (startAtBeginning) break;
                lines.remove(0);
            }
            StringBuffer buf = new StringBuffer(lines.size() * 80);
            for (int i = 0; i < lines.size(); ++i) {
                buf.append((String)lines.get(i)).append('\n');
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(String path, String root, OutputStream out) throws IOException {
        String rootDirStr;
        File rootDir = new File(root);
        while (path.startsWith("/") && path.length() > 0) {
            path = path.substring(1);
        }
        if (path.length() <= 0) {
            throw new FileNotFoundException("Not serving up the root dir");
        }
        File target = new File(rootDir, path);
        if (!target.exists()) {
            throw new FileNotFoundException("Requested file does not exist: " + path);
        }
        String targetStr = target.getCanonicalPath();
        if (!targetStr.startsWith(rootDirStr = rootDir.getCanonicalPath())) {
            throw new FileNotFoundException("Requested file is outside the root dir: " + path);
        }
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        try {
            in = new FileInputStream(target);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            out.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean copy(String source, String dest, boolean overwriteExisting) {
        File src = new File(source);
        File dst = new File(dest);
        if (dst.exists() && dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        if (!src.exists()) {
            return false;
        }
        if (dst.exists() && !overwriteExisting) {
            return false;
        }
        byte[] buf = new byte[4096];
        try {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        boolean copied;
        if (args == null || args.length < 2) {
            FileUtil.testRmdir();
        } else if ("delete".equals(args[0])) {
            boolean deleted = FileUtil.rmdir(args[1], false);
            if (!deleted) {
                System.err.println("Error deleting [" + args[1] + "]");
            }
        } else if ("copy".equals(args[0]) && !(copied = FileUtil.copy(args[1], args[2], false))) {
            System.err.println("Error copying [" + args[1] + "] to [" + args[2] + "]");
        }
    }

    private static void testRmdir() {
        File t = new File("rmdirTest/test/subdir/blah");
        boolean created = t.mkdirs();
        if (!t.exists()) {
            throw new RuntimeException("Unable to create test");
        }
        boolean deleted = FileUtil.rmdir("rmdirTest", false);
        if (!deleted) {
            System.err.println("FAIL: unable to delete rmdirTest");
        } else {
            System.out.println("PASS: rmdirTest deleted");
        }
    }
}

