/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import net.i2p.util.Log;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;

class LogRecordFormatter {
    private static final String NL = System.getProperty("line.separator");
    private static final int MAX_WHERE_LENGTH = 30;
    private static final int MAX_THREAD_LENGTH = 12;
    private static final int MAX_PRIORITY_LENGTH = 5;

    LogRecordFormatter() {
    }

    public static String formatRecord(LogManager manager, LogRecord rec) {
        int size = 128 + rec.getMessage().length();
        if (rec.getThrowable() != null) {
            size += 512;
        }
        StringBuffer buf = new StringBuffer(size);
        char[] format = manager.getFormat();
        block9: for (int i = 0; i < format.length; ++i) {
            switch (format[i]) {
                case 'd': {
                    buf.append(LogRecordFormatter.getWhen(manager, rec));
                    continue block9;
                }
                case 'c': {
                    buf.append(LogRecordFormatter.getWhere(rec));
                    continue block9;
                }
                case 't': {
                    buf.append(LogRecordFormatter.getThread(rec));
                    continue block9;
                }
                case 'p': {
                    buf.append(LogRecordFormatter.getPriority(rec));
                    continue block9;
                }
                case 'm': {
                    buf.append(LogRecordFormatter.getWhat(rec));
                    continue block9;
                }
                default: {
                    buf.append(format[i]);
                }
            }
        }
        buf.append(NL);
        if (rec.getThrowable() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            PrintWriter pw = new PrintWriter(baos, true);
            rec.getThrowable().printStackTrace(pw);
            try {
                pw.flush();
                baos.flush();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            byte[] tb = baos.toByteArray();
            buf.append(new String(tb));
        }
        return buf.toString();
    }

    private static String getThread(LogRecord logRecord) {
        return LogRecordFormatter.toString(logRecord.getThreadName(), 12);
    }

    private static String getWhen(LogManager manager, LogRecord logRecord) {
        return manager.getDateFormat().format(new Date(logRecord.getDate()));
    }

    private static String getPriority(LogRecord rec) {
        return LogRecordFormatter.toString(Log.toLevelString(rec.getPriority()), 5);
    }

    private static String getWhat(LogRecord rec) {
        return rec.getMessage();
    }

    private static String getWhere(LogRecord rec) {
        String src;
        String string = src = rec.getSource() != null ? rec.getSource().getName() : rec.getSourceName();
        if (src == null) {
            src = "<none>";
        }
        return LogRecordFormatter.toString(src, 30);
    }

    private static String toString(String str, int size) {
        StringBuffer buf = new StringBuffer();
        if (str == null) {
            str = "";
        }
        if (str.length() > size) {
            str = str.substring(str.length() - size);
        }
        buf.append(str);
        while (buf.length() < size) {
            buf.append(' ');
        }
        return buf.toString();
    }
}

