/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;

public class LookaheadInputStream
extends FilterInputStream {
    private boolean _eofReached = false;
    private byte[] _footerLookahead;
    private static final InputStream _fakeInputStream = new ByteArrayInputStream(new byte[0]);

    public LookaheadInputStream(int lookaheadSize) {
        super(_fakeInputStream);
        this._footerLookahead = new byte[lookaheadSize];
    }

    public boolean getEOFReached() {
        return this._eofReached;
    }

    public void initialize(InputStream src) throws IOException {
        int read;
        this.in = src;
        this._eofReached = false;
        Arrays.fill(this._footerLookahead, (byte)0);
        for (int footerRead = 0; footerRead < this._footerLookahead.length; footerRead += read) {
            read = this.in.read(this._footerLookahead);
            if (read != -1) continue;
            throw new IOException("EOF reading the footer lookahead");
        }
        boolean f = true;
    }

    public int read() throws IOException {
        if (this._eofReached) {
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            this._eofReached = true;
            return -1;
        }
        int rv = this._footerLookahead[0];
        System.arraycopy(this._footerLookahead, 1, this._footerLookahead, 0, this._footerLookahead.length - 1);
        this._footerLookahead[this._footerLookahead.length - 1] = (byte)c;
        if (rv < 0) {
            rv += 256;
        }
        return rv;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._eofReached) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            buf[off + i] = (byte)c;
        }
        return len;
    }

    public byte[] getFooter() {
        return this._footerLookahead;
    }

    public static void main(String[] args) {
        byte[] buf = new byte[32];
        for (int i = 0; i < 32; ++i) {
            buf[i] = (byte)i;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        try {
            int i;
            LookaheadInputStream lis = new LookaheadInputStream(8);
            lis.initialize(bais);
            byte[] rbuf = new byte[32];
            int read = lis.read(rbuf);
            if (read != 24) {
                throw new RuntimeException("Should have stopped (read=" + read + ")");
            }
            for (i = 0; i < 24; ++i) {
                if (rbuf[i] == (byte)i) continue;
                throw new RuntimeException("Error at " + i + " [" + rbuf[i] + "]");
            }
            for (i = 0; i < 8; ++i) {
                if (lis.getFooter()[i] == (byte)(i + 24)) continue;
                throw new RuntimeException("Error at footer " + i + " [" + lis.getFooter()[i] + "]");
            }
            System.out.println("Everything is fine in general");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 9; i < 32768 && LookaheadInputStream.test(i); ++i) {
        }
    }

    private static boolean test(int size) {
        byte[] buf = new byte[size];
        new Random().nextBytes(buf);
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        try {
            int i;
            LookaheadInputStream lis = new LookaheadInputStream(8);
            lis.initialize(bais);
            byte[] rbuf = new byte[size];
            int read = lis.read(rbuf);
            if (read != size - 8) {
                throw new RuntimeException("Should have stopped (read=" + read + ")");
            }
            for (i = 0; i < size - 8; ++i) {
                if (rbuf[i] == buf[i]) continue;
                throw new RuntimeException("Error at " + i + " [" + rbuf[i] + "]");
            }
            for (i = 0; i < 8; ++i) {
                if (lis.getFooter()[i] == buf[i + (size - 8)]) continue;
                throw new RuntimeException("Error at footer " + i + " [" + lis.getFooter()[i] + "]");
            }
            System.out.println("Everything is fine at size=" + size);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

