/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class OrderedProperties
extends Properties {
    private static final Log _log = new Log(OrderedProperties.class);
    private TreeSet _order;
    private Map _data;
    private Object _lock = new Object();

    public OrderedProperties() {
        this._order = new TreeSet();
        this._data = new HashMap();
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this._lock;
        synchronized (object) {
            return this._data.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object object = this._lock;
        synchronized (object) {
            return this._data.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof OrderedProperties) {
            Object object = this._lock;
            synchronized (object) {
                return ((Object)this._data).equals(obj);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this._lock;
        synchronized (object) {
            return ((Object)this._data).hashCode();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String getProperty(String key) {
        return this.getProperty((Object)key);
    }

    public Object get(Object key) {
        return this.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(Object key) {
        if (key == null) {
            return null;
        }
        Object object = this._lock;
        synchronized (object) {
            Object rv = this._data.get(key);
            if (rv != null && rv instanceof String) {
                return (String)rv;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(String key, String val) {
        if (key == null || val == null) {
            throw new IllegalArgumentException("Null values are not supported");
        }
        Object object = this._lock;
        synchronized (object) {
            this._order.add(key);
            String rv = this._data.put(key, val);
            return rv;
        }
    }

    public Object put(Object key, Object val) {
        if (key == null || val == null) {
            throw new NullPointerException("Null values or keys are not allowed");
        }
        if (!(key instanceof String) || !(val instanceof String)) {
            throw new IllegalArgumentException("Key or value is not a string");
        }
        return this.setProperty((String)key, (String)val);
    }

    public void putAll(Map data) {
        if (data == null) {
            return;
        }
        for (Map.Entry entry : data.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            this.put(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this._lock;
        synchronized (object) {
            OrderedProperties rv = new OrderedProperties();
            rv.putAll((Map)this);
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._order.clear();
            this._data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            return this._order.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this._lock;
        synchronized (object) {
            this._order.remove(key);
            Object rv = this._data.remove(key);
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Object object = this._lock;
        synchronized (object) {
            return Collections.unmodifiableSortedSet((TreeSet)this._order.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Object object = this._lock;
        synchronized (object) {
            return Collections.unmodifiableSet(this.buildEntrySet((TreeSet)this._order.clone()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        Object object = this._lock;
        synchronized (object) {
            ArrayList values = new ArrayList(this._data.size());
            Iterator iter = this._data.values().iterator();
            while (iter.hasNext()) {
                values.add(iter.next());
            }
            return values;
        }
    }

    public Enumeration elements() {
        return Collections.enumeration(this.values());
    }

    public Enumeration keys() {
        return Collections.enumeration(this.keySet());
    }

    public Enumeration propertyNames() {
        return Collections.enumeration(this.keySet());
    }

    public void list(PrintStream out) {
    }

    public void list(PrintWriter out) {
    }

    public void load(InputStream in) {
    }

    public void store(OutputStream out, String header) {
    }

    private Set buildEntrySet(Set data) {
        TreeSet<StringMapEntry> ts = new TreeSet<StringMapEntry>();
        for (String key : data) {
            String val = this.getProperty(key);
            ts.add(new StringMapEntry(key, val));
        }
        return ts;
    }

    public static void main(String[] args) {
        OrderedProperties.test(new OrderedProperties());
        _log.debug("After ordered");
        OrderedProperties.test2();
        OrderedProperties.testThrash();
    }

    private static void test2() {
        OrderedProperties p = new OrderedProperties();
        p.setProperty("a", "b");
        p.setProperty("c", "d");
        OrderedProperties p2 = new OrderedProperties();
        try {
            p2.putAll((Map)p);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        _log.debug("After test2");
    }

    private static void test(Properties p) {
        String val;
        for (int i = 0; i < 10; ++i) {
            p.setProperty(i + "asdfasdfasdf", "qwerasdfqwer");
        }
        for (String string : p.keySet()) {
            val = p.getProperty(string);
            _log.debug("[" + string + "] = [" + val + "]");
        }
        p.remove("4asdfasdfasdf");
        _log.debug("After remove");
        for (String string : p.keySet()) {
            val = p.getProperty(string);
            _log.debug("[" + string + "] = [" + val + "]");
        }
        try {
            p.put("nullVal", (Object)null);
            _log.debug("Null put did NOT fail!");
        }
        catch (NullPointerException npe) {
            _log.debug("Null put failed correctly");
        }
    }

    private static void testThrash() {
        int i;
        OrderedProperties prop = new OrderedProperties();
        for (i = 0; i < 100; ++i) {
            prop.setProperty(i + "", i + " value");
        }
        _log.debug("Thrash properties built");
        for (i = 0; i < 100; ++i) {
            OrderedProperties.thrash(prop, i);
        }
    }

    private static void thrash(Properties props, int i) {
        I2PThread t = new I2PThread(new Thrash(props));
        t.setName("Thrash" + i);
        t.start();
    }

    private static class Thrash
    implements Runnable {
        private Properties _props;

        public Thrash(Properties props) {
            this._props = props;
        }

        public void run() {
            int numRuns = 1000;
            _log.debug("Begin thrashing " + numRuns + " times");
            for (int i = 0; i < numRuns; ++i) {
                Set<Object> keys = this._props.keySet();
                int cur = 0;
                for (Object o : keys) {
                    Object val = this._props.get(o);
                    ++cur;
                }
                int size = this._props.size();
                _log.debug("Size calculated");
            }
            _log.debug("Done thrashing " + numRuns + " times");
        }
    }

    private static class StringMapEntry
    implements Map.Entry,
    Comparable {
        private Object _key;
        private Object _value;

        public StringMapEntry(String key, String val) {
            this._key = key;
            this._value = val;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            Object old = this._value;
            this._value = value;
            return old;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof StringMapEntry) {
                return ((String)this.getKey()).compareTo((String)((StringMapEntry)o).getKey());
            }
            if (o instanceof String) {
                return ((String)this.getKey()).compareTo((String)o);
            }
            return -2;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof StringMapEntry)) {
                return false;
            }
            StringMapEntry e = (StringMapEntry)o;
            return DataHelper.eq(e.getKey(), this.getKey()) && DataHelper.eq(e.getValue(), this.getValue());
        }
    }
}

