/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.data.DataHelper;

public class ResettableGZIPOutputStream
extends DeflaterOutputStream {
    private boolean _headerWritten = false;
    private long _writtenSize;
    private CRC32 _crc32 = new CRC32();
    private static final boolean DEBUG = false;
    private static final byte[] HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 2, -1};

    public ResettableGZIPOutputStream(OutputStream o) {
        super(o, new Deflater(9, true));
    }

    public void reset() {
        this.def.reset();
        this._crc32.reset();
        this._writtenSize = 0L;
        this._headerWritten = false;
    }

    private void ensureHeaderIsWritten() throws IOException {
        if (this._headerWritten) {
            return;
        }
        this.out.write(HEADER);
        this._headerWritten = true;
    }

    private void writeFooter() throws IOException {
        long crcVal = this._crc32.getValue();
        this.out.write((int)(crcVal & 0xFFL));
        this.out.write((int)(crcVal >>> 8 & 0xFFL));
        this.out.write((int)(crcVal >>> 16 & 0xFFL));
        this.out.write((int)(crcVal >>> 24 & 0xFFL));
        long sizeVal = this._writtenSize;
        this.out.write((int)(sizeVal & 0xFFL));
        this.out.write((int)(sizeVal >>> 8 & 0xFFL));
        this.out.write((int)(sizeVal >>> 16 & 0xFFL));
        this.out.write((int)(sizeVal >>> 24 & 0xFFL));
        this.out.flush();
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    public void finish() throws IOException {
        this.ensureHeaderIsWritten();
        super.finish();
        this.writeFooter();
    }

    public void write(int b) throws IOException {
        this.ensureHeaderIsWritten();
        this._crc32.update(b);
        ++this._writtenSize;
        super.write(b);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.ensureHeaderIsWritten();
        this._crc32.update(buf, off, len);
        this._writtenSize += (long)len;
        super.write(buf, off, len);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 2; ++i) {
            ResettableGZIPOutputStream.test();
        }
    }

    private static void test() {
        byte[] b = "hi, how are you today?".getBytes();
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
            ResettableGZIPOutputStream o = new ResettableGZIPOutputStream(baos);
            o.write(b);
            o.finish();
            o.flush();
            byte[] compressed = baos.toByteArray();
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            SnoopGZIPOutputStream gzo = new SnoopGZIPOutputStream(baos2);
            gzo.write(b);
            gzo.finish();
            gzo.flush();
            long value = gzo.getCRC().getValue();
            byte[] compressed2 = baos2.toByteArray();
            System.out.println("CRC32 values: Resettable = " + o._crc32.getValue() + " GZIP = " + value);
            System.out.print("Resettable compressed data: ");
            for (i = 0; i < compressed.length; ++i) {
                System.out.print(Integer.toHexString(compressed[i] & 0xFF) + " ");
            }
            System.out.println();
            System.out.print("      GZIP compressed data: ");
            for (i = 0; i < compressed2.length; ++i) {
                System.out.print(Integer.toHexString(compressed2[i] & 0xFF) + " ");
            }
            System.out.println();
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(compressed));
            byte[] rv = new byte[128];
            int read = in.read(rv);
            if (!DataHelper.eq(rv, 0, b, 0, b.length)) {
                throw new RuntimeException("foo, read=" + read);
            }
            System.out.println("match, w00t");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class SnoopGZIPOutputStream
    extends GZIPOutputStream {
        public SnoopGZIPOutputStream(OutputStream o) throws IOException {
            super(o);
        }

        public CRC32 getCRC() {
            return this.crc;
        }
    }
}

