/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.router.LoadTestManager;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.FormHandler;

public class ConfigNetHandler
extends FormHandler {
    private String _hostname;
    private boolean _reseedRequested;
    private boolean _saveRequested;
    private boolean _recheckReachabilityRequested;
    private boolean _timeSyncEnabled;
    private boolean _requireIntroductions;
    private boolean _hiddenMode;
    private boolean _dynamicKeys;
    private String _ntcpHostname;
    private String _ntcpPort;
    private String _tcpPort;
    private String _udpPort;
    private boolean _ntcpAutoIP;
    private boolean _ntcpAutoPort;
    private String _inboundRate;
    private String _inboundBurstRate;
    private String _inboundBurst;
    private String _outboundRate;
    private String _outboundBurstRate;
    private String _outboundBurst;
    private String _reseedFrom;
    private boolean _enableLoadTesting;
    private String _sharePct;
    private boolean _ratesOnly;

    protected void processForm() {
        if (this._saveRequested || this._action != null && "Save changes".equals(this._action)) {
            this.saveChanges();
        } else if (this._recheckReachabilityRequested) {
            this.recheckReachability();
        }
    }

    public void setSave(String moo) {
        this._saveRequested = true;
    }

    public void setEnabletimesync(String moo) {
        this._timeSyncEnabled = true;
    }

    public void setRecheckReachability(String moo) {
        this._recheckReachabilityRequested = true;
    }

    public void setRequireIntroductions(String moo) {
        this._requireIntroductions = true;
    }

    public void setHiddenMode(String moo) {
        this._hiddenMode = true;
    }

    public void setDynamicKeys(String moo) {
        this._dynamicKeys = true;
    }

    public void setUpdateratesonly(String moo) {
        this._ratesOnly = true;
    }

    public void setEnableloadtesting(String moo) {
        this._enableLoadTesting = true;
    }

    public void setNtcpAutoIP(String moo) {
        this._ntcpAutoIP = true;
    }

    public void setNtcpAutoPort(String moo) {
        this._ntcpAutoPort = true;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname != null ? hostname.trim() : null;
    }

    public void setTcpPort(String port) {
        this._tcpPort = port != null ? port.trim() : null;
    }

    public void setNtcphost(String host) {
        this._ntcpHostname = host != null ? host.trim() : null;
    }

    public void setNtcpport(String port) {
        this._ntcpPort = port != null ? port.trim() : null;
    }

    public void setUdpPort(String port) {
        this._udpPort = port != null ? port.trim() : null;
    }

    public void setInboundrate(String rate) {
        this._inboundRate = rate != null ? rate.trim() : null;
    }

    public void setInboundburstrate(String rate) {
        this._inboundBurstRate = rate != null ? rate.trim() : null;
    }

    public void setInboundburstfactor(String factor) {
        this._inboundBurst = factor != null ? factor.trim() : null;
    }

    public void setOutboundrate(String rate) {
        this._outboundRate = rate != null ? rate.trim() : null;
    }

    public void setOutboundburstrate(String rate) {
        this._outboundBurstRate = rate != null ? rate.trim() : null;
    }

    public void setOutboundburstfactor(String factor) {
        this._outboundBurst = factor != null ? factor.trim() : null;
    }

    public void setSharePercentage(String pct) {
        this._sharePct = pct != null ? pct.trim() : null;
    }

    private void recheckReachability() {
        this._context.commSystem().recheckReachability();
        this.addFormNotice("Rechecking router reachability...");
    }

    private void saveChanges() {
        boolean restartRequired = false;
        if (!this._ratesOnly) {
            String oldPort;
            String oldNPort;
            String oldNHost;
            String oldPort2;
            String oldHost;
            if (!(this._hostname == null || this._hostname.length() <= 0 || (oldHost = this._context.router().getConfigSetting("i2np.tcp.hostname")) != null && oldHost.equalsIgnoreCase(this._hostname))) {
                this._context.router().setConfigSetting("i2np.tcp.hostname", this._hostname);
                this.addFormNotice("Updating hostname from " + oldHost + " to " + this._hostname);
                restartRequired = true;
            }
            if (!(this._tcpPort == null || this._tcpPort.length() <= 0 || (oldPort2 = this._context.router().getConfigSetting("i2np.tcp.port")) == null && this._tcpPort.equals("8887") || oldPort2 != null && oldPort2.equalsIgnoreCase(this._tcpPort))) {
                this._context.router().setConfigSetting("i2np.tcp.port", this._tcpPort);
                this.addFormNotice("Updating TCP port from " + oldPort2 + " to " + this._tcpPort);
                restartRequired = true;
            }
            if ((oldNHost = this._context.router().getConfigSetting("i2np.ntcp.hostname")) == null) {
                oldNHost = "";
            }
            if ((oldNPort = this._context.router().getConfigSetting("i2np.ntcp.port")) == null) {
                oldNPort = "";
            }
            String sAutoHost = this._context.router().getConfigSetting("i2np.ntcp.autoport");
            String sAutoPort = this._context.router().getConfigSetting("i2np.ntcp.autoip");
            boolean oldAutoHost = "true".equalsIgnoreCase(sAutoHost);
            boolean oldAutoPort = "true".equalsIgnoreCase(sAutoPort);
            if (this._ntcpHostname == null) {
                this._ntcpHostname = "";
            }
            if (this._ntcpPort == null) {
                this._ntcpPort = "";
            }
            if (oldAutoHost != this._ntcpAutoIP || !oldNHost.equalsIgnoreCase(this._ntcpHostname)) {
                if (this._ntcpAutoIP) {
                    this._context.router().setConfigSetting("i2np.ntcp.autoport", "true");
                    this._context.router().removeConfigSetting("i2np.ntcp.hostname");
                    this.addFormNotice("Updating inbound TCP address to auto");
                } else if (this._ntcpHostname.length() > 0) {
                    this._context.router().setConfigSetting("i2np.ntcp.hostname", this._ntcpHostname);
                    this._context.router().removeConfigSetting("i2np.ntcp.autoport");
                    this.addFormNotice("Updating inbound TCP address to " + this._ntcpHostname);
                } else {
                    this._context.router().removeConfigSetting("i2np.ntcp.hostname");
                    this._context.router().removeConfigSetting("i2np.ntcp.autoport");
                    this.addFormNotice("Disabling inbound TCP");
                }
                restartRequired = true;
            }
            if (oldAutoPort != this._ntcpAutoPort || !oldNPort.equals(this._ntcpPort)) {
                if (this._ntcpAutoPort) {
                    this._context.router().setConfigSetting("i2np.ntcp.autoip", "true");
                    this._context.router().removeConfigSetting("i2np.ntcp.port");
                    this.addFormNotice("Updating inbound TCP port to auto");
                } else if (this._ntcpPort.length() > 0) {
                    this._context.router().setConfigSetting("i2np.ntcp.port", this._ntcpPort);
                    this._context.router().removeConfigSetting("i2np.ntcp.autoip");
                    this.addFormNotice("Updating inbound TCP port to " + this._ntcpPort);
                } else {
                    this._context.router().removeConfigSetting("i2np.ntcp.port");
                    this._context.router().removeConfigSetting("i2np.ntcp.autoip");
                    this.addFormNotice("Disabling inbound TCP");
                }
                restartRequired = true;
            }
            if (!(this._udpPort == null || this._udpPort.length() <= 0 || (oldPort = this._context.router().getConfigSetting("i2np.udp.port")) == null && this._udpPort.equals("8887") || oldPort != null && oldPort.equalsIgnoreCase(this._udpPort))) {
                this._context.router().setConfigSetting("i2np.tcp.port", this._udpPort);
                this.addFormNotice("Updating UDP port from " + oldPort + " to " + this._udpPort);
                restartRequired = true;
            }
        }
        this.updateRates();
        if (!this._ratesOnly) {
            String old;
            if (!(this._sharePct == null || (old = this._context.router().getConfigSetting("router.sharePercentage")) != null && old.equalsIgnoreCase(this._sharePct))) {
                this._context.router().setConfigSetting("router.sharePercentage", this._sharePct);
                this.addFormNotice("Updating bandwidth share percentage");
            }
            if (this._hiddenMode && "false".equalsIgnoreCase(this._context.getProperty("router.hiddenMode", "false"))) {
                this._context.router().setConfigSetting("router.hiddenMode", "true");
                this._context.router().addCapabilities(this._context.router().getRouterInfo());
                this.addFormNotice("Gracefully restarting into Hidden Router Mode. Make sure you have no 0-1 length <a href=\"configtunnels.jsp\">tunnels!</a>");
                this.hiddenSwitch();
            }
            if (!this._hiddenMode && "true".equalsIgnoreCase(this._context.getProperty("router.hiddenMode", "false"))) {
                this._context.router().removeConfigSetting("router.hiddenMode");
                this._context.router().getRouterInfo().delCapability('H');
                this.addFormNotice("Gracefully restarting to exit Hidden Router Mode");
                this.hiddenSwitch();
            }
            if (this._dynamicKeys) {
                this._context.router().setConfigSetting("router.dynamicKeys", "true");
            } else {
                this._context.router().removeConfigSetting("router.dynamicKeys");
            }
            if (this._requireIntroductions) {
                this._context.router().setConfigSetting("i2np.udp.forceIntroducers", "true");
                this.addFormNotice("Requiring SSU introduers");
            } else {
                this._context.router().removeConfigSetting("i2np.udp.forceIntroducers");
            }
            this._context.router().setConfigSetting("time.disabled", "false");
            LoadTestManager.setEnableLoadTesting(this._context, this._enableLoadTesting);
        }
        boolean saved = this._context.router().saveConfig();
        if (this._action != null && "Save changes".equals(this._action)) {
            if (saved) {
                this.addFormNotice("Configuration saved successfully");
            } else {
                this.addFormNotice("Error saving the configuration (applied but not saved) - please see the error logs");
            }
        }
        if (restartRequired) {
            this.addFormNotice("Performing a soft restart");
            this._context.router().restart();
            this.addFormNotice("Soft restart complete");
        }
    }

    private void hiddenSwitch() {
        this._context.router().addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerAndRekeyTask(5));
        this._context.router().shutdownGracefully(5);
    }

    private void updateRates() {
        boolean updated = false;
        if (this._inboundRate != null && this._inboundRate.length() > 0) {
            this._context.router().setConfigSetting("i2np.bandwidth.inboundKBytesPerSecond", this._inboundRate);
            updated = true;
        }
        if (this._outboundRate != null && this._outboundRate.length() > 0) {
            this._context.router().setConfigSetting("i2np.bandwidth.outboundKBytesPerSecond", this._outboundRate);
            updated = true;
        }
        if (this._inboundBurstRate != null && this._inboundBurstRate.length() > 0) {
            this._context.router().setConfigSetting("i2np.bandwidth.inboundBurstKBytesPerSecond", this._inboundBurstRate);
            updated = true;
        }
        if (this._outboundBurstRate != null && this._outboundBurstRate.length() > 0) {
            this._context.router().setConfigSetting("i2np.bandwidth.outboundBurstKBytesPerSecond", this._outboundBurstRate);
            updated = true;
        }
        String inBurstRate = this._context.router().getConfigSetting("i2np.bandwidth.inboundBurstKBytesPerSecond");
        if (this._inboundBurst != null) {
            int rateKBps = 0;
            int burstSeconds = 0;
            try {
                rateKBps = Integer.parseInt(inBurstRate);
                burstSeconds = Integer.parseInt(this._inboundBurst);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (rateKBps > 0 && burstSeconds > 0) {
                int kb = rateKBps * burstSeconds;
                this._context.router().setConfigSetting("i2np.bandwidth.inboundBurstKBytes", "" + kb);
                updated = true;
            }
        }
        String outBurstRate = this._context.router().getConfigSetting("i2np.bandwidth.outboundBurstKBytesPerSecond");
        if (this._outboundBurst != null) {
            int rateKBps = 0;
            int burstSeconds = 0;
            try {
                rateKBps = Integer.parseInt(outBurstRate);
                burstSeconds = Integer.parseInt(this._outboundBurst);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (rateKBps > 0 && burstSeconds > 0) {
                int kb = rateKBps * burstSeconds;
                this._context.router().setConfigSetting("i2np.bandwidth.outboundBurstKBytes", "" + kb);
                updated = true;
            }
        }
        if (updated && !this._ratesOnly) {
            this.addFormNotice("Updated bandwidth limits");
        }
    }
}

