/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.web.FormHandler;

public class ConfigPeerHandler
extends FormHandler {
    private String _peer;
    private String _speed;
    private String _capacity;

    protected void processForm() {
        if ("Save Configuration".equals(this._action)) {
            this._context.router().saveConfig();
            this.addFormNotice("Settings saved - not really!!!!!");
        } else if (this._action.startsWith("Shitlist")) {
            Hash h = this.getHash();
            if (h != null) {
                this._context.shitlist().shitlistRouterForever(h, "Manually shitlisted via <a href=\"configpeer.jsp\">configpeer.jsp</a>");
                this.addFormNotice("Peer " + this._peer + " shitlisted forever");
                return;
            }
            this.addFormError("Invalid peer");
        } else if (this._action.startsWith("Unshitlist")) {
            Hash h = this.getHash();
            if (h != null) {
                if (this._context.shitlist().isShitlisted(h)) {
                    this._context.shitlist().unshitlistRouter(h);
                    this.addFormNotice("Peer " + this._peer + " unshitlisted");
                } else {
                    this.addFormNotice("Peer " + this._peer + " is not currently shitlisted");
                }
                return;
            }
            this.addFormError("Invalid peer");
        } else if (this._action.startsWith("Adjust")) {
            Hash h = this.getHash();
            if (h != null) {
                PeerProfile prof = this._context.profileOrganizer().getProfile(h);
                if (prof != null) {
                    try {
                        prof.setSpeedBonus(Long.parseLong(this._speed));
                    }
                    catch (NumberFormatException nfe) {
                        this.addFormError("Bad speed value");
                    }
                    try {
                        prof.setCapacityBonus(Long.parseLong(this._capacity));
                    }
                    catch (NumberFormatException nfe) {
                        this.addFormError("Bad capacity value");
                    }
                    this.addFormNotice("Bonuses adjusted for " + this._peer);
                } else {
                    this.addFormError("No profile exists for " + this._peer);
                }
                return;
            }
            this.addFormError("Invalid peer");
        } else if (this._action.startsWith("Check")) {
            this.addFormError("Unsupported");
        }
    }

    private Hash getHash() {
        byte[] b;
        if (this._peer != null && this._peer.length() == 44 && (b = Base64.decode(this._peer)) != null) {
            return new Hash(b);
        }
        return null;
    }

    public void setPeer(String peer) {
        this._peer = peer;
    }

    public void setSpeed(String bonus) {
        this._speed = bonus;
    }

    public void setCapacity(String bonus) {
        this._capacity = bonus;
    }
}

