/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.TreeMap;
import net.i2p.apps.systray.SysTray;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.data.DataHelper;
import net.i2p.router.Router;
import net.i2p.router.web.FormHandler;
import org.tanukisoftware.wrapper.WrapperManager;

public class ConfigServiceHandler
extends FormHandler {
    private static final String NL = System.getProperty("line.separator");

    protected void processForm() {
        block36: {
            if (this._action == null) {
                return;
            }
            if ("Shutdown gracefully".equals(this._action)) {
                this._context.router().addShutdownTask(new UpdateWrapperManagerTask(2));
                this._context.router().shutdownGracefully();
                this.addFormNotice("Graceful shutdown initiated");
            } else if ("Shutdown immediately".equals(this._action)) {
                this._context.router().addShutdownTask(new UpdateWrapperManagerTask(3));
                this._context.router().shutdown(3);
                this.addFormNotice("Shutdown immediately!  boom bye bye bad bwoy");
            } else if ("Cancel graceful shutdown".equals(this._action)) {
                this._context.router().cancelGracefulShutdown();
                this.addFormNotice("Graceful shutdown cancelled");
            } else if ("Graceful restart".equals(this._action)) {
                this._context.router().addShutdownTask(new UpdateWrapperManagerTask(5));
                this._context.router().shutdownGracefully(5);
                this.addFormNotice("Graceful restart requested");
            } else if ("Hard restart".equals(this._action)) {
                this._context.router().addShutdownTask(new UpdateWrapperManagerTask(4));
                this._context.router().shutdown(4);
                this.addFormNotice("Hard restart requested");
            } else if ("Rekey and Restart".equals(this._action)) {
                this.addFormNotice("Rekeying after graceful restart");
                this._context.router().addShutdownTask(new UpdateWrapperManagerAndRekeyTask(5));
                this._context.router().shutdownGracefully(5);
            } else if ("Rekey and Shutdown".equals(this._action)) {
                this.addFormNotice("Rekeying after graceful shutdown");
                this._context.router().addShutdownTask(new UpdateWrapperManagerAndRekeyTask(2));
                this._context.router().shutdownGracefully(2);
            } else if ("Run I2P on startup".equals(this._action)) {
                this.installService();
            } else if ("Don't run I2P on startup".equals(this._action)) {
                this.uninstallService();
            } else if ("Dump threads".equals(this._action)) {
                try {
                    WrapperManager.requestThreadDump();
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the service manager - " + t.getMessage());
                }
                this.addFormNotice("Threads dumped to wrapper.log");
            } else if ("Show systray icon".equals(this._action)) {
                try {
                    SysTray tray = SysTray.getInstance();
                    if (tray != null) {
                        tray.show();
                        this.addFormNotice("Systray enabled");
                        break block36;
                    }
                    this.addFormNotice("Systray not supported on this platform");
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the systray manager - " + t.getMessage());
                }
            } else if ("Hide systray icon".equals(this._action)) {
                try {
                    SysTray tray = SysTray.getInstance();
                    if (tray != null) {
                        tray.hide();
                        this.addFormNotice("Systray disabled");
                        break block36;
                    }
                    this.addFormNotice("Systray not supported on this platform");
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the systray manager - " + t.getMessage());
                }
            } else if ("View console on startup".equals(this._action)) {
                this.browseOnStartup(true);
                this.addFormNotice("Console is to be shown on startup");
            } else if ("Do not view console on startup".equals(this._action)) {
                this.browseOnStartup(false);
                this.addFormNotice("Console is not to be shown on startup");
            }
        }
    }

    private void installService() {
        try {
            Runtime.getRuntime().exec("install_i2p_service_winnt.bat");
            this.addFormNotice("Service installed");
        }
        catch (IOException ioe) {
            this.addFormError("Warning: unable to install the service - " + ioe.getMessage());
        }
    }

    private void uninstallService() {
        try {
            Runtime.getRuntime().exec("uninstall_i2p_service_winnt.bat");
            this.addFormNotice("Service removed");
        }
        catch (IOException ioe) {
            this.addFormError("Warning: unable to remove the service - " + ioe.getMessage());
        }
    }

    private void browseOnStartup(boolean shouldLaunchBrowser) {
        File f = new File("clients.config");
        Properties p = new Properties();
        try {
            String className;
            DataHelper.loadProps(p, f);
            int i = 0;
            int launchIndex = -1;
            while ((className = p.getProperty("clientApp." + i + ".main")) != null) {
                if (UrlLauncher.class.getName().equals(className)) {
                    launchIndex = i;
                    break;
                }
                ++i;
            }
            if (launchIndex >= 0 && shouldLaunchBrowser) {
                return;
            }
            if (launchIndex < 0 && !shouldLaunchBrowser) {
                return;
            }
            if (shouldLaunchBrowser) {
                p.setProperty("clientApp." + i + ".main", UrlLauncher.class.getName());
                p.setProperty("clientApp." + i + ".name", "BrowserLauncher");
                p.setProperty("clientApp." + i + ".args", "http://localhost:7657/index.jsp");
                p.setProperty("clientApp." + i + ".delay", "5");
            } else {
                p.remove("clientApp." + launchIndex + ".main");
                p.remove("clientApp." + launchIndex + ".name");
                p.remove("clientApp." + launchIndex + ".args");
                p.remove("clientApp." + launchIndex + ".onBoot");
                p.remove("clientApp." + launchIndex + ".delay");
                i = launchIndex + 1;
                while (true) {
                    String main = p.getProperty("clientApp." + i + ".main");
                    String name = p.getProperty("clientApp." + i + ".name");
                    String args = p.getProperty("clientApp." + i + ".args");
                    String string = p.getProperty("clientApp." + i + ".onBoot");
                    String delay = p.getProperty("clientApp." + i + ".delay");
                    if (main == null) break;
                    p.setProperty("clientApp." + (i - 1) + ".main", main);
                    p.setProperty("clientApp." + (i - 1) + ".name", name);
                    p.setProperty("clientApp." + (i - 1) + ".args", args);
                    if (string != null) {
                        p.setProperty("clientApp." + (i - 1) + ".onBoot", string);
                    }
                    if (delay != null) {
                        p.setProperty("clientApp." + (i - 1) + ".delay", delay);
                    }
                    p.remove("clientApp." + i + ".main");
                    p.remove("clientApp." + i + ".name");
                    p.remove("clientApp." + i + ".args");
                    p.remove("clientApp." + i + ".onBoot");
                    p.remove("clientApp." + i + ".delay");
                    ++i;
                }
            }
            TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(p);
            FileWriter out = new FileWriter(f);
            for (String string : sorted.keySet()) {
                String val = (String)sorted.get(string);
                out.write(string + "=" + val + NL);
            }
            out.close();
        }
        catch (IOException ioe) {
            this.addFormError("Error updating the client config");
        }
    }

    public static class UpdateWrapperManagerAndRekeyTask
    implements Runnable {
        private int _exitCode;

        public UpdateWrapperManagerAndRekeyTask(int exitCode) {
            this._exitCode = exitCode;
        }

        public void run() {
            try {
                Router.killKeys();
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class UpdateWrapperManagerTask
    implements Runnable {
        private int _exitCode;

        public UpdateWrapperManagerTask(int exitCode) {
            this._exitCode = exitCode;
        }

        public void run() {
            try {
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

