/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Properties;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.web.ContextHelper;

public class ConfigTunnelsHelper {
    private RouterContext _context;
    private static final int WARN_LENGTH = 4;
    private static final int MAX_LENGTH = 4;
    private static final int MAX_QUANTITY = 3;
    private static final int MAX_VARIANCE = 2;
    private static final int MIN_NEG_VARIANCE = -1;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getForm() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<table border=\"1\">\n");
        TunnelPoolSettings exploratoryIn = this._context.tunnelManager().getInboundSettings();
        TunnelPoolSettings exploratoryOut = this._context.tunnelManager().getOutboundSettings();
        buf.append("<input type=\"hidden\" name=\"pool.0\" value=\"exploratory\" >");
        this.renderForm(buf, 0, "exploratory", "Exploratory tunnels", exploratoryIn, exploratoryOut);
        int cur = 1;
        Set clients = this._context.clientManager().listClients();
        for (Destination dest : clients) {
            TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(dest.calculateHash());
            TunnelPoolSettings out = this._context.tunnelManager().getOutboundSettings(dest.calculateHash());
            if (in == null || out == null) continue;
            String name = in.getDestinationNickname();
            if (name == null) {
                name = out.getDestinationNickname();
            }
            if (name == null) {
                name = dest.calculateHash().toBase64().substring(0, 6);
            }
            String prefix = dest.calculateHash().toBase64().substring(0, 4);
            buf.append("<input type=\"hidden\" name=\"pool.").append(cur).append("\" value=\"");
            buf.append(dest.calculateHash().toBase64()).append("\" >");
            this.renderForm(buf, cur, prefix, "Client tunnels for " + name, in, out);
            ++cur;
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    private void renderForm(StringBuffer buf, int index, String prefix, String name, TunnelPoolSettings in, TunnelPoolSettings out) {
        String val;
        buf.append("<tr><td colspan=\"3\"><b><a name=\"").append(prefix).append("\">");
        buf.append(name).append("</a></b></td></tr>\n");
        if (in.getLength() <= 0 || in.getLength() + in.getLengthVariance() <= 0 || out.getLength() <= 0 || out.getLength() + out.getLengthVariance() <= 0) {
            buf.append("<tr><td colspan=\"3\"><font color=\"red\">ANONYMITY WARNING - Settings include 0-hop tunnels</font></td></tr>");
        }
        if (in.getLength() + Math.abs(in.getLengthVariance()) >= 4 || out.getLength() + Math.abs(out.getLengthVariance()) >= 4) {
            buf.append("<tr><td colspan=\"3\"><font color=\"red\">PERFORMANCE WARNING - Settings include very long tunnels</font></td></tr>");
        }
        buf.append("<tr><td></td><td><b>Inbound</b></td><td><b>Outbound</b></td></tr>\n");
        buf.append("<tr><td>Depth</td>\n");
        buf.append("<td><select name=\"").append(index).append(".depthInbound\">\n");
        int now = in.getLength();
        this.renderOptions(buf, 0, 4, now, "", "hop");
        if (now > 4) {
            this.renderOptions(buf, now, now, now, "", "hop");
        }
        buf.append("</select></td>\n");
        buf.append("<td><select name=\"").append(index).append(".depthOutbound\">\n");
        now = out.getLength();
        this.renderOptions(buf, 0, 4, now, "", "hop");
        if (now > 4) {
            this.renderOptions(buf, now, now, now, "", "hop");
        }
        buf.append("</select></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr><td>Randomization</td>\n");
        buf.append("<td><select name=\"").append(index).append(".varianceInbound\">\n");
        now = in.getLengthVariance();
        this.renderOptions(buf, 0, 0, now, "", "hop");
        this.renderOptions(buf, 1, 2, now, "+ 0-", "hop");
        this.renderOptions(buf, -1, -1, now, "+/- 0", "hop");
        if (now > 2) {
            this.renderOptions(buf, now, now, now, "+ 0-", "hop");
        } else if (now < -1) {
            this.renderOptions(buf, now, now, now, "+/- 0", "hop");
        }
        buf.append("</select></td>\n");
        buf.append("<td><select name=\"").append(index).append(".varianceOutbound\">\n");
        now = out.getLengthVariance();
        this.renderOptions(buf, 0, 0, now, "", "hop");
        this.renderOptions(buf, 1, 2, now, "+ 0-", "hop");
        this.renderOptions(buf, -1, -1, now, "+/- 0", "hop");
        if (now > 2) {
            this.renderOptions(buf, now, now, now, "+ 0-", "hop");
        } else if (now < -1) {
            this.renderOptions(buf, now, now, now, "+/- 0", "hop");
        }
        buf.append("</select></td>\n");
        buf.append("<tr><td>Quantity</td>\n");
        buf.append("<td><select name=\"").append(index).append(".quantityInbound\">\n");
        now = in.getQuantity();
        this.renderOptions(buf, 1, 3, now, "", "tunnel");
        if (now > 3) {
            this.renderOptions(buf, now, now, now, "", "tunnel");
        }
        buf.append("</select></td>\n");
        buf.append("<td><select name=\"").append(index).append(".quantityOutbound\">\n");
        now = out.getQuantity();
        this.renderOptions(buf, 1, 3, now, "", "tunnel");
        if (now > 3) {
            this.renderOptions(buf, now, now, now, "", "tunnel");
        }
        buf.append("</select></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr><td>Backup quantity</td>\n");
        buf.append("<td><select name=\"").append(index).append(".backupInbound\">\n");
        now = in.getBackupQuantity();
        this.renderOptions(buf, 0, 3, now, "", "tunnel");
        if (now > 3) {
            this.renderOptions(buf, now, now, now, "", "tunnel");
        }
        buf.append("</select></td>\n");
        buf.append("<td><select name=\"").append(index).append(".backupOutbound\">\n");
        now = in.getBackupQuantity();
        this.renderOptions(buf, 0, 3, now, "", "tunnel");
        if (now > 3) {
            this.renderOptions(buf, now, now, now, "", "tunnel");
        }
        buf.append("</select></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr><td>Inbound options:</td>\n");
        buf.append("<td colspan=\"2\"><input name=\"").append(index);
        buf.append(".inboundOptions\" type=\"text\" size=\"40\" ");
        buf.append("value=\"");
        Properties props = in.getUnknownOptions();
        for (String string : props.keySet()) {
            val = props.getProperty(string);
            buf.append(string).append("=").append(val).append(" ");
        }
        buf.append("\"/></td></tr>\n");
        buf.append("<tr><td>Outbound options:</td>\n");
        buf.append("<td colspan=\"2\"><input name=\"").append(index);
        buf.append(".outboundOptions\" type=\"text\" size=\"40\" ");
        buf.append("value=\"");
        props = in.getUnknownOptions();
        for (String string : props.keySet()) {
            val = props.getProperty(string);
            buf.append(string).append("=").append(val).append(" ");
        }
        buf.append("\"/></td></tr>\n");
        buf.append("<tr><td colspan=\"3\"><hr /></td></tr>\n");
    }

    private void renderOptions(StringBuffer buf, int min, int max, int now, String prefix, String name) {
        for (int i = min; i <= max; ++i) {
            buf.append("<option value=\"").append(i).append("\" ");
            if (i == now) {
                buf.append("selected=\"true\" ");
            }
            buf.append(">").append(prefix).append(i).append(' ').append(name);
            if (i != 1 && i != -1) {
                buf.append('s');
            }
            buf.append("</option>\n");
        }
    }
}

