/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.NewsFetcher;

public class ConfigUpdateHandler
extends FormHandler {
    private String _newsURL;
    private long _refreshFrequency;
    private String _updateURL;
    private String _updatePolicy;
    private String _proxyHost;
    private String _proxyPort;
    private boolean _updateThroughProxy;
    private String _trustedKeys;
    public static final String PROP_NEWS_URL = "router.newsURL";
    public static final String DEFAULT_NEWS_URL = "http://complication.i2p/news.xml";
    public static final String PROP_REFRESH_FREQUENCY = "router.newsRefreshFrequency";
    public static final String DEFAULT_REFRESH_FREQUENCY = "43200000";
    public static final String PROP_UPDATE_POLICY = "router.updatePolicy";
    public static final String DEFAULT_UPDATE_POLICY = "notify";
    public static final String PROP_SHOULD_PROXY = "router.updateThroughProxy";
    public static final String DEFAULT_SHOULD_PROXY = Boolean.TRUE.toString();
    public static final String PROP_PROXY_HOST = "router.updateProxyHost";
    public static final String DEFAULT_PROXY_HOST = "localhost";
    public static final String PROP_PROXY_PORT = "router.updateProxyPort";
    public static final String DEFAULT_PROXY_PORT = "4444";
    public static final String PROP_UPDATE_URL = "router.updateURL";
    public static final String DEFAULT_UPDATE_URL = "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://complication.i2p/i2p/i2pupdate.sud\r\nhttp://www.i2p2.i2p/_static/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud";
    public static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";

    protected void processForm() {
        String oldKeys;
        String oldURL;
        String oldPolicy;
        String oldPort;
        String oldHost;
        String oldURL2;
        if ("Check for update now".equals(this._action)) {
            NewsFetcher fetcher = NewsFetcher.getInstance(I2PAppContext.getGlobalContext());
            fetcher.fetchNews();
            if (fetcher.updateAvailable()) {
                if (this._updatePolicy == null || !this._updatePolicy.equals(DEFAULT_UPDATE_POLICY)) {
                    this.addFormNotice("Update available, attempting to download now");
                } else {
                    this.addFormNotice("Update available, click link on left to download");
                }
            } else {
                this.addFormNotice("No update available");
            }
        }
        if (!(this._newsURL == null || this._newsURL.length() <= 0 || (oldURL2 = this._context.router().getConfigSetting(PROP_NEWS_URL)) != null && this._newsURL.equals(oldURL2))) {
            this._context.router().setConfigSetting(PROP_NEWS_URL, this._newsURL);
            this.addFormNotice("Updating news URL to " + this._newsURL);
        }
        if (!(this._proxyHost == null || this._proxyHost.length() <= 0 || (oldHost = this._context.router().getConfigSetting(PROP_PROXY_HOST)) != null && this._proxyHost.equals(oldHost))) {
            this._context.router().setConfigSetting(PROP_PROXY_HOST, this._proxyHost);
            this.addFormNotice("Updating proxy host to " + this._proxyHost);
        }
        if (!(this._proxyPort == null || this._proxyPort.length() <= 0 || (oldPort = this._context.router().getConfigSetting(PROP_PROXY_PORT)) != null && this._proxyPort.equals(oldPort))) {
            this._context.router().setConfigSetting(PROP_PROXY_PORT, this._proxyPort);
            this.addFormNotice("Updating proxy port to " + this._proxyPort);
        }
        if (this._updateThroughProxy) {
            this._context.router().setConfigSetting(PROP_SHOULD_PROXY, Boolean.TRUE.toString());
        } else {
            this._context.router().setConfigSetting(PROP_SHOULD_PROXY, Boolean.FALSE.toString());
        }
        String oldFreqStr = this._context.router().getConfigSetting(PROP_REFRESH_FREQUENCY);
        long oldFreq = -1L;
        if (oldFreqStr != null) {
            try {
                oldFreq = Long.parseLong(oldFreqStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this._refreshFrequency != oldFreq) {
            this._context.router().setConfigSetting(PROP_REFRESH_FREQUENCY, "" + this._refreshFrequency);
            this.addFormNotice("Updating refresh frequency to " + DataHelper.formatDuration(this._refreshFrequency));
        }
        if (!(this._updatePolicy == null || this._updatePolicy.length() <= 0 || (oldPolicy = this._context.router().getConfigSetting(PROP_UPDATE_POLICY)) != null && this._updatePolicy.equals(oldPolicy))) {
            this._context.router().setConfigSetting(PROP_UPDATE_POLICY, this._updatePolicy);
            this.addFormNotice("Updating update policy to " + this._updatePolicy);
        }
        if (!(this._updateURL == null || this._updateURL.length() <= 0 || (oldURL = this._context.router().getConfigSetting(PROP_UPDATE_URL)) != null && this._updateURL.equals(oldURL))) {
            this._context.router().setConfigSetting(PROP_UPDATE_URL, this._updateURL);
            this.addFormNotice("Updating update URLs.");
        }
        if (!(this._trustedKeys == null || this._trustedKeys.length() <= 0 || (oldKeys = new TrustedUpdate(this._context).getTrustedKeysString()) != null && this._trustedKeys.equals(oldKeys))) {
            this._context.router().setConfigSetting(PROP_TRUSTED_KEYS, this._trustedKeys);
            this.addFormNotice("Updating trusted keys.");
        }
        this._context.router().saveConfig();
    }

    public void setNewsURL(String url) {
        this._newsURL = url;
    }

    public void setRefreshFrequency(String freq) {
        try {
            this._refreshFrequency = Long.parseLong(freq);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setUpdateURL(String url) {
        this._updateURL = url;
    }

    public void setUpdatePolicy(String policy) {
        this._updatePolicy = policy;
    }

    public void setTrustedKeys(String keys) {
        this._trustedKeys = keys;
    }

    public void setUpdateThroughProxy(String foo) {
        this._updateThroughProxy = true;
    }

    public void setProxyHost(String host) {
        this._proxyHost = host;
    }

    public void setProxyPort(String port) {
        this._proxyPort = port;
    }
}

