/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ContextHelper;

public class NetDbHelper {
    private RouterContext _context;
    private Writer _out;
    private String _routerPrefix;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setWriter(Writer writer) {
        this._out = writer;
    }

    public void setRouter(String r) {
        this._routerPrefix = r;
    }

    public String getNetDbSummary() {
        try {
            if (this._out != null) {
                if (this._routerPrefix != null) {
                    this._context.netDb().renderRouterInfoHTML(this._out, this._routerPrefix);
                } else {
                    this._context.netDb().renderStatusHTML(this._out);
                }
                return "";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            if (this._routerPrefix != null) {
                this._context.netDb().renderRouterInfoHTML(new OutputStreamWriter(baos), this._routerPrefix);
            } else {
                this._context.netDb().renderStatusHTML(new OutputStreamWriter(baos));
            }
            return new String(baos.toByteArray());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }
}

