/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.router.RouterContext;
import net.i2p.router.web.SummaryListener;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

public class StatSummarizer
implements Runnable {
    private RouterContext _context = (RouterContext)RouterContext.listContexts().get(0);
    private Log _log = this._context.logManager().getLog(this.getClass());
    private List _listeners = new ArrayList(16);
    private static StatSummarizer _instance;
    private static final String DEFAULT_DATABASES = "bw.sendRate.60000,bw.recvRate.60000,router.activePeers.60000";

    public StatSummarizer() {
        _instance = this;
    }

    public static StatSummarizer instance() {
        return _instance;
    }

    public void run() {
        String specs = "";
        while (this._context.router().isAlive()) {
            specs = this.adjustDatabases(specs);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    List getListeners() {
        return this._listeners;
    }

    private String adjustDatabases(String oldSpecs) {
        String spec = this._context.getProperty("stat.summaries", DEFAULT_DATABASES);
        if (spec == null && oldSpecs == null || spec != null && oldSpecs != null && oldSpecs.equals(spec)) {
            return oldSpecs;
        }
        List old = this.parseSpecs(oldSpecs);
        List newSpecs = this.parseSpecs(spec);
        for (int i = 0; i < old.size(); ++i) {
            Rate r = (Rate)old.get(i);
            if (newSpecs.contains(r)) continue;
            this.removeDb(r);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < newSpecs.size(); ++i) {
            Rate r = (Rate)newSpecs.get(i);
            if (!old.contains(r)) {
                this.addDb(r);
            }
            buf.append(r.getRateStat().getName()).append(".").append(r.getPeriod());
            if (i + 1 >= newSpecs.size()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private void removeDb(Rate r) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            SummaryListener lsnr = (SummaryListener)this._listeners.get(i);
            if (!lsnr.getRate().equals(r)) continue;
            this._listeners.remove(i);
            lsnr.stopListening();
            return;
        }
    }

    private void addDb(Rate r) {
        SummaryListener lsnr = new SummaryListener(r);
        this._listeners.add(lsnr);
        lsnr.startListening();
    }

    public boolean renderPng(Rate rate, OutputStream out) throws IOException {
        return this.renderPng(rate, out, -1, -1, false, false, false, false, -1, true);
    }

    public boolean renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, boolean showCredit) throws IOException {
        for (int i = 0; i < this._listeners.size(); ++i) {
            SummaryListener lsnr = (SummaryListener)this._listeners.get(i);
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, showCredit);
            return true;
        }
        return false;
    }

    public boolean renderPng(OutputStream out, String templateFilename) throws IOException {
        SummaryRenderer.render(this._context, out, templateFilename);
        return true;
    }

    public boolean getXML(Rate rate, OutputStream out) throws IOException {
        for (int i = 0; i < this._listeners.size(); ++i) {
            SummaryListener lsnr = (SummaryListener)this._listeners.get(i);
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.getData().exportXml(out);
            out.write(("<!-- Rate: " + lsnr.getRate().getRateStat().getName() + " for period " + lsnr.getRate().getPeriod() + " -->\n").getBytes());
            out.write(("<!-- Average data soure name: " + lsnr.getName() + " event count data source name: " + lsnr.getEventName() + " -->\n").getBytes());
            return true;
        }
        return false;
    }

    public boolean renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, boolean showCredit) throws IOException {
        long end = this._context.clock().now() - 60000L;
        if (periodCount <= 0) {
            periodCount = 1440;
        }
        if (periodCount > 1440) {
            periodCount = 1440;
        }
        long period = 60000L;
        long start = end - period * (long)periodCount;
        try {
            RrdGraphDef def = new RrdGraphDef();
            def.setTimePeriod(start / 1000L, 0L);
            def.setBaseValue(1024.0);
            String title = "Bandwidth usage";
            if (!hideTitle) {
                def.setTitle(title);
            }
            String sendName = SummaryListener.createName(this._context, "bw.sendRate.60000");
            String recvName = SummaryListener.createName(this._context, "bw.recvRate.60000");
            def.datasource(sendName, sendName, sendName, "AVERAGE", "MEMORY");
            def.datasource(recvName, recvName, recvName, "AVERAGE", "MEMORY");
            def.area(sendName, Color.BLUE, "Outbound bytes/sec");
            def.line(recvName, Color.RED, "Inbound bytes/sec@r", 3);
            if (!hideLegend) {
                def.gprint(sendName, "AVERAGE", "out average: @2@sbytes/sec");
                def.gprint(sendName, "MAX", " max: @2@sbytes/sec@r");
                def.gprint(recvName, "AVERAGE", "in average:  @2@sbytes/sec");
                def.gprint(recvName, "MAX", " max: @2@sbytes/sec@r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setShowLegend(false);
            }
            if (hideGrid) {
                def.setGridX(false);
                def.setGridY(false);
            }
            def.setAntiAliasing(false);
            RrdGraph graph = new RrdGraph(def);
            byte[] data = null;
            data = width <= 0 || height <= 0 ? graph.getPNGBytes() : graph.getPNGBytes(width, height);
            out.write(data);
            return true;
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            this._log.error("Error rendering", ioe);
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getMessage());
        }
    }

    private List parseSpecs(String specs) {
        StringTokenizer tok = new StringTokenizer(specs, ",");
        ArrayList<Rate> rv = new ArrayList<Rate>();
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            int split = spec.lastIndexOf(46);
            if (split <= 0 || split + 1 >= spec.length()) continue;
            String name = spec.substring(0, split);
            String per = spec.substring(split + 1);
            long period = -1L;
            try {
                Rate r;
                period = Long.parseLong(per);
                RateStat rs = this._context.statManager().getRate(name);
                if (rs == null || (r = rs.getRate(period)) == null) continue;
                rv.add(r);
            }
            catch (NumberFormatException nfe) {}
        }
        return rv;
    }
}

