/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.SummaryListener;
import net.i2p.util.Log;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphDefTemplate;

class SummaryRenderer {
    private Log _log;
    private SummaryListener _listener;

    public SummaryRenderer(I2PAppContext ctx, SummaryListener lsnr) {
        this._log = ctx.logManager().getLog(SummaryRenderer.class);
        this._listener = lsnr;
    }

    public static synchronized void render(I2PAppContext ctx, OutputStream out, String filename) throws IOException {
        long end = ctx.clock().now() - 60000L;
        long start = end - 86400000L;
        try {
            RrdGraphDefTemplate template = new RrdGraphDefTemplate(filename);
            RrdGraphDef def = template.getRrdGraphDef();
            def.setTimePeriod(start / 1000L, end / 1000L);
            RrdGraph graph = new RrdGraph(def);
            byte[] img = graph.getPNGBytes();
            out.write(img);
        }
        catch (RrdException re) {
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public void render(OutputStream out) throws IOException {
        this.render(out, -1, -1, false, false, false, false, -1, true);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, boolean showCredit) throws IOException {
        long end = this._listener.now() - 60000L;
        if (periodCount <= 0) {
            periodCount = 1440;
        }
        if (periodCount > 1440) {
            periodCount = 1440;
        }
        long start = end - this._listener.getRate().getPeriod() * (long)periodCount;
        try {
            RrdGraphDef def = new RrdGraphDef();
            def.setTimePeriod(start / 1000L, 0L);
            String name = this._listener.getRate().getRateStat().getName();
            if ((name.startsWith("bw.") || name.indexOf("Size") >= 0 || name.indexOf("Bps") >= 0) && !showEvents) {
                def.setBaseValue(1024.0);
            }
            String title = name;
            title = showEvents ? title + " events in " : title + " averaged for ";
            title = title + DataHelper.formatDuration(this._listener.getRate().getPeriod());
            if (!hideTitle) {
                def.setTitle(title);
            }
            String path = this._listener.getData().getPath();
            String[] dsNames = this._listener.getData().getDsNames();
            String plotName = null;
            String descr = null;
            if (showEvents) {
                plotName = dsNames[1];
                descr = "Events per period";
            } else {
                plotName = dsNames[0];
                descr = this._listener.getRate().getRateStat().getDescription();
            }
            def.datasource(plotName, path, plotName, "AVERAGE", "MEMORY");
            def.area(plotName, Color.BLUE, descr + "@r");
            if (!hideLegend) {
                def.gprint(plotName, "AVERAGE", "avg: @2@s");
                def.gprint(plotName, "MAX", " max: @2@s");
                def.gprint(plotName, "LAST", " now: @2@s@r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setShowLegend(false);
            }
            if (hideGrid) {
                def.setGridX(false);
                def.setGridY(false);
            }
            def.setAntiAliasing(false);
            RrdGraph graph = new RrdGraph(def);
            byte[] data = null;
            data = width <= 0 || height <= 0 ? graph.getPNGBytes() : graph.getPNGBytes(width, height);
            out.write(data);
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            this._log.error("Error rendering", ioe);
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getMessage());
        }
    }
}

