/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ContextHelper;
import net.i2p.util.EepGet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class UpdateHandler {
    private static UpdateRunner _updateRunner;
    private RouterContext _context;
    private Log _log;
    private DecimalFormat _pct = new DecimalFormat("00.0%");
    private static final String SIGNED_UPDATE_FILE = "i2pupdate.sud";
    private static final String PROP_UPDATE_IN_PROGRESS = "net.i2p.router.web.UpdateHandler.updateInProgress";

    public UpdateHandler() {
        this(ContextHelper.getContext(null));
    }

    public UpdateHandler(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UpdateHandler.class);
    }

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(UpdateHandler.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setUpdateNonce(String nonce) {
        if (nonce == null) {
            return;
        }
        if (nonce.equals(System.getProperty("net.i2p.router.web.UpdateHandler.nonce")) || nonce.equals(System.getProperty("net.i2p.router.web.UpdateHandler.noncePrev"))) {
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if ("true".equals(System.getProperty(PROP_UPDATE_IN_PROGRESS, "false"))) {
            this._log.error("Update already running");
            return;
        }
        Class<UpdateHandler> clazz = UpdateHandler.class;
        synchronized (UpdateHandler.class) {
            if (_updateRunner == null) {
                _updateRunner = new UpdateRunner();
            }
            if (_updateRunner.isRunning()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.setProperty(PROP_UPDATE_IN_PROGRESS, "true");
            I2PThread update = new I2PThread(_updateRunner, "Update");
            update.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getStatus() {
        if (_updateRunner == null) {
            return "";
        }
        return _updateRunner.getStatus();
    }

    private void restart() {
        this._context.router().addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(5));
        this._context.router().shutdownGracefully(5);
    }

    private String selectUpdateURL() {
        String URLs = this._context.getProperty("router.updateURL", "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://complication.i2p/i2p/i2pupdate.sud\r\nhttp://www.i2p2.i2p/_static/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud");
        StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
        ArrayList<String> URLList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            URLList.add(tok.nextToken().trim());
        }
        int size = URLList.size();
        this._log.log(10, "Picking update source from " + size + " candidates.");
        if (size <= 0) {
            this._log.log(30, "Update list is empty - no update available");
            return null;
        }
        int index = I2PAppContext.getGlobalContext().random().nextInt(size);
        this._log.log(10, "Picked update source " + index + ".");
        return (String)URLList.get(index);
    }

    public class UpdateRunner
    implements Runnable,
    EepGet.StatusListener {
        private boolean _isRunning = false;
        private String _status = "<b>Updating</b>";
        private long _startedOn;

        public boolean isRunning() {
            return this._isRunning;
        }

        public String getStatus() {
            return this._status;
        }

        public void run() {
            this._isRunning = true;
            this.update();
            System.setProperty(UpdateHandler.PROP_UPDATE_IN_PROGRESS, "false");
            this._isRunning = false;
        }

        private void update() {
            this._startedOn = -1L;
            this._status = "<b>Updating</b>";
            String updateURL = UpdateHandler.this.selectUpdateURL();
            if (UpdateHandler.this._log.shouldLog(10)) {
                UpdateHandler.this._log.debug("Selected update URL: " + updateURL);
            }
            boolean shouldProxy = Boolean.valueOf(UpdateHandler.this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
            String proxyHost = UpdateHandler.this._context.getProperty("router.updateProxyHost", "localhost");
            String port = UpdateHandler.this._context.getProperty("router.updateProxyPort", "4444");
            int proxyPort = -1;
            try {
                proxyPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                return;
            }
            try {
                EepGet get = null;
                get = shouldProxy ? new EepGet((I2PAppContext)UpdateHandler.this._context, proxyHost, proxyPort, 20, UpdateHandler.SIGNED_UPDATE_FILE, updateURL, false) : new EepGet(UpdateHandler.this._context, 1, UpdateHandler.SIGNED_UPDATE_FILE, updateURL, false);
                get.addStatusListener(this);
                this._startedOn = UpdateHandler.this._context.clock().now();
                get.fetch();
            }
            catch (Throwable t) {
                UpdateHandler.this._context.logManager().getLog(UpdateHandler.class).error("Error updating", t);
            }
        }

        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            if (UpdateHandler.this._log.shouldLog(10)) {
                UpdateHandler.this._log.debug("Attempt failed on " + url, cause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("<b>Updating</b> ");
            double pct = ((double)alreadyTransferred + (double)currentWrite) / ((double)alreadyTransferred + (double)currentWrite + (double)bytesRemaining);
            DecimalFormat decimalFormat = UpdateHandler.this._pct;
            synchronized (decimalFormat) {
                buf.append(UpdateHandler.this._pct.format(pct));
            }
            buf.append(":<br />\n" + ((long)currentWrite + alreadyTransferred));
            buf.append(" transferred");
            this._status = buf.toString();
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            this._status = "<b>Update downloaded</b>";
            TrustedUpdate up = new TrustedUpdate(UpdateHandler.this._context);
            String err = up.migrateVerified("0.6.5", UpdateHandler.SIGNED_UPDATE_FILE, "i2pupdate.zip");
            File f = new File(UpdateHandler.SIGNED_UPDATE_FILE);
            f.delete();
            if (err == null) {
                String policy = UpdateHandler.this._context.getProperty("router.updatePolicy");
                if ("install".equals(policy)) {
                    UpdateHandler.this._log.log(50, "Update was VERIFIED, restarting to install it");
                    this._status = "<b>Update verified</b><br />Restarting";
                    UpdateHandler.this.restart();
                } else {
                    UpdateHandler.this._log.log(50, "Update was VERIFIED, will be installed at next restart");
                    this._status = "<b>Update downloaded</b><br />Click Restart to Install";
                }
            } else {
                err = err + " from " + url;
                UpdateHandler.this._log.log(50, err);
                this._status = "<b>" + err + "</b>";
            }
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
            UpdateHandler.this._log.log(50, "Update from " + url + " did not download completely (" + bytesRemaining + " remaining after " + currentAttempt + " tries)");
            this._status = "<b>Transfer failed</b>";
        }

        public void headerReceived(String url, int attemptNum, String key, String val) {
        }

        public void attempting(String url) {
        }
    }
}

