/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import net.i2p.sam.SAMBridge;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public abstract class SAMHandler
implements Runnable {
    private static final Log _log = new Log(SAMHandler.class);
    protected I2PThread thread = null;
    protected SAMBridge bridge = null;
    private Object socketWLock = new Object();
    private Socket socket = null;
    private OutputStream socketOS = null;
    protected int verMajor = 0;
    protected int verMinor = 0;
    protected Properties i2cpProps = null;
    private Object stopLock = new Object();
    private boolean stopHandler = false;

    protected SAMHandler(Socket s, int verMajor, int verMinor, Properties i2cpProps) throws IOException {
        this.socket = s;
        this.socketOS = this.socket.getOutputStream();
        this.verMajor = verMajor;
        this.verMinor = verMinor;
        this.i2cpProps = i2cpProps;
    }

    public final void startHandling() {
        this.thread = new I2PThread(this, "SAMHandler");
        this.thread.start();
    }

    public void setBridge(SAMBridge bridge) {
        this.bridge = bridge;
    }

    protected abstract void handle();

    protected final InputStream getClientSocketInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBytes(byte[] data) throws IOException {
        Object object = this.socketWLock;
        synchronized (object) {
            this.socketOS.write(data);
            this.socketOS.flush();
        }
    }

    protected Object getWriteLock() {
        return this.socketWLock;
    }

    protected OutputStream getOut() {
        return this.socketOS;
    }

    protected final boolean writeString(String str) {
        if (_log.shouldLog(10)) {
            _log.debug("Sending the client: [" + str + "]");
        }
        try {
            this.writeBytes(str.getBytes("ISO-8859-1"));
        }
        catch (IOException e) {
            _log.debug("Caught IOException", e);
            return false;
        }
        return true;
    }

    protected final void closeClientSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopHandling() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopHandler = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean shouldStop() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.stopHandler;
        }
    }

    public final String toString() {
        return "SAM handler (class: " + this.getClass().getName() + "; SAM version: " + this.verMajor + "." + this.verMinor + "; client: " + this.socket.getInetAddress().toString() + ":" + this.socket.getPort() + ")";
    }

    public final void run() {
        this.handle();
    }
}

