/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMDatagramSession;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMInvalidDirectionException;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.sam.SAMRawSession;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMUtils;
import net.i2p.util.Log;

public class SAMv1Handler
extends SAMHandler
implements SAMRawReceiver,
SAMDatagramReceiver,
SAMStreamReceiver {
    protected int verMajorId = 1;
    protected int verMinorId = 0;
    private static final Log _log = new Log(SAMv1Handler.class);
    private static final int IN_BUFSIZE = 2048;
    private SAMRawSession rawSession = null;
    private SAMDatagramSession datagramSession = null;
    protected SAMStreamSession streamSession = null;
    private long _id = ++__id;
    private static volatile long __id = 0L;

    public SAMv1Handler(Socket s, int verMajor, int verMinor) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties());
    }

    public SAMv1Handler(Socket s, int verMajor, int verMinor, Properties i2cpProps) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps);
        _log.debug("SAM version 1 handler instantiated");
        if (!this.verifVersion()) {
            throw new SAMException("BUG! Wrong protocol version!");
        }
    }

    public boolean verifVersion() {
        return this.verMajor == 1 && this.verMinor == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle() {
        block44: {
            String msg = null;
            String domain = null;
            String opcode = null;
            boolean canContinue = false;
            this.thread.setName("SAMv1Handler " + this._id);
            _log.debug("SAM handling started");
            InputStream in = this.getClientSocketInputStream();
            int b = -1;
            while (true) {
                if (this.shouldStop()) {
                    _log.debug("Stop request found");
                    break;
                }
                msg = DataHelper.readLine(in);
                if (msg == null) {
                    _log.debug("Connection closed by client");
                    break;
                }
                if (_log.shouldLog(10)) {
                    _log.debug("New message received: [" + msg + "]");
                }
                if (msg.equals("")) {
                    _log.debug("Ignoring newline");
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(msg, " ");
                if (tok.countTokens() < 2) {
                    _log.debug("Error in message format");
                    break;
                }
                domain = tok.nextToken();
                opcode = tok.nextToken();
                if (_log.shouldLog(10)) {
                    _log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                Properties props = SAMUtils.parseParams(tok);
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("DATAGRAM")) {
                    canContinue = this.execDatagramMessage(opcode, props);
                } else if (domain.equals("RAW")) {
                    canContinue = this.execRawMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else {
                    if (!domain.equals("NAMING")) {
                        _log.debug("Unrecognized message domain: \"" + domain + "\"");
                        break;
                    }
                    canContinue = this.execNamingMessage(opcode, props);
                }
                if (!canContinue) break;
            }
            Object var10_11 = null;
            _log.debug("Stopping handler");
            try {
                this.closeClientSocket();
            }
            catch (IOException e2) {
                _log.error("Error closing socket: " + e2.getMessage());
            }
            if (this.rawSession != null) {
                this.rawSession.close();
            }
            if (this.datagramSession != null) {
                this.datagramSession.close();
            }
            if (this.streamSession != null) {
                this.streamSession.close();
            }
            break block44;
            {
                catch (IOException e) {
                    _log.debug("Caught IOException (" + e.getMessage() + ") for message [" + msg + "]", e);
                    Object var10_12 = null;
                    _log.debug("Stopping handler");
                    try {
                        this.closeClientSocket();
                    }
                    catch (IOException e2) {
                        _log.error("Error closing socket: " + e2.getMessage());
                    }
                    if (this.rawSession != null) {
                        this.rawSession.close();
                    }
                    if (this.datagramSession != null) {
                        this.datagramSession.close();
                    }
                    if (this.streamSession != null) {
                        this.streamSession.close();
                    }
                    break block44;
                }
                catch (Exception e) {
                    _log.error("Unexpected exception for message [" + msg + "]", e);
                    Object var10_13 = null;
                    _log.debug("Stopping handler");
                    try {
                        this.closeClientSocket();
                    }
                    catch (IOException e2) {
                        _log.error("Error closing socket: " + e2.getMessage());
                    }
                    if (this.rawSession != null) {
                        this.rawSession.close();
                    }
                    if (this.datagramSession != null) {
                        this.datagramSession.close();
                    }
                    if (this.streamSession != null) {
                        this.streamSession.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                _log.debug("Stopping handler");
                try {
                    this.closeClientSocket();
                }
                catch (IOException e2) {
                    _log.error("Error closing socket: " + e2.getMessage());
                }
                if (this.rawSession != null) {
                    this.rawSession.close();
                }
                if (this.datagramSession != null) {
                    this.datagramSession.close();
                }
                if (this.streamSession != null) {
                    this.streamSession.close();
                }
                throw throwable;
            }
        }
    }

    private boolean execSessionMessage(String opcode, Properties props) {
        String dest = "BUG!";
        try {
            if (opcode.equals("CREATE")) {
                if (this.rawSession != null || this.datagramSession != null || this.streamSession != null) {
                    _log.debug("Trying to create a session, but one still exists");
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Session already exists\"\n");
                }
                if (props == null) {
                    _log.debug("No parameters specified in SESSION CREATE message");
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"No parameters for SESSION CREATE\"\n");
                }
                dest = props.getProperty("DESTINATION");
                if (dest == null) {
                    _log.debug("SESSION DESTINATION parameter not specified");
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"DESTINATION not specified\"\n");
                }
                props.remove("DESTINATION");
                String destKeystream = null;
                if (dest.equals("TRANSIENT")) {
                    _log.debug("TRANSIENT destination requested");
                    ByteArrayOutputStream priv = new ByteArrayOutputStream(640);
                    SAMUtils.genRandomKey(priv, null);
                    destKeystream = Base64.encode(priv.toByteArray());
                } else {
                    destKeystream = this.bridge.getKeystream(dest);
                    if (destKeystream == null) {
                        if (_log.shouldLog(10)) {
                            _log.debug("Custom destination specified [" + dest + "] but it isnt know, creating a new one");
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(640);
                        SAMUtils.genRandomKey(baos, null);
                        destKeystream = Base64.encode(baos.toByteArray());
                        this.bridge.addKeystream(dest, destKeystream);
                    } else if (_log.shouldLog(10)) {
                        _log.debug("Custom destination specified [" + dest + "] and it is already known");
                    }
                }
                String style = props.getProperty("STYLE");
                if (style == null) {
                    _log.debug("SESSION STYLE parameter not specified");
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"No SESSION STYLE specified\"\n");
                }
                props.remove("STYLE");
                if (style.equals("RAW")) {
                    this.rawSession = new SAMRawSession(destKeystream, props, (SAMRawReceiver)this);
                } else if (style.equals("DATAGRAM")) {
                    this.datagramSession = new SAMDatagramSession(destKeystream, props, (SAMDatagramReceiver)this);
                } else if (style.equals("STREAM")) {
                    String dir = props.getProperty("DIRECTION");
                    if (dir == null) {
                        _log.debug("No DIRECTION parameter in STREAM session, defaulting to BOTH");
                        dir = "BOTH";
                    }
                    if (!(dir.equals("CREATE") || dir.equals("RECEIVE") || dir.equals("BOTH"))) {
                        _log.debug("Unknow DIRECTION parameter value: [" + dir + "]");
                        return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unknown DIRECTION parameter\"\n");
                    }
                    props.remove("DIRECTION");
                    this.streamSession = this.newSAMStreamSession(destKeystream, dir, props);
                } else {
                    _log.debug("Unrecognized SESSION STYLE: \"" + style + "\"");
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unrecognized SESSION STYLE\"\n");
                }
                return this.writeString("SESSION STATUS RESULT=OK DESTINATION=" + dest + "\n");
            }
            _log.debug("Unrecognized SESSION message opcode: \"" + opcode + "\"");
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unrecognized opcode\"\n");
        }
        catch (DataFormatException e) {
            _log.debug("Invalid destination specified");
            return this.writeString("SESSION STATUS RESULT=INVALID_KEY DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
        catch (I2PSessionException e) {
            _log.debug("I2P error when instantiating session", e);
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
        catch (SAMException e) {
            _log.error("Unexpected SAM error", e);
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
        catch (IOException e) {
            _log.error("Unexpected IOException", e);
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
    }

    SAMStreamSession newSAMStreamSession(String destKeystream, String direction, Properties props) throws IOException, DataFormatException, SAMException {
        return new SAMStreamSession(destKeystream, direction, props, (SAMStreamReceiver)this);
    }

    private boolean execDestMessage(String opcode, Properties props) {
        if (opcode.equals("GENERATE")) {
            if (props.size() > 0) {
                _log.debug("Properties specified in DEST GENERATE message");
                return false;
            }
            ByteArrayOutputStream priv = new ByteArrayOutputStream();
            ByteArrayOutputStream pub = new ByteArrayOutputStream();
            SAMUtils.genRandomKey(priv, pub);
            return this.writeString("DEST REPLY PUB=" + Base64.encode(pub.toByteArray()) + " PRIV=" + Base64.encode(priv.toByteArray()) + "\n");
        }
        _log.debug("Unrecognized DEST message opcode: \"" + opcode + "\"");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean execNamingMessage(String opcode, Properties props) {
        Destination dest;
        String name;
        block9: {
            block10: {
                if (!opcode.equals("LOOKUP")) {
                    _log.debug("Unrecognized NAMING message opcode: \"" + opcode + "\"");
                    return false;
                }
                if (props == null) {
                    _log.debug("No parameters specified in NAMING LOOKUP message");
                    return false;
                }
                name = props.getProperty("NAME");
                if (name == null) {
                    _log.debug("Name to resolve not specified in NAMING message");
                    return false;
                }
                if (!name.equals("ME")) break block10;
                if (this.rawSession != null) {
                    dest = this.rawSession.getDestination();
                    break block9;
                } else if (this.streamSession != null) {
                    dest = this.streamSession.getDestination();
                    break block9;
                } else {
                    if (this.datagramSession == null) {
                        _log.debug("Lookup for SESSION destination, but session is null");
                        return false;
                    }
                    dest = this.datagramSession.getDestination();
                }
                break block9;
            }
            dest = SAMUtils.lookupHost(name, null);
        }
        if (dest == null) {
            return this.writeString("NAMING REPLY RESULT=KEY_NOT_FOUND NAME=" + name + "\n");
        }
        return this.writeString("NAMING REPLY RESULT=OK NAME=" + name + " VALUE=" + dest.toBase64() + "\n");
    }

    private boolean execDatagramMessage(String opcode, Properties props) {
        if (this.datagramSession == null) {
            _log.error("DATAGRAM message received, but no DATAGRAM session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            int size;
            if (props == null) {
                _log.debug("No parameters specified in DATAGRAM SEND message");
                return false;
            }
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                _log.debug("Destination not specified in DATAGRAM SEND message");
                return false;
            }
            String strsize = props.getProperty("SIZE");
            if (strsize == null) {
                _log.debug("Size not specified in DATAGRAM SEND message");
                return false;
            }
            try {
                size = Integer.parseInt(strsize);
            }
            catch (NumberFormatException e) {
                _log.debug("Invalid DATAGRAM SEND size specified: " + strsize);
                return false;
            }
            if (!this.checkDatagramSize(size)) {
                _log.debug("Specified size (" + size + ") is out of protocol limits");
                return false;
            }
            try {
                DataInputStream in = new DataInputStream(this.getClientSocketInputStream());
                byte[] data = new byte[size];
                in.readFully(data);
                if (!this.datagramSession.sendBytes(dest, data)) {
                    _log.error("DATAGRAM SEND failed");
                    return true;
                }
                return true;
            }
            catch (EOFException e) {
                _log.debug("Too few bytes with DATAGRAM SEND message (expected: " + size);
                return false;
            }
            catch (IOException e) {
                _log.debug("Caught IOException while parsing DATAGRAM SEND message", e);
                return false;
            }
            catch (DataFormatException e) {
                _log.debug("Invalid key specified with DATAGRAM SEND message", e);
                return false;
            }
        }
        _log.debug("Unrecognized DATAGRAM message opcode: \"" + opcode + "\"");
        return false;
    }

    private boolean execRawMessage(String opcode, Properties props) {
        if (this.rawSession == null) {
            _log.error("RAW message received, but no RAW session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            int size;
            if (props == null) {
                _log.debug("No parameters specified in RAW SEND message");
                return false;
            }
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                _log.debug("Destination not specified in RAW SEND message");
                return false;
            }
            String strsize = props.getProperty("SIZE");
            if (strsize == null) {
                _log.debug("Size not specified in RAW SEND message");
                return false;
            }
            try {
                size = Integer.parseInt(strsize);
            }
            catch (NumberFormatException e) {
                _log.debug("Invalid RAW SEND size specified: " + strsize);
                return false;
            }
            if (!this.checkSize(size)) {
                _log.debug("Specified size (" + size + ") is out of protocol limits");
                return false;
            }
            try {
                DataInputStream in = new DataInputStream(this.getClientSocketInputStream());
                byte[] data = new byte[size];
                in.readFully(data);
                if (!this.rawSession.sendBytes(dest, data)) {
                    _log.error("RAW SEND failed");
                    return true;
                }
                return true;
            }
            catch (EOFException e) {
                _log.debug("Too few bytes with RAW SEND message (expected: " + size);
                return false;
            }
            catch (IOException e) {
                _log.debug("Caught IOException while parsing RAW SEND message", e);
                return false;
            }
            catch (DataFormatException e) {
                _log.debug("Invalid key specified with RAW SEND message", e);
                return false;
            }
        }
        _log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        return false;
    }

    protected boolean execStreamMessage(String opcode, Properties props) {
        if (this.streamSession == null) {
            _log.error("STREAM message received, but no STREAM session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            return this.execStreamSend(props);
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("CLOSE")) {
            return this.execStreamClose(props);
        }
        _log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        return false;
    }

    protected boolean execStreamSend(Properties props) {
        int size;
        int id;
        if (props == null) {
            _log.debug("No parameters specified in STREAM SEND message");
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            _log.debug("ID not specified in STREAM SEND message");
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            _log.debug("Invalid STREAM SEND ID specified: " + strid);
            return false;
        }
        String strsize = props.getProperty("SIZE");
        if (strsize == null) {
            _log.debug("Size not specified in STREAM SEND message");
            return false;
        }
        try {
            size = Integer.parseInt(strsize);
        }
        catch (NumberFormatException e) {
            _log.debug("Invalid STREAM SEND size specified: " + strsize);
            return false;
        }
        if (!this.checkSize(size)) {
            _log.debug("Specified size (" + size + ") is out of protocol limits");
            return false;
        }
        try {
            if (!this.streamSession.sendBytes(id, this.getClientSocketInputStream(), size)) {
                if (_log.shouldLog(30)) {
                    _log.warn("STREAM SEND [" + size + "] failed");
                }
                boolean rv = this.writeString("STREAM CLOSED RESULT=CANT_REACH_PEER ID=" + id + " MESSAGE=\"Send of " + size + " bytes failed\"\n");
                this.streamSession.closeConnection(id);
                return rv;
            }
            return true;
        }
        catch (EOFException e) {
            _log.debug("Too few bytes with STREAM SEND message (expected: " + size);
            return false;
        }
        catch (IOException e) {
            _log.debug("Caught IOException while parsing STREAM SEND message", e);
            return false;
        }
    }

    protected boolean execStreamConnect(Properties props) {
        int id;
        if (props == null) {
            _log.debug("No parameters specified in STREAM CONNECT message");
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            _log.debug("ID not specified in STREAM SEND message");
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            _log.debug("Invalid STREAM CONNECT ID specified: " + strid);
            return false;
        }
        if (id < 1) {
            _log.debug("Invalid STREAM CONNECT ID specified: " + strid);
            return false;
        }
        props.remove("ID");
        String dest = props.getProperty("DESTINATION");
        if (dest == null) {
            _log.debug("Destination not specified in RAW SEND message");
            return false;
        }
        props.remove("DESTINATION");
        try {
            try {
                if (!this.streamSession.connect(id, dest, props)) {
                    _log.debug("STREAM connection failed");
                    return false;
                }
            }
            catch (DataFormatException e) {
                _log.debug("Invalid destination in STREAM CONNECT message");
                this.notifyStreamOutgoingConnection(id, "INVALID_KEY", null);
            }
            catch (SAMInvalidDirectionException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamOutgoingConnection(id, "INVALID_DIRECTION", null);
            }
            catch (ConnectException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamOutgoingConnection(id, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamOutgoingConnection(id, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamOutgoingConnection(id, "TIMEOUT", null);
            }
            catch (I2PException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamOutgoingConnection(id, "I2P_ERROR", null);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected boolean execStreamClose(Properties props) {
        int id;
        if (props == null) {
            _log.debug("No parameters specified in STREAM CLOSE message");
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            _log.debug("ID not specified in STREAM CLOSE message");
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            _log.debug("Invalid STREAM CLOSE ID specified: " + strid);
            return false;
        }
        boolean closed = this.streamSession.closeConnection(id);
        if (!closed && _log.shouldLog(30)) {
            _log.warn("Stream unable to be closed, but this is non fatal");
        }
        return true;
    }

    private boolean checkSize(int size) {
        return size >= 1 && size <= 32768;
    }

    private boolean checkDatagramSize(int size) {
        return size >= 1 && size <= 31744;
    }

    public void receiveRawBytes(byte[] data) throws IOException {
        if (this.rawSession == null) {
            _log.error("BUG! Received raw bytes, but session is null!");
            throw new NullPointerException("BUG! RAW session is null!");
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        String msgText = "RAW RECEIVED SIZE=" + data.length + "\n";
        msg.write(msgText.getBytes("ISO-8859-1"));
        msg.write(data);
        if (_log.shouldLog(10)) {
            _log.debug("sending to client: " + msgText);
        }
        this.writeBytes(msg.toByteArray());
    }

    public void stopRawReceiving() {
        block3: {
            _log.debug("stopRawReceiving() invoked");
            if (this.rawSession == null) {
                _log.error("BUG! Got raw receiving stop, but session is null!");
                throw new NullPointerException("BUG! RAW session is null!");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!_log.shouldLog(30)) break block3;
                _log.warn("Error closing socket", e);
            }
        }
    }

    public void receiveDatagramBytes(Destination sender, byte[] data) throws IOException {
        if (this.datagramSession == null) {
            _log.error("BUG! Received datagram bytes, but session is null!");
            throw new NullPointerException("BUG! DATAGRAM session is null!");
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        String msgText = "DATAGRAM RECEIVED DESTINATION=" + sender.toBase64() + " SIZE=" + data.length + "\n";
        msg.write(msgText.getBytes("ISO-8859-1"));
        if (_log.shouldLog(10)) {
            _log.debug("sending to client: " + msgText);
        }
        msg.write(data);
        this.writeBytes(msg.toByteArray());
    }

    public void stopDatagramReceiving() {
        block3: {
            _log.debug("stopDatagramReceiving() invoked");
            if (this.datagramSession == null) {
                _log.error("BUG! Got datagram receiving stop, but session is null!");
                throw new NullPointerException("BUG! DATAGRAM session is null!");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!_log.shouldLog(30)) break block3;
                _log.warn("Error closing socket", e);
            }
        }
    }

    public void streamSendAnswer(int id, String result, String bufferState) throws IOException {
        if (this.streamSession == null) {
            _log.error("BUG! Want to answer to stream SEND, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM SEND ID=" + id + " RESULT=" + result + " STATE=" + bufferState + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamSendBufferFree(int id) throws IOException {
        if (this.streamSession == null) {
            _log.error("BUG! Stream outgoing buffer is free, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM READY_TO_SEND ID=" + id + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamIncomingConnection(int id, Destination d) throws IOException {
        if (this.streamSession == null) {
            _log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM CONNECTED DESTINATION=" + d.toBase64() + " ID=" + id + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamOutgoingConnection(int id, String result, String msg) throws IOException {
        if (this.streamSession == null) {
            _log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        String msgString = "";
        if (msg != null) {
            msgString = " MESSAGE=\"" + msg + "\"";
        }
        if (!this.writeString("STREAM STATUS RESULT=" + result + " ID=" + id + msgString + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveStreamBytes(int id, byte[] data, int len) throws IOException {
        if (this.streamSession == null) {
            _log.error("Received stream bytes, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        String msgText = "STREAM RECEIVED ID=" + id + " SIZE=" + len + "\n";
        if (_log.shouldLog(10)) {
            _log.debug("sending to client: " + msgText);
        }
        byte[] prefix = msgText.getBytes("ISO-8859-1");
        Object writeLock = this.getWriteLock();
        OutputStream out = this.getOut();
        Object object = writeLock;
        synchronized (object) {
            out.write(prefix);
            out.write(data, 0, len);
            out.flush();
        }
    }

    public void notifyStreamDisconnection(int id, String result, String msg) throws IOException {
        if (this.streamSession == null) {
            _log.error("BUG! Received stream disconnection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM CLOSED ID=" + id + " RESULT=" + result + (msg == null ? "" : " MESSAGE=" + msg) + "\n")) {
            throw new IOException("Error notifying disconnection to SAM client");
        }
    }

    public void stopStreamReceiving() {
        block3: {
            _log.debug("stopStreamReceiving() invoked", new Exception("stopped"));
            if (this.streamSession == null) {
                _log.error("BUG! Got stream receiving stop, but session is null!");
                throw new NullPointerException("BUG! STREAM session is null!");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!_log.shouldLog(30)) break block3;
                _log.warn("Error closing socket", e);
            }
        }
    }
}

