/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import net.i2p.sam.TestUtil;
import net.i2p.util.Clock;
import net.i2p.util.Log;

public class TestCreateSessionRaw {
    private static Log _log = new Log(TestCreateSessionRaw.class);

    private static void runTest(String samHost, int samPort, String conOptions) {
        TestCreateSessionRaw.testTransient(samHost, samPort, conOptions);
        TestCreateSessionRaw.testNewDest(samHost, samPort, conOptions);
        TestCreateSessionRaw.testOldDest(samHost, samPort, conOptions);
        TestCreateSessionRaw.testFast(samHost, samPort, conOptions);
    }

    private static void testTransient(String host, int port, String conOptions) {
        TestCreateSessionRaw.testDest(host, port, conOptions, "TRANSIENT");
        _log.debug("\n\nTest of transient complete\n\n\n");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void testNewDest(String host, int port, String conOptions) {
        String destName = "Alice" + Math.random();
        TestCreateSessionRaw.testDest(host, port, conOptions, destName);
    }

    private static void testOldDest(String host, int port, String conOptions) {
        String destName = "Alice" + Math.random();
        TestCreateSessionRaw.testDest(host, port, conOptions, destName);
        _log.debug("\n\nTest of initial contact for " + destName + " complete, waiting 90 seconds");
        try {
            Thread.sleep(90000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        _log.debug("now testing subsequent contact\n\n\n");
        TestCreateSessionRaw.testDest(host, port, conOptions, destName);
        _log.debug("\n\nTest of subsequent contact complete\n\n");
    }

    private static void testFast(String host, int port, String conOptions) {
        String destName = "Alice" + Math.random();
        long totalTime = 0L;
        for (int i = 0; i < 10; ++i) {
            long before = Clock.getInstance().now();
            TestCreateSessionRaw.testDest(host, port, conOptions, destName);
            long after = Clock.getInstance().now();
            long difference = after - before;
            _log.debug("Time to test destination: " + difference + " \n\n");
            totalTime += difference;
        }
        _log.debug("\n\nTime to test fast reconnection: " + totalTime + " over 10 runs");
    }

    private static void testDest(String host, int port, String conOptions, String destName) {
        try {
            Socket s = new Socket(host, port);
            OutputStream out = s.getOutputStream();
            out.write("HELLO VERSION MIN=1.0 MAX=1.0\n".getBytes());
            BufferedReader reader = new BufferedReader(new InputStreamReader(s.getInputStream()));
            String line = reader.readLine();
            String req = "SESSION CREATE STYLE=RAW DESTINATION=" + destName + " " + conOptions + "\n";
            out.write(req.getBytes());
            line = reader.readLine();
            _log.info("Response to creating the session with destination " + destName + ": " + line);
            _log.debug("The above should contain SESSION STATUS RESULT=OK");
            s.close();
        }
        catch (Exception e) {
            _log.error("Error testing for valid version", e);
        }
    }

    public static void main(String[] args) {
        String conOptions = "i2cp.tcp.host=dev.i2p.net i2cp.tcp.port=7002 tunnels.depthInbound=0 tunnels.depthOutbound=0";
        if (args.length > 0) {
            conOptions = "";
            for (int i = 0; i < args.length; ++i) {
                conOptions = conOptions + " " + args[i];
            }
        }
        try {
            TestUtil.startupBridge(6000);
            TestCreateSessionRaw.runTest("localhost", 6000, conOptions);
        }
        catch (Throwable t) {
            _log.error("Error running test", t);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }
}

