/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.TestUtil;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class TestStreamTransfer {
    private static Log _log = new Log(TestStreamTransfer.class);
    private static String _alice = null;
    private static boolean _dead = false;
    private static Object _counterLock = new Object();
    private static int _recvCounter = 0;
    private static int _closeCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(String samHost, int samPort, String conOptions) {
        int nTests = 20;
        TestStreamTransfer.startAlice(samHost, samPort, conOptions);
        for (int i = 0; i < nTests; ++i) {
            TestStreamTransfer.testBob("bob" + i, samHost, samPort, conOptions);
            if (i % 2 != 1) continue;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        while (true) {
            Object i = _counterLock;
            synchronized (i) {
                if (_recvCounter == nTests * 2 && _closeCounter == nTests) {
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            _log.info("Receive counter is: " + _recvCounter + " Close counter is: " + _closeCounter);
        }
        _log.info("Unit test passed.");
    }

    private static void startAlice(String host, int port, String conOptions) {
        _log.info("\n\nStarting up Alice");
        try {
            Socket s = new Socket(host, port);
            OutputStream out = s.getOutputStream();
            out.write("HELLO VERSION MIN=1.0 MAX=1.0\n".getBytes());
            BufferedReader reader = new BufferedReader(new InputStreamReader(s.getInputStream()));
            String line = reader.readLine();
            _log.debug("line read for valid version: " + line);
            String req = "SESSION CREATE STYLE=STREAM DESTINATION=Alice " + conOptions + "\n";
            out.write(req.getBytes());
            line = reader.readLine();
            _log.info("Response to creating the session with destination Alice: " + line);
            req = "NAMING LOOKUP NAME=ME\n";
            out.write(req.getBytes());
            line = reader.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            String maj = tok.nextToken();
            String min = tok.nextToken();
            Properties props = SAMUtils.parseParams(tok);
            String value = props.getProperty("VALUE");
            if (value == null) {
                _log.error("No value for ME found!  [" + line + "]");
                return;
            }
            _log.info("Alice is located at " + value);
            _alice = value;
            I2PThread aliceThread = new I2PThread(new AliceRunner(reader, out, s));
            aliceThread.setName("Alice");
            aliceThread.start();
        }
        catch (Exception e) {
            _log.error("Error testing for valid version", e);
        }
    }

    private static void testBob(String sessionName, String host, int port, String conOptions) {
        I2PThread t = new I2PThread(new TestBob(sessionName, host, port, conOptions), sessionName);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTestBob(String sessionName, String host, int port, String conOptions) {
        _log.info("\n\nTesting " + sessionName + "\n\n\n");
        try {
            Socket s = new Socket(host, port);
            OutputStream out = s.getOutputStream();
            out.write("HELLO VERSION MIN=1.0 MAX=1.0\n".getBytes());
            BufferedReader reader = new BufferedReader(new InputStreamReader(s.getInputStream()));
            String line = reader.readLine();
            _log.debug("line read for valid version: " + line);
            String req = "SESSION CREATE STYLE=STREAM DESTINATION=" + sessionName + " " + conOptions + "\n";
            out.write(req.getBytes());
            line = reader.readLine();
            _log.info("Response to creating the session with destination " + sessionName + ": " + line);
            req = "STREAM CONNECT ID=42 DESTINATION=" + _alice + "\n";
            out.write(req.getBytes());
            line = reader.readLine();
            _log.info("Response to the stream connect from " + sessionName + " to Alice: " + line);
            StringTokenizer tok = new StringTokenizer(line);
            String maj = tok.nextToken();
            String min = tok.nextToken();
            Properties props = SAMUtils.parseParams(tok);
            _log.info("props = " + props);
            String result = props.getProperty("RESULT");
            if (!"OK".equals(result)) {
                _log.error("Unable to connect!");
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            req = "STREAM SEND ID=42 SIZE=10\nBlahBlah!!";
            _log.info("\n** Sending BlahBlah!!");
            out.write(req.getBytes());
            out.flush();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            req = "STREAM SEND ID=42 SIZE=10\nFooBarBaz!";
            _log.info("\n** Sending FooBarBaz!");
            out.write(req.getBytes());
            out.flush();
            _log.info("Sending close");
            req = "STREAM CLOSE ID=42\n";
            out.write(req.getBytes());
            out.flush();
            Object ie = _counterLock;
            synchronized (ie) {
                ++_closeCounter;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie2) {
                // empty catch block
            }
            s.close();
        }
        catch (Exception e) {
            _log.error("Error testing for valid version", e);
        }
    }

    public static void main(String[] args) {
        String conOptions = "i2cp.tcp.host=localhost i2cp.tcp.port=10001 tunnels.inboundDepth=0";
        if (args.length > 0) {
            conOptions = "";
            for (int i = 0; i < args.length; ++i) {
                conOptions = conOptions + " " + args[i];
            }
        }
        try {
            TestUtil.startupBridge(6000);
            TestStreamTransfer.runTest("localhost", 6000, conOptions);
        }
        catch (Throwable t) {
            _log.error("Error running test", t);
        }
    }

    private static class TestBob
    implements Runnable {
        private String _sessionName;
        private String _host;
        private int _port;
        private String _opts;

        public TestBob(String name, String host, int port, String opts) {
            this._sessionName = name;
            this._host = host;
            this._port = port;
            this._opts = opts;
        }

        public void run() {
            TestStreamTransfer.doTestBob(this._sessionName, this._host, this._port, this._opts);
        }
    }

    private static class AliceRunner
    implements Runnable {
        private BufferedReader _reader;
        private OutputStream _out;
        private Socket _s;
        private Map _streams;

        public AliceRunner(BufferedReader reader, OutputStream out, Socket s) {
            this._reader = reader;
            this._out = out;
            this._s = s;
            this._streams = Collections.synchronizedMap(new HashMap(4));
        }

        public void run() {
            while (!_dead) {
                try {
                    this.doRun();
                }
                catch (Exception e) {
                    _log.error("Error running alice", e);
                    try {
                        this._reader.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        this._s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this._streams.clear();
                    _dead = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws IOException, SAMException {
            String line = this._reader.readLine();
            _log.debug("Read: " + line);
            StringTokenizer tok = new StringTokenizer(line);
            String maj = tok.nextToken();
            String min = tok.nextToken();
            Properties props = SAMUtils.parseParams(tok);
            if ("STREAM".equals(maj) && "CONNECTED".equals(min)) {
                String dest = props.getProperty("DESTINATION");
                String id = props.getProperty("ID");
                if (dest == null || id == null) {
                    _log.error("Invalid STREAM CONNECTED line: [" + line + "]");
                    return;
                }
                dest = dest.trim();
                id = id.trim();
                this._streams.put(id, dest);
            } else if ("STREAM".equals(maj) && "CLOSED".equals(min)) {
                String id = props.getProperty("ID");
                if (id == null) {
                    _log.error("Invalid STREAM CLOSED line: [" + line + "]");
                    return;
                }
                this._streams.remove(id);
            } else if ("STREAM".equals(maj) && "RECEIVED".equals(min)) {
                String id = props.getProperty("ID");
                String size = props.getProperty("SIZE");
                if (id == null || size == null) {
                    _log.error("Invalid STREAM RECEIVED line: [" + line + "]");
                    return;
                }
                id = id.trim();
                size = size.trim();
                int payloadSize = -1;
                try {
                    payloadSize = Integer.parseInt(size);
                }
                catch (NumberFormatException nfe) {
                    _log.error("Invalid SIZE in message [" + size + "]");
                    return;
                }
                char[] payload = new char[payloadSize];
                int read = this._reader.read(payload);
                if (read != payloadSize) {
                    _log.error("Incorrect size read - expected " + payloadSize + " got " + read);
                    return;
                }
                _log.info("\n== Received from the stream " + id + ": [" + new String(payload) + "]");
                Object object = _counterLock;
                synchronized (object) {
                    _recvCounter++;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {}
            } else {
                _log.error("Received unsupported type [" + maj + "/" + min + "]");
                return;
            }
        }
    }
}

