/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class ConnectCloseTest {
    private Log _log;
    private I2PSession _server;

    public void test() {
        try {
            I2PAppContext context = I2PAppContext.getGlobalContext();
            this._log = context.logManager().getLog(ConnectCloseTest.class);
            this._log.debug("creating server session");
            this._server = this.createSession();
            this._log.debug("running server");
            this.runServer(context, this._server);
            this._log.debug("running client");
            this.runClient(context, this.createSession());
        }
        catch (Exception e) {
            this._log.error("error running", (Throwable)e);
        }
        try {
            Thread.sleep(600000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void runClient(I2PAppContext ctx, I2PSession session) {
        Thread t = new Thread(new ClientRunner(ctx, session));
        t.setName("client");
        t.setDaemon(true);
        t.start();
    }

    private void runServer(I2PAppContext ctx, I2PSession session) {
        Thread t = new Thread(new ServerRunner(ctx, session));
        t.setName("server");
        t.setDaemon(true);
        t.start();
    }

    private I2PSession createSession() {
        try {
            I2PClient client = I2PClientFactory.createClient();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            Destination dest = client.createDestination((OutputStream)baos);
            I2PSession sess = client.createSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), System.getProperties());
            sess.connect();
            return sess;
        }
        catch (Exception e) {
            this._log.error("error running", (Throwable)e);
            throw new RuntimeException("b0rk b0rk b0rk");
        }
    }

    public static void main(String[] args) {
        ConnectCloseTest ct = new ConnectCloseTest();
        ct.test();
    }

    private class ClientRunner
    implements Runnable {
        private I2PAppContext _context;
        private I2PSession _session;
        private Log _log;

        public ClientRunner(I2PAppContext ctx, I2PSession session) {
            this._context = ctx;
            this._session = session;
            this._log = ctx.logManager().getLog(ClientRunner.class);
        }

        public void run() {
            try {
                Properties opts = new Properties();
                I2PSocketManagerFull mgr = new I2PSocketManagerFull(this._context, this._session, opts, "client");
                this._log.debug("* manager created");
                I2PSocket socket = mgr.connect(ConnectCloseTest.this._server.getMyDestination());
                this._log.debug("* socket created");
                InputStream in = socket.getInputStream();
                int c = in.read();
                if (c != -1) {
                    throw new RuntimeException("hrm, we got data?  [" + c + "]");
                }
                socket.close();
                this._log.debug("* socket closed");
                mgr.destroySocketManager();
                mgr = null;
                Object var3_5 = null;
            }
            catch (Exception e) {
                this._log.error("error running", (Throwable)e);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private class ServerRunner
    implements Runnable {
        private I2PAppContext _context;
        private I2PSession _session;
        private Log _log;

        public ServerRunner(I2PAppContext ctx, I2PSession session) {
            this._context = ctx;
            this._session = session;
            this._log = ctx.logManager().getLog(ServerRunner.class);
        }

        public void run() {
            try {
                Properties opts = new Properties();
                I2PSocketManagerFull mgr = new I2PSocketManagerFull(this._context, this._session, opts, "client");
                this._log.debug("* manager created");
                I2PServerSocket ssocket = mgr.getServerSocket();
                this._log.debug("* server socket created");
                while (true) {
                    I2PSocket socket = ssocket.accept();
                    this._log.debug("* socket accepted: " + socket);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    socket.close();
                    this._log.debug("* socket closed: " + socket);
                }
            }
            catch (Exception e) {
                this._log.error("error running", (Throwable)e);
                return;
            }
        }
    }
}

