/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.ConnectTest;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class ConnectTimeoutTest {
    private Log _log;
    private I2PSession _client;
    private I2PSession _server;
    private Destination _serverDest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonexistant() {
        try {
            I2PAppContext context = I2PAppContext.getGlobalContext();
            this._log = context.logManager().getLog(ConnectTest.class);
            this._log.debug("creating server dest");
            try {
                this._serverDest = I2PClientFactory.createClient().createDestination((OutputStream)new ByteArrayOutputStream());
            }
            catch (Exception e) {
                // empty catch block
            }
            this._log.debug("creating client session");
            this._client = this.createSession();
            this._log.debug("running client");
            this.runClient(context, this._client);
        }
        catch (Exception e) {
            this._log.error("error running", (Throwable)e);
        }
        while (true) {
            ConnectTimeoutTest connectTimeoutTest = this;
            synchronized (connectTimeoutTest) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void runClient(I2PAppContext ctx, I2PSession session) {
        Thread t = new Thread(new ClientRunner(ctx, session));
        t.setName("client");
        t.setDaemon(true);
        t.start();
    }

    private I2PSession createSession() {
        try {
            I2PClient client = I2PClientFactory.createClient();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            Destination dest = client.createDestination((OutputStream)baos);
            Properties p = ConnectTimeoutTest.getProps();
            I2PSession sess = client.createSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), p);
            sess.connect();
            return sess;
        }
        catch (Exception e) {
            this._log.error("error running", (Throwable)e);
            throw new RuntimeException("b0rk b0rk b0rk");
        }
    }

    public static void main(String[] args) {
        ConnectTimeoutTest ct = new ConnectTimeoutTest();
        ct.testNonexistant();
    }

    private static Properties getProps() {
        Properties p = new Properties();
        p.setProperty("i2p.streaming.manager", I2PSocketManagerFull.class.getName());
        p.setProperty("tunnels.depthInbound", "0");
        p.setProperty("i2cp.tcp.host", "localhost");
        p.setProperty("i2cp.tcp.port", "10001");
        p.setProperty("i2p.streaming.connectTimeout", "30000");
        p.setProperty("i2p.streaming.connectDelay", "0");
        return p;
    }

    private class ClientRunner
    implements Runnable {
        private I2PAppContext _context;
        private I2PSession _session;
        private Log _log;

        public ClientRunner(I2PAppContext ctx, I2PSession session) {
            this._context = ctx;
            this._session = session;
            this._log = ctx.logManager().getLog(ClientRunner.class);
        }

        public void run() {
            try {
                I2PSocketManager mgr = I2PSocketManagerFactory.createManager((String)"localhost", (int)10001, (Properties)ConnectTimeoutTest.getProps());
                this._log.debug("manager created");
                this._log.debug("options: " + mgr.getDefaultOptions());
                I2PSocket socket = mgr.connect(ConnectTimeoutTest.this._serverDest);
                this._log.debug("socket created");
                socket.getOutputStream().write("you smell".getBytes());
                socket.getOutputStream().flush();
                this._log.error("wtf, shouldn't have flushed");
                socket.close();
                this._log.debug("socket closed");
            }
            catch (Exception e) {
                this._log.error("error running (yay!)", (Throwable)e);
            }
        }
    }
}

