/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.Properties;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.I2PSocketOptionsImpl;

public class ConnectionOptions
extends I2PSocketOptionsImpl {
    private int _connectDelay;
    private boolean _fullySigned;
    private volatile int _windowSize;
    private int _receiveWindow;
    private int _profile;
    private int _rtt;
    private int _rttDev;
    private int _rto;
    private int[] _trend;
    private int _resendDelay;
    private int _sendAckDelay;
    private int _maxMessageSize;
    private int _choke;
    private int _maxResends;
    private int _inactivityTimeout;
    private int _inactivityAction;
    private int _inboundBufferSize;
    private int _maxWindowSize;
    private int _congestionAvoidanceGrowthRateFactor;
    private int _slowStartGrowthRateFactor;
    public static final int PROFILE_BULK = 1;
    public static final int PROFILE_INTERACTIVE = 2;
    public static final int INACTIVITY_ACTION_NOOP = 0;
    public static final int INACTIVITY_ACTION_DISCONNECT = 1;
    public static final int INACTIVITY_ACTION_SEND = 2;
    public static final String PROP_CONNECT_DELAY = "i2p.streaming.connectDelay";
    public static final String PROP_PROFILE = "i2p.streaming.profile";
    public static final String PROP_MAX_MESSAGE_SIZE = "i2p.streaming.maxMessageSize";
    public static final String PROP_MAX_RESENDS = "i2p.streaming.maxResends";
    public static final String PROP_INITIAL_RTT = "i2p.streaming.initialRTT";
    public static final String PROP_INITIAL_RESEND_DELAY = "i2p.streaming.initialResendDelay";
    public static final String PROP_INITIAL_ACK_DELAY = "i2p.streaming.initialAckDelay";
    public static final String PROP_INITIAL_WINDOW_SIZE = "i2p.streaming.initialWindowSize";
    public static final String PROP_INITIAL_RECEIVE_WINDOW = "i2p.streaming.initialReceiveWindow";
    public static final String PROP_INACTIVITY_TIMEOUT = "i2p.streaming.inactivityTimeout";
    public static final String PROP_INACTIVITY_ACTION = "i2p.streaming.inactivityAction";
    public static final String PROP_MAX_WINDOW_SIZE = "i2p.streaming.maxWindowSize";
    public static final String PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR = "i2p.streaming.congestionAvoidanceGrowthRateFactor";
    public static final String PROP_SLOW_START_GROWTH_RATE_FACTOR = "i2p.streaming.slowStartGrowthRateFactor";
    private static final int TREND_COUNT = 3;
    static final int INITIAL_WINDOW_SIZE = 12;
    static final int DEFAULT_MAX_SENDS = 8;
    public static final int DEFAULT_INITIAL_RTT = 10000;
    static final int MIN_WINDOW_SIZE = 1;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 1730;
    public static final int MIN_MESSAGE_SIZE = 512;
    private static final double RTT_DAMPENING = 0.875;

    public ConnectionOptions() {
    }

    public ConnectionOptions(Properties opts) {
        super(opts);
    }

    public ConnectionOptions(I2PSocketOptions opts) {
        super(opts);
    }

    public ConnectionOptions(ConnectionOptions opts) {
        super((I2PSocketOptions)opts);
        if (opts != null) {
            this.setMaxWindowSize(opts.getMaxWindowSize());
            this.setConnectDelay(opts.getConnectDelay());
            this.setProfile(opts.getProfile());
            this.setRTT(opts.getRTT());
            this.setRequireFullySigned(opts.getRequireFullySigned());
            this.setWindowSize(opts.getWindowSize());
            this.setResendDelay(opts.getResendDelay());
            this.setMaxMessageSize(opts.getMaxMessageSize());
            this.setChoke(opts.getChoke());
            this.setMaxResends(opts.getMaxResends());
            this.setInactivityTimeout(opts.getInactivityTimeout());
            this.setInactivityAction(opts.getInactivityAction());
            this.setInboundBufferSize(opts.getInboundBufferSize());
            this.setCongestionAvoidanceGrowthRateFactor(opts.getCongestionAvoidanceGrowthRateFactor());
            this.setSlowStartGrowthRateFactor(opts.getSlowStartGrowthRateFactor());
            this.setWriteTimeout(opts.getWriteTimeout());
            this.setReadTimeout(opts.getReadTimeout());
        }
    }

    protected void init(Properties opts) {
        super.init(opts);
        this._trend = new int[3];
        this.setMaxWindowSize(this.getInt(opts, PROP_MAX_WINDOW_SIZE, 128));
        this.setConnectDelay(this.getInt(opts, PROP_CONNECT_DELAY, -1));
        this.setProfile(this.getInt(opts, PROP_PROFILE, 1));
        this.setMaxMessageSize(this.getInt(opts, PROP_MAX_MESSAGE_SIZE, 1730));
        this.setRTT(this.getInt(opts, PROP_INITIAL_RTT, 10000));
        this.setReceiveWindow(this.getInt(opts, PROP_INITIAL_RECEIVE_WINDOW, 1));
        this.setResendDelay(this.getInt(opts, PROP_INITIAL_RESEND_DELAY, 1000));
        this.setSendAckDelay(this.getInt(opts, PROP_INITIAL_ACK_DELAY, 2000));
        this.setWindowSize(this.getInt(opts, PROP_INITIAL_WINDOW_SIZE, 12));
        this.setMaxResends(this.getInt(opts, PROP_MAX_RESENDS, 8));
        this.setWriteTimeout(this.getInt(opts, "i2p.streaming.writeTimeout", -1));
        this.setInactivityTimeout(this.getInt(opts, PROP_INACTIVITY_TIMEOUT, 90000));
        this.setInactivityAction(this.getInt(opts, PROP_INACTIVITY_ACTION, 2));
        this.setInboundBufferSize(this.getMaxMessageSize() * 130);
        this.setCongestionAvoidanceGrowthRateFactor(this.getInt(opts, PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR, 1));
        this.setSlowStartGrowthRateFactor(this.getInt(opts, PROP_SLOW_START_GROWTH_RATE_FACTOR, 1));
        this.setConnectTimeout(this.getInt(opts, "i2p.streaming.connectTimeout", 300000));
    }

    public void setProperties(Properties opts) {
        super.setProperties(opts);
        if (opts == null) {
            return;
        }
        if (opts.containsKey(PROP_MAX_WINDOW_SIZE)) {
            this.setMaxWindowSize(this.getInt(opts, PROP_MAX_WINDOW_SIZE, 128));
        }
        if (opts.containsKey(PROP_CONNECT_DELAY)) {
            this.setConnectDelay(this.getInt(opts, PROP_CONNECT_DELAY, -1));
        }
        if (opts.containsKey(PROP_PROFILE)) {
            this.setProfile(this.getInt(opts, PROP_PROFILE, 1));
        }
        if (opts.containsKey(PROP_MAX_MESSAGE_SIZE)) {
            this.setMaxMessageSize(this.getInt(opts, PROP_MAX_MESSAGE_SIZE, 32768));
        }
        if (opts.containsKey(PROP_INITIAL_RTT)) {
            this.setRTT(this.getInt(opts, PROP_INITIAL_RTT, 10000));
        }
        if (opts.containsKey(PROP_INITIAL_RECEIVE_WINDOW)) {
            this.setReceiveWindow(this.getInt(opts, PROP_INITIAL_RECEIVE_WINDOW, 1));
        }
        if (opts.containsKey(PROP_INITIAL_RESEND_DELAY)) {
            this.setResendDelay(this.getInt(opts, PROP_INITIAL_RESEND_DELAY, 1000));
        }
        if (opts.containsKey(PROP_INITIAL_ACK_DELAY)) {
            this.setSendAckDelay(this.getInt(opts, PROP_INITIAL_ACK_DELAY, 2000));
        }
        if (opts.containsKey(PROP_INITIAL_WINDOW_SIZE)) {
            this.setWindowSize(this.getInt(opts, PROP_INITIAL_WINDOW_SIZE, 12));
        }
        if (opts.containsKey(PROP_MAX_RESENDS)) {
            this.setMaxResends(this.getInt(opts, PROP_MAX_RESENDS, 8));
        }
        if (opts.containsKey("i2p.streaming.writeTimeout")) {
            this.setWriteTimeout(this.getInt(opts, "i2p.streaming.writeTimeout", -1));
        }
        if (opts.containsKey(PROP_INACTIVITY_TIMEOUT)) {
            this.setInactivityTimeout(this.getInt(opts, PROP_INACTIVITY_TIMEOUT, 90000));
        }
        if (opts.containsKey(PROP_INACTIVITY_ACTION)) {
            this.setInactivityAction(this.getInt(opts, PROP_INACTIVITY_ACTION, 2));
        }
        this.setInboundBufferSize(this.getMaxMessageSize() * 130);
        if (opts.contains(PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR)) {
            this.setCongestionAvoidanceGrowthRateFactor(this.getInt(opts, PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR, 2));
        }
        if (opts.contains(PROP_SLOW_START_GROWTH_RATE_FACTOR)) {
            this.setSlowStartGrowthRateFactor(this.getInt(opts, PROP_SLOW_START_GROWTH_RATE_FACTOR, 2));
        }
        if (opts.containsKey("i2p.streaming.connectTimeout")) {
            this.setConnectTimeout(this.getInt(opts, "i2p.streaming.connectTimeout", 300000));
        }
    }

    public int getConnectDelay() {
        return this._connectDelay;
    }

    public void setConnectDelay(int delayMs) {
        this._connectDelay = delayMs;
    }

    public boolean getRequireFullySigned() {
        return this._fullySigned;
    }

    public void setRequireFullySigned(boolean sign) {
        this._fullySigned = sign;
    }

    public int getWindowSize() {
        return this._windowSize;
    }

    public void setWindowSize(int numMsgs) {
        if (numMsgs <= 0) {
            numMsgs = 1;
        }
        if (numMsgs < 1) {
            numMsgs = 1;
        }
        if (numMsgs > this._maxWindowSize) {
            numMsgs = this._maxWindowSize;
        }
        this._windowSize = numMsgs;
    }

    public int getReceiveWindow() {
        return this._receiveWindow;
    }

    public void setReceiveWindow(int numMsgs) {
        this._receiveWindow = numMsgs;
    }

    public int getRTT() {
        return this._rtt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRTT(int ms) {
        if (this._rto == 0) {
            this._rttDev = ms / 2;
            this._rto = ms + ms / 2;
        }
        int[] nArray = this._trend;
        synchronized (this._trend) {
            this._trend[0] = this._trend[1];
            this._trend[1] = this._trend[2];
            this._trend[2] = ms > this._rtt ? 1 : (ms < this._rtt ? -1 : 0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this._rtt = ms;
            if (this._rtt > 60000) {
                this._rtt = 60000;
            }
            return;
        }
    }

    public int getRTO() {
        return this._rto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRTTTrend() {
        int[] nArray = this._trend;
        synchronized (this._trend) {
            for (int i = 0; i < 2; ++i) {
                if (this._trend[i] == this._trend[i + 1]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._trend[0];
        }
    }

    public void updateRTT(int measuredValue) {
        this._rttDev += (int)(0.25 * (double)(Math.abs(measuredValue - this._rtt) - this._rttDev));
        int smoothed = (int)(0.875 * (double)this._rtt + 0.125 * (double)measuredValue);
        this._rto = smoothed + (this._rttDev << 2);
        if ((long)this._rto < 2000L) {
            this._rto = 2000;
        } else if ((long)this._rto > 45000L) {
            this._rto = 45000;
        }
        this.setRTT(smoothed);
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public void setResendDelay(int ms) {
        this._resendDelay = ms;
    }

    public int getSendAckDelay() {
        return this._sendAckDelay;
    }

    public void setSendAckDelay(int delayMs) {
        this._sendAckDelay = delayMs;
    }

    public int getMaxMessageSize() {
        return this._maxMessageSize;
    }

    public void setMaxMessageSize(int bytes) {
        this._maxMessageSize = Math.max(bytes, 512);
    }

    public int getChoke() {
        return this._choke;
    }

    public void setChoke(int ms) {
        this._choke = ms;
    }

    public int getProfile() {
        return this._profile;
    }

    public void setProfile(int profile) {
        if (profile != 1) {
            throw new IllegalArgumentException("Only bulk is supported so far");
        }
        this._profile = profile;
    }

    public int getMaxResends() {
        return this._maxResends;
    }

    public void setMaxResends(int numSends) {
        this._maxResends = Math.max(numSends, 0);
    }

    public int getInactivityTimeout() {
        return this._inactivityTimeout;
    }

    public void setInactivityTimeout(int timeout) {
        this._inactivityTimeout = timeout;
    }

    public int getInactivityAction() {
        return this._inactivityAction;
    }

    public void setInactivityAction(int action) {
        this._inactivityAction = action;
    }

    public int getMaxWindowSize() {
        return this._maxWindowSize;
    }

    public void setMaxWindowSize(int msgs) {
        this._maxWindowSize = msgs > 128 ? 128 : (msgs < 1 ? 1 : msgs);
    }

    public int getInboundBufferSize() {
        return this._inboundBufferSize;
    }

    public void setInboundBufferSize(int bytes) {
        this._inboundBufferSize = bytes;
    }

    public int getCongestionAvoidanceGrowthRateFactor() {
        return this._congestionAvoidanceGrowthRateFactor;
    }

    public void setCongestionAvoidanceGrowthRateFactor(int factor) {
        this._congestionAvoidanceGrowthRateFactor = factor;
    }

    public int getSlowStartGrowthRateFactor() {
        return this._slowStartGrowthRateFactor;
    }

    public void setSlowStartGrowthRateFactor(int factor) {
        this._slowStartGrowthRateFactor = factor;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("conDelay=").append(this._connectDelay);
        buf.append(" maxSize=").append(this._maxMessageSize);
        buf.append(" rtt=").append(this._rtt);
        buf.append(" rwin=").append(this._receiveWindow);
        buf.append(" resendDelay=").append(this._resendDelay);
        buf.append(" ackDelay=").append(this._sendAckDelay);
        buf.append(" cwin=").append(this._windowSize);
        buf.append(" maxResends=").append(this._maxResends);
        buf.append(" writeTimeout=").append(this.getWriteTimeout());
        buf.append(" readTimeout=").append(this.getReadTimeout());
        buf.append(" inactivityTimeout=").append(this._inactivityTimeout);
        buf.append(" inboundBuffer=").append(this._inboundBufferSize);
        buf.append(" maxWindowSize=").append(this._maxWindowSize);
        return buf.toString();
    }

    public static void main(String[] args) {
        Properties p = new Properties();
        p.setProperty(PROP_CONNECT_DELAY, "1000");
        ConnectionOptions c = new ConnectionOptions(p);
        System.out.println("opts: " + (Object)((Object)c));
        c = new ConnectionOptions((I2PSocketOptions)new I2PSocketOptionsImpl(p));
        System.out.println("opts: " + (Object)((Object)c));
    }
}

