/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.RetransmissionTimer;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class MessageOutputStream
extends OutputStream {
    private I2PAppContext _context;
    private Log _log;
    private byte[] _buf;
    private int _valid;
    private Object _dataLock;
    private DataReceiver _dataReceiver;
    private IOException _streamError;
    private boolean _closed;
    private long _written;
    private int _writeTimeout;
    private ByteCache _dataCache;
    private Flusher _flusher;
    private long _lastFlushed;
    private long _lastBuffered;
    private int _passiveFlushDelay;
    private volatile int _nextBufferSize;
    private long _sendPeriodBeginTime;
    private long _sendPeriodBytes;
    private int _sendBps;
    private static final int DEFAULT_PASSIVE_FLUSH_DELAY = 250;

    public MessageOutputStream(I2PAppContext ctx, DataReceiver receiver) {
        this(ctx, receiver, 32768);
    }

    public MessageOutputStream(I2PAppContext ctx, DataReceiver receiver, int bufSize) {
        this(ctx, receiver, bufSize, 250);
    }

    public MessageOutputStream(I2PAppContext ctx, DataReceiver receiver, int bufSize, int passiveFlushDelay) {
        this._dataCache = ByteCache.getInstance((int)128, (int)bufSize);
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageOutputStream.class);
        this._buf = this._dataCache.acquire().getData();
        this._dataReceiver = receiver;
        this._dataLock = new Object();
        this._written = 0L;
        this._closed = false;
        this._writeTimeout = -1;
        this._passiveFlushDelay = passiveFlushDelay;
        this._nextBufferSize = -1;
        this._sendPeriodBeginTime = ctx.clock().now();
        this._sendPeriodBytes = 0L;
        this._sendBps = 0;
        this._context.statManager().createRateStat("stream.sendBps", "How fast we pump data through the stream", "Stream", new long[]{60000L, 300000L, 3600000L});
        this._flusher = new Flusher();
        if (this._log.shouldLog(10)) {
            this._log.debug("MessageOutputStream created");
        }
    }

    public void setWriteTimeout(int ms) {
        if (this._log.shouldLog(20)) {
            this._log.info("Changing write timeout from " + this._writeTimeout + " to " + ms);
        }
        this._writeTimeout = ms;
    }

    public int getWriteTimeout() {
        return this._writeTimeout;
    }

    public void setBufferSize(int size) {
        this._nextBufferSize = size;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException("Already closed");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("write(b[], " + off + ", " + len + ") ");
        }
        int cur = off;
        int remaining = len;
        long begin = this._context.clock().now();
        while (remaining > 0) {
            WriteStatus ws = null;
            Object object = this._dataLock;
            synchronized (object) {
                if (this._buf == null) {
                    throw new IOException("closed (buffer went away)");
                }
                if (this._valid + remaining < this._buf.length) {
                    System.arraycopy(b, cur, this._buf, this._valid, remaining);
                    this._valid += remaining;
                    cur += remaining;
                    this._written += (long)remaining;
                    remaining = 0;
                    this._lastBuffered = this._context.clock().now();
                    if (this._passiveFlushDelay > 0) {
                        this._flusher.enqueue();
                    }
                } else {
                    int toWrite = this._buf.length - this._valid;
                    System.arraycopy(b, cur, this._buf, this._valid, toWrite);
                    remaining -= toWrite;
                    cur += toWrite;
                    this._valid = this._buf.length;
                    if (this._dataReceiver == null) {
                        this.throwAnyError();
                        return;
                    }
                    ws = this._dataReceiver.writeData(this._buf, 0, this._valid);
                    this._written += (long)this._valid;
                    this._valid = 0;
                    this.throwAnyError();
                    this._lastFlushed = this._context.clock().now();
                    this.locked_updateBufferSize();
                }
            }
            if (ws != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Waiting " + this._writeTimeout + "ms for accept of " + ws);
                }
                ws.waitForAccept(this._writeTimeout);
                if (ws.writeAccepted()) continue;
                if (this._writeTimeout > 0) {
                    throw new InterruptedIOException("Write not accepted within timeout: " + ws);
                }
                throw new IOException("Write not accepted into the queue: " + ws);
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Queued " + len + " without sending to the receiver");
        }
        long elapsed = this._context.clock().now() - begin;
        if (elapsed > 10000L && this._log.shouldLog(10)) {
            this._log.debug("wtf, took " + elapsed + "ms to write to the stream?", (Throwable)new Exception("foo"));
        }
        this.throwAnyError();
        this.updateBps(len);
    }

    private void updateBps(int len) {
        long now = this._context.clock().now();
        int periods = (int)Math.floor((double)(now - this._sendPeriodBeginTime) / 1000.0);
        if (periods > 0) {
            this._sendBps = (int)(0.9f * ((float)this._sendBps / (float)periods) + 0.1f * ((float)this._sendPeriodBytes / (float)periods));
            this._sendPeriodBytes = len;
            this._sendPeriodBeginTime = now;
            this._context.statManager().addRateData("stream.sendBps", (long)this._sendBps, 0L);
        } else {
            this._sendPeriodBytes += (long)len;
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
        this.throwAnyError();
    }

    private final void locked_updateBufferSize() {
        int size = this._nextBufferSize;
        if (size > 0) {
            this._dataCache.release(new ByteArray(this._buf));
            this._dataCache = ByteCache.getInstance((int)128, (int)size);
            ByteArray ba = this._dataCache.acquire();
            this._buf = ba.getData();
            this._nextBufferSize = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        long begin = this._context.clock().now();
        WriteStatus ws = null;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._buf == null) {
                this._dataLock.notifyAll();
                throw new IOException("closed (buffer went away)");
            }
            if (this._dataReceiver == null) {
                this._dataLock.notifyAll();
                this.throwAnyError();
                return;
            }
            ws = this._dataReceiver.writeData(this._buf, 0, this._valid);
            this._written += (long)this._valid;
            this._valid = 0;
            this.locked_updateBufferSize();
            this._lastFlushed = this._context.clock().now();
            this._dataLock.notifyAll();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("before waiting " + this._writeTimeout + "ms for completion of " + ws);
        }
        if (this._closed && (this._writeTimeout > 300000 || this._writeTimeout <= 0)) {
            ws.waitForCompletion(300000);
        } else if (this._writeTimeout <= 0 || this._writeTimeout > 300000) {
            ws.waitForCompletion(300000);
        } else {
            ws.waitForCompletion(this._writeTimeout);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("after waiting " + this._writeTimeout + "ms for completion of " + ws);
        }
        if (ws.writeFailed() && this._writeTimeout > 0) {
            throw new InterruptedIOException("Timed out during write");
        }
        if (ws.writeFailed()) {
            throw new IOException("Write failed");
        }
        long elapsed = this._context.clock().now() - begin;
        if (elapsed > 10000L && this._log.shouldLog(10)) {
            this._log.debug("wtf, took " + elapsed + "ms to flush the stream?\n" + ws, (Throwable)new Exception("bar"));
        }
        this.throwAnyError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this._closed) {
            Object object = this._dataLock;
            synchronized (object) {
                this._dataLock.notifyAll();
            }
            return;
        }
        this._closed = true;
        this.flush();
        this._log.debug("Output stream closed after writing " + this._written);
        ByteArray ba = null;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._buf != null) {
                ba = new ByteArray(this._buf);
                this._buf = null;
                this._valid = 0;
                this.locked_updateBufferSize();
            }
            this._dataLock.notifyAll();
        }
        if (ba != null) {
            this._dataCache.release(ba);
        }
    }

    public void closeInternal() {
        this._closed = true;
        if (this._streamError == null) {
            this._streamError = new IOException("Closed internally");
        }
        this.clearData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearData(boolean shouldFlush) {
        ByteArray ba = null;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._dataReceiver != null && this._valid > 0 && shouldFlush) {
                this._dataReceiver.writeData(this._buf, 0, this._valid);
            }
            this._written += (long)this._valid;
            this._valid = 0;
            if (this._buf != null) {
                ba = new ByteArray(this._buf);
                this._buf = null;
                this._valid = 0;
            }
            this._lastFlushed = this._context.clock().now();
            this._dataLock.notifyAll();
        }
        if (ba != null) {
            this._dataCache.release(ba);
        }
    }

    public boolean getClosed() {
        return this._closed;
    }

    private void throwAnyError() throws IOException {
        if (this._streamError != null) {
            IOException ioe = this._streamError;
            this._streamError = null;
            throw ioe;
        }
    }

    void streamErrorOccurred(IOException ioe) {
        if (this._streamError == null) {
            this._streamError = ioe;
        }
        this.clearData(false);
    }

    void flushAvailable(DataReceiver target) throws IOException {
        this.flushAvailable(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAvailable(DataReceiver target, boolean blocking) throws IOException {
        long afterAccept;
        WriteStatus ws = null;
        long before = System.currentTimeMillis();
        Object object = this._dataLock;
        synchronized (object) {
            ws = target.writeData(this._buf, 0, this._valid);
            this._written += (long)this._valid;
            this._valid = 0;
            this.locked_updateBufferSize();
            this._dataLock.notifyAll();
            this._lastFlushed = this._context.clock().now();
        }
        long afterBuild = System.currentTimeMillis();
        if (afterBuild - before > 1000L && this._log.shouldLog(10)) {
            this._log.debug("Took " + (afterBuild - before) + "ms to build a packet?  " + ws);
        }
        if (blocking && ws != null) {
            ws.waitForAccept(this._writeTimeout);
            if (ws.writeFailed()) {
                throw new IOException("Flush available failed");
            }
            if (!ws.writeAccepted()) {
                throw new InterruptedIOException("Flush available timed out");
            }
        }
        if ((afterAccept = System.currentTimeMillis()) - afterBuild > 1000L && this._log.shouldLog(10)) {
            this._log.debug("Took " + (afterAccept - afterBuild) + "ms to accept a packet? " + ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        this._dataReceiver = null;
        Object object = this._dataLock;
        synchronized (object) {
            this._closed = true;
            this._dataLock.notifyAll();
        }
    }

    public static interface WriteStatus {
        public void waitForCompletion(int var1);

        public void waitForAccept(int var1);

        public boolean writeAccepted();

        public boolean writeFailed();

        public boolean writeSuccessful();
    }

    public static interface DataReceiver {
        public WriteStatus writeData(byte[] var1, int var2, int var3);

        public boolean writeInProcess();
    }

    private class Flusher
    implements SimpleTimer.TimedEvent {
        private boolean _enqueued;

        private Flusher() {
        }

        public void enqueue() {
            if (!this._enqueued) {
                RetransmissionTimer.getInstance().addEvent((SimpleTimer.TimedEvent)MessageOutputStream.this._flusher, (long)MessageOutputStream.this._passiveFlushDelay);
                if (MessageOutputStream.this._log.shouldLog(10)) {
                    MessageOutputStream.this._log.debug("Enqueueing the flusher for " + MessageOutputStream.this._passiveFlushDelay + "ms out");
                }
            } else if (MessageOutputStream.this._log.shouldLog(10)) {
                MessageOutputStream.this._log.debug("NOT enqueing the flusher");
            }
            this._enqueued = true;
        }

        public void timeReached() {
            this._enqueued = false;
            DataReceiver rec = MessageOutputStream.this._dataReceiver;
            long timeLeft = MessageOutputStream.this._lastBuffered + (long)MessageOutputStream.this._passiveFlushDelay - MessageOutputStream.this._context.clock().now();
            if (MessageOutputStream.this._log.shouldLog(10)) {
                MessageOutputStream.this._log.debug("flusher time reached: left = " + timeLeft);
            }
            if (timeLeft > 0L) {
                this.enqueue();
            } else if (rec != null && rec.writeInProcess()) {
                this.enqueue();
            } else {
                this.doFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFlush() {
            boolean sent = false;
            WriteStatus ws = null;
            Object object = MessageOutputStream.this._dataLock;
            synchronized (object) {
                long flushTime = MessageOutputStream.this._lastBuffered + (long)MessageOutputStream.this._passiveFlushDelay;
                if (MessageOutputStream.this._valid > 0 && flushTime <= MessageOutputStream.this._context.clock().now()) {
                    if (MessageOutputStream.this._log.shouldLog(10)) {
                        MessageOutputStream.this._log.debug("doFlush() valid = " + MessageOutputStream.this._valid);
                    }
                    if (MessageOutputStream.this._buf != null && MessageOutputStream.this._dataReceiver != null) {
                        ws = MessageOutputStream.this._dataReceiver.writeData(MessageOutputStream.this._buf, 0, MessageOutputStream.this._valid);
                        MessageOutputStream.this._written += MessageOutputStream.this._valid;
                        MessageOutputStream.this._valid = 0;
                        MessageOutputStream.this._lastFlushed = MessageOutputStream.this._context.clock().now();
                        MessageOutputStream.this.locked_updateBufferSize();
                        MessageOutputStream.this._dataLock.notifyAll();
                        sent = true;
                    }
                } else if (MessageOutputStream.this._log.shouldLog(10)) {
                    MessageOutputStream.this._log.debug("doFlush() rejected... valid = " + MessageOutputStream.this._valid);
                }
            }
            if (sent && MessageOutputStream.this._log.shouldLog(10)) {
                MessageOutputStream.this._log.debug("Passive flush of " + ws);
            }
        }
    }
}

