/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.SchedulerImpl;
import net.i2p.util.Log;

class SchedulerClosing
extends SchedulerImpl {
    private Log _log;

    public SchedulerClosing(I2PAppContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(SchedulerClosing.class);
    }

    public boolean accept(Connection con) {
        if (con == null) {
            return false;
        }
        long timeSinceClose = this._context.clock().now() - con.getCloseSentOn();
        boolean ok = !(con.getResetSent() || con.getResetReceived() || con.getCloseSentOn() <= 0L && con.getCloseReceivedOn() <= 0L || timeSinceClose >= 300000L || con.getUnackedPacketsReceived() <= 0 && con.getUnackedPacketsSent() <= 0);
        return ok;
    }

    public void eventOccurred(Connection con) {
        if (con.getNextSendTime() <= 0L) {
            con.setNextSendTime(this._context.clock().now() + (long)con.getOptions().getSendAckDelay());
        }
        long remaining = con.getNextSendTime() - this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug("Event occurred w/ remaining: " + remaining + " on " + con);
        }
        if (remaining <= 0L) {
            if (con.getCloseSentOn() <= 0L) {
                con.sendAvailable();
                con.setNextSendTime(this._context.clock().now() + (long)con.getOptions().getSendAckDelay());
            } else {
                con.ackImmediately();
            }
        } else {
            this.reschedule(remaining, con);
        }
    }
}

