/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import net.i2p.BOB.DoCMDS;
import net.i2p.BOB.NamedDB;
import net.i2p.client.streaming.RetransmissionTimer;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class BOB {
    private static final Log _log = new Log(BOB.class);
    public static final String PROP_CONFIG_LOCATION = "BOB.config";
    public static final String PROP_BOB_PORT = "BOB.port";
    public static final String PROP_BOB_HOST = "BOB.host";
    private static int maxConnections = 0;
    private static NamedDB database;

    public static void warn(String arg) {
        System.out.println(arg);
        _log.warn(arg);
    }

    public static void error(String arg) {
        System.out.println(arg);
        _log.error(arg);
    }

    public static void main(String[] args) {
        database = new NamedDB();
        int i = 0;
        boolean save = false;
        Properties props = new Properties();
        String configLocation = System.getProperty(PROP_CONFIG_LOCATION, "bob.config");
        SimpleTimer Y = RetransmissionTimer.getInstance();
        i = Y.hashCode();
        try {
            FileInputStream fi = new FileInputStream(configLocation);
            props.load(fi);
            fi.close();
        }
        catch (FileNotFoundException fnfe) {
            BOB.warn("Unable to load up the BOB config file " + configLocation + ", Using defaults.");
            BOB.warn(fnfe.toString());
            save = true;
        }
        catch (IOException ioe) {
            BOB.warn("IOException on BOB config file " + configLocation + ", using defaults.");
            BOB.warn(ioe.toString());
        }
        if (!props.containsKey("i2cp.tcp.host")) {
            props.setProperty("i2cp.tcp.host", "localhost");
        }
        if (!props.containsKey("i2cp.tcp.port")) {
            props.setProperty("i2cp.tcp.port", "7654");
        }
        if (!props.containsKey("i2cp.messageReliability")) {
            props.setProperty("i2cp.messageReliability", "BestEffort");
        }
        if (!props.containsKey(PROP_BOB_PORT)) {
            props.setProperty(PROP_BOB_PORT, "2827");
        }
        if (!props.containsKey("inbound.length")) {
            props.setProperty("inbound.length", "1");
        }
        if (!props.containsKey("outbound.length")) {
            props.setProperty("outbound.length", "1");
        }
        if (!props.containsKey("inbound.lengthVariance")) {
            props.setProperty("inbound.lengthVariance", "0");
        }
        if (!props.containsKey("outbound.lengthVariance")) {
            props.setProperty("outbound.lengthVariance", "0");
        }
        if (!props.containsKey(PROP_BOB_HOST)) {
            props.setProperty(PROP_BOB_HOST, "localhost");
        }
        if (save) {
            try {
                BOB.warn("Writing new defaults file " + configLocation);
                FileOutputStream fo = new FileOutputStream(configLocation);
                props.store(fo, configLocation);
                fo.close();
            }
            catch (IOException ioe) {
                BOB.warn("IOException on BOB config file " + configLocation + ", " + ioe);
            }
        }
        try {
            BOB.warn("BOB is now running.");
            ServerSocket listener = new ServerSocket(Integer.parseInt(props.getProperty(PROP_BOB_PORT)), 10, InetAddress.getByName(props.getProperty(PROP_BOB_HOST)));
            while (i++ < maxConnections || maxConnections == 0) {
                Socket server = listener.accept();
                DoCMDS conn_c = new DoCMDS(server, props, database, _log);
                Thread t = new Thread(conn_c);
                t.start();
            }
        }
        catch (IOException ioe) {
            BOB.warn("IOException on socket listen: " + ioe);
            ioe.printStackTrace();
        }
    }
}

