/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Properties;
import net.i2p.BOB.I2Plistener;
import net.i2p.BOB.NamedDB;
import net.i2p.BOB.TCPlistener;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.util.Log;

public class MUXlisten
implements Runnable {
    private NamedDB database;
    private NamedDB info;
    private Log _log;
    private I2PSocketManager socketManager;
    private ByteArrayInputStream prikey;
    private ThreadGroup tg;
    private String N;
    private ServerSocket listener;
    private int backlog = 50;
    boolean go_out;
    boolean come_in;

    MUXlisten(NamedDB database, NamedDB info, Log _log) throws I2PException, IOException, RuntimeException {
        int port = 0;
        InetAddress host = null;
        this.database = database;
        this.info = info;
        this._log = _log;
        this.database.getReadLock();
        this.info.getReadLock();
        this.N = this.info.get("NICKNAME").toString();
        this.prikey = new ByteArrayInputStream((byte[])info.get("KEYS"));
        Properties Q = (Properties)info.get("PROPERTIES");
        this.database.releaseReadLock();
        this.info.releaseReadLock();
        this.database.getReadLock();
        this.info.getReadLock();
        this.go_out = info.exists("OUTPORT");
        this.come_in = info.exists("INPORT");
        if (this.come_in) {
            port = Integer.parseInt(info.get("INPORT").toString());
            host = InetAddress.getByName(info.get("INHOST").toString());
        }
        this.database.releaseReadLock();
        this.info.releaseReadLock();
        this.socketManager = I2PSocketManagerFactory.createManager((InputStream)this.prikey, (Properties)Q);
        if (this.come_in) {
            this.listener = new ServerSocket(port, this.backlog, host);
        }
        this.database.getWriteLock();
        this.info.getWriteLock();
        this.info.add("STARTING", Boolean.TRUE);
        this.info.releaseWriteLock();
        this.database.releaseWriteLock();
    }

    private void rlock() throws Exception {
        this.database.getReadLock();
        this.info.getReadLock();
    }

    private void runlock() throws Exception {
        this.database.releaseReadLock();
        this.info.releaseReadLock();
    }

    private void wlock() throws Exception {
        this.database.getWriteLock();
        this.info.getWriteLock();
    }

    private void wunlock() throws Exception {
        this.info.releaseWriteLock();
        this.database.releaseWriteLock();
    }

    public void run() {
        try {
            this.wlock();
            try {
                this.info.add("RUNNING", Boolean.TRUE);
                this.info.add("STARTING", Boolean.FALSE);
            }
            catch (Exception e) {
                this.wunlock();
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            this.wunlock();
        }
        catch (Exception e) {
            return;
        }
        try {
            block34: {
                block35: {
                    Runnable conn;
                    this.tg = new ThreadGroup(this.N);
                    if (this.go_out) {
                        conn = new I2Plistener(this.socketManager, this.info, this.database, this._log);
                        Thread t = new Thread(this.tg, conn, "BOBI2Plistener " + this.N);
                        t.start();
                    }
                    if (this.come_in) {
                        conn = new TCPlistener(this.listener, this.socketManager, this.info, this.database, this._log);
                        Thread q = new Thread(this.tg, conn, "BOBTCPlistener" + this.N);
                        q.start();
                    }
                    boolean spin = true;
                    while (spin) {
                        block33: {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            try {
                                this.rlock();
                                try {
                                    spin = this.info.get("STOPPING").equals(Boolean.FALSE);
                                    break block33;
                                }
                                catch (Exception e) {
                                    this.runlock();
                                }
                            }
                            catch (Exception e) {}
                            break block34;
                        }
                        try {
                            this.runlock();
                        }
                        catch (Exception e) {
                            break block34;
                        }
                    }
                    try {
                        this.wlock();
                        try {
                            this.info.add("RUNNING", Boolean.FALSE);
                            break block35;
                        }
                        catch (Exception e) {
                            this.wunlock();
                        }
                    }
                    catch (Exception e) {}
                    break block34;
                }
                try {
                    this.wunlock();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            while (this.tg.activeCount() + this.tg.activeGroupCount() != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
            this.tg.destroy();
            this.tg = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.socketManager.destroySocketManager();
        try {
            this.wlock();
            try {
                this.info.add("STARTING", Boolean.FALSE);
                this.info.add("STOPPING", Boolean.FALSE);
                this.info.add("RUNNING", Boolean.FALSE);
            }
            catch (Exception e) {
                this.wunlock();
                return;
            }
            this.wunlock();
        }
        catch (Exception e) {
            return;
        }
    }
}

