/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import net.i2p.BOB.NamedDB;
import net.i2p.BOB.TCPio;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;

public class TCPtoI2P
implements Runnable {
    private I2PSocket I2P;
    private NamedDB info;
    private NamedDB database;
    private Socket sock;
    private I2PSocketManager socketManager;

    private static String lnRead(InputStream in) throws Exception {
        String S = new String();
        while (true) {
            int b;
            if ((b = in.read()) == 13) {
                continue;
            }
            if (b < 20 || b > 126) break;
            char c = (char)(b & 0x7F);
            S = new String(S + c);
        }
        return S;
    }

    TCPtoI2P(I2PSocketManager i2p, Socket socket, NamedDB info, NamedDB database) {
        this.sock = socket;
        this.info = info;
        this.database = database;
        this.socketManager = i2p;
    }

    private void Emsg(String e, OutputStream out) throws IOException {
        out.write("ERROR".concat(e).getBytes());
        out.write(13);
        out.flush();
    }

    public void run() {
        try {
            InputStream in = this.sock.getInputStream();
            OutputStream out = this.sock.getOutputStream();
            try {
                String line = TCPtoI2P.lnRead(in);
                String input = line.toLowerCase();
                Destination dest = null;
                if (input.endsWith(".i2p")) {
                    dest = I2PTunnel.destFromName((String)input);
                    line = dest.toBase64();
                }
                dest = new Destination();
                dest.fromBase64(line);
                try {
                    this.I2P = this.socketManager.connect(dest);
                    this.I2P.setReadTimeout(0L);
                    InputStream Iin = this.I2P.getInputStream();
                    OutputStream Iout = this.I2P.getOutputStream();
                    TCPio conn_c = new TCPio(in, Iout, this.info, this.database);
                    TCPio conn_a = new TCPio(Iin, out, this.info, this.database);
                    Thread t = new Thread((Runnable)conn_c, "TCPioA");
                    Thread q = new Thread((Runnable)conn_a, "TCPioB");
                    t.start();
                    q.start();
                    while (t.isAlive() && q.isAlive()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                catch (I2PException e) {
                    this.Emsg("ERROR " + e.toString(), out);
                }
                catch (ConnectException e) {
                    this.Emsg("ERROR " + e.toString(), out);
                }
                catch (NoRouteToHostException e) {
                    this.Emsg("ERROR " + e.toString(), out);
                }
                catch (InterruptedIOException e) {
                    this.Emsg("ERROR " + e.toString(), out);
                }
            }
            catch (Exception e) {
                this.Emsg("ERROR " + e.toString(), out);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.I2P.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

