/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class I2PTunnelClient
extends I2PTunnelClientBase {
    private static final Log _log = new Log(I2PTunnelClient.class);
    protected List dests;
    private static final long DEFAULT_READ_TIMEOUT = 300000L;
    protected long readTimeout = 300000L;

    public I2PTunnelClient(int localPort, String destinations, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "SynSender", tunnel);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openClientResult", "error");
            return;
        }
        StringTokenizer tok = new StringTokenizer(destinations, ",");
        this.dests = new ArrayList(1);
        while (tok.hasMoreTokens()) {
            String destination = tok.nextToken();
            try {
                Destination dest = I2PTunnel.destFromName(destination);
                if (dest == null) {
                    l.log("Could not resolve " + destination);
                    continue;
                }
                this.dests.add(dest);
            }
            catch (DataFormatException dfe) {
                l.log("Bad format parsing \"" + destination + "\"");
            }
        }
        if (this.dests.size() <= 0) {
            l.log("No target destinations found");
            this.notifyEvent("openClientResult", "error");
            return;
        }
        this.setName(this.getLocalPort() + " -> " + destinations);
        this.startRunning();
        this.notifyEvent("openClientResult", "ok");
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientConnectionRun(Socket s) {
        block5: {
            Destination dest = this.pickDestination();
            I2PSocket i2ps = null;
            try {
                i2ps = this.createI2PSocket(dest);
                i2ps.setReadTimeout(this.readTimeout);
                new I2PTunnelRunner(s, i2ps, this.sockLock, null, this.mySockets);
            }
            catch (Exception ex) {
                _log.info("Error connecting", ex);
                this.l.log(ex.getMessage());
                I2PTunnelClient.closeSocket(s);
                if (i2ps == null) break block5;
                Object object = this.sockLock;
                synchronized (object) {
                    this.mySockets.remove(this.sockLock);
                }
            }
        }
    }

    private final Destination pickDestination() {
        int size = this.dests.size();
        if (size <= 0) {
            if (_log.shouldLog(40)) {
                _log.error("No client targets?!");
            }
            return null;
        }
        if (size == 1) {
            return (Destination)this.dests.get(0);
        }
        int index = I2PAppContext.getGlobalContext().random().nextInt(size);
        return (Destination)this.dests.get(index);
    }
}

