/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public abstract class I2PTunnelClientBase
extends I2PTunnelTask
implements Runnable {
    private static final Log _log = new Log(I2PTunnelClientBase.class);
    protected I2PAppContext _context;
    protected Logging l;
    static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    private static volatile long __clientId = 0L;
    protected long _clientId;
    protected Object sockLock = new Object();
    protected I2PSocketManager sockMgr;
    protected List mySockets = new ArrayList();
    protected Destination dest = null;
    private int localPort;
    private boolean listenerReady = false;
    private ServerSocket ss;
    private Object startLock = new Object();
    private boolean startRunning = false;
    private Object closeLock = new Object();
    private byte[] pubkey;
    private String handlerName;
    private Object conLock = new Object();
    private List _waitingSockets = new ArrayList();
    private int _numConnectionBuilders;
    private int _maxWaitTime;
    public static final String PROP_NUM_CONNECTION_BUILDERS = "i2ptunnel.numConnectionBuilders";
    public static final String PROP_MAX_WAIT_TIME = "i2ptunnel.maxWaitTime";
    private static final int DEFAULT_NUM_CONNECTION_BUILDERS = 5;
    private static final int DEFAULT_MAX_WAIT_TIME = 30000;
    private static I2PSocketManager socketManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort + " (uninitialized)", notifyThis, tunnel);
        this._clientId = ++__clientId;
        this.localPort = localPort;
        this.l = l;
        this.handlerName = handlerName + this._clientId;
        this._context = tunnel.getContext();
        this._context.statManager().createRateStat("i2ptunnel.client.closeBacklog", "How many pending sockets remain when we close one due to backlog?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.closeNoBacklog", "How many pending sockets remain when it was removed prior to backlog timeout?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.manageTime", "How long it takes to accept a socket and fire it into an i2ptunnel runner (or queue it for the pool)?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.buildRunTime", "How long it takes to run a queued socket into an i2ptunnel runner?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        tunnel.getClientOptions().setProperty("i2cp.dontPublishLeaseSet", "true");
        while (this.sockMgr == null) {
            Object object = this.sockLock;
            synchronized (object) {
                this.sockMgr = ownDest ? this.buildSocketManager() : this.getSocketManager();
            }
            if (this.sockMgr != null) continue;
            _log.log(50, "Unable to create socket manager (our own? " + ownDest + ")");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {}
        }
        if (this.sockMgr == null) {
            l.log("Invalid I2CP configuration");
            throw new IllegalArgumentException("Socket manager could not be created");
        }
        l.log("I2P session created");
        this.getTunnel().addSession(this.sockMgr.getSession());
        I2PThread t = new I2PThread(this);
        t.setName("Client " + this._clientId);
        this.listenerReady = false;
        t.start();
        this.open = true;
        I2PTunnelClientBase i2PTunnelClientBase = this;
        synchronized (i2PTunnelClientBase) {
            while (!this.listenerReady && this.open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        this.configurePool(tunnel);
        if (this.open && this.listenerReady) {
            l.log("Ready! Port " + this.getLocalPort());
            this.notifyEvent("openBaseClientResult", "ok");
        } else {
            l.log("Error listening - please see the logs!");
            this.notifyEvent("openBaseClientResult", "error");
        }
    }

    private void configurePool(I2PTunnel tunnel) {
        this._waitingSockets = new ArrayList(4);
        Properties opts = tunnel.getClientOptions();
        String maxWait = opts.getProperty(PROP_MAX_WAIT_TIME, "30000");
        try {
            this._maxWaitTime = Integer.parseInt(maxWait);
        }
        catch (NumberFormatException nfe) {
            this._maxWaitTime = 30000;
        }
        String numBuild = opts.getProperty(PROP_NUM_CONNECTION_BUILDERS, "5");
        try {
            this._numConnectionBuilders = Integer.parseInt(numBuild);
        }
        catch (NumberFormatException nfe) {
            this._numConnectionBuilders = 5;
        }
        for (int i = 0; i < this._numConnectionBuilders; ++i) {
            String name = "ClientBuilder" + this._clientId + '.' + i;
            I2PThread b = new I2PThread(new TunnelConnectionBuilder(), name);
            b.setDaemon(true);
            b.start();
        }
    }

    protected synchronized I2PSocketManager getSocketManager() {
        return I2PTunnelClientBase.getSocketManager(this.getTunnel());
    }

    protected static synchronized I2PSocketManager getSocketManager(I2PTunnel tunnel) {
        if (socketManager != null) {
            I2PSession s = socketManager.getSession();
            if (s == null || s.isClosed()) {
                _log.info("Building a new socket manager since the old one closed [s=" + s + "]");
                socketManager = I2PTunnelClientBase.buildSocketManager(tunnel);
            } else {
                _log.info("Not building a new socket manager since the old one is open [s=" + s + "]");
            }
        } else {
            _log.info("Building a new socket manager since there is no other one");
            socketManager = I2PTunnelClientBase.buildSocketManager(tunnel);
        }
        return socketManager;
    }

    protected I2PSocketManager buildSocketManager() {
        return I2PTunnelClientBase.buildSocketManager(this.getTunnel());
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)tunnel.getClientOptions());
        int portNum = 7654;
        if (tunnel.port != null) {
            try {
                portNum = Integer.parseInt(tunnel.port);
            }
            catch (NumberFormatException nfe) {
                _log.log(50, "Invalid port specified [" + tunnel.port + "], reverting to " + portNum);
            }
        }
        I2PSocketManager sockManager = null;
        while (sockManager == null) {
            sockManager = I2PSocketManagerFactory.createManager(tunnel.host, portNum, props);
            if (sockManager != null) continue;
            _log.log(50, "Unable to create socket manager");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {}
        }
        sockManager.setName("Client");
        return sockManager;
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    protected final InetAddress getListenHost(Logging l) {
        try {
            return InetAddress.getByName(this.getTunnel().listenHost);
        }
        catch (UnknownHostException uhe) {
            l.log("Could not find listen host to bind to [" + this.getTunnel().host + "]");
            _log.error("Error finding host to bind", uhe);
            this.notifyEvent("openBaseClientResult", "error");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRunning() {
        Object object = this.startLock;
        synchronized (object) {
            this.startRunning = true;
            this.startLock.notify();
        }
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    public I2PSocket createI2PSocket(Destination dest) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        return this.createI2PSocket(dest, this.getDefaultOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSocket createI2PSocket(Destination dest, I2PSocketOptions opt) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        I2PSocket i2ps = this.sockMgr.connect(dest, opt);
        Object object = this.sockLock;
        synchronized (object) {
            this.mySockets.add(i2ps);
        }
        return i2ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            InetAddress addr = this.getListenHost(this.l);
            if (addr == null) {
                this.open = false;
                Object object = this;
                synchronized (object) {
                    this.notifyAll();
                }
                object = this._waitingSockets;
                synchronized (object) {
                    this._waitingSockets.notifyAll();
                }
                return;
            }
            this.ss = new ServerSocket(this.localPort, 0, addr);
            if (this.localPort == 0) {
                this.localPort = this.ss.getLocalPort();
            }
            this.notifyEvent("clientLocalPort", new Integer(this.ss.getLocalPort()));
            this.l.log("Listening for clients on port " + this.localPort + " of " + this.getTunnel().listenHost);
            Object object = this;
            synchronized (object) {
                this.listenerReady = true;
                this.notify();
            }
            object = this.startLock;
            synchronized (object) {
                while (!this.startRunning) {
                    try {
                        this.startLock.wait();
                    }
                    catch (InterruptedException ie) {}
                }
            }
            while (true) {
                Socket s = this.ss.accept();
                long before = System.currentTimeMillis();
                this.manageConnection(s);
                long total = System.currentTimeMillis() - before;
                this._context.statManager().addRateData("i2ptunnel.client.manageTime", total, total);
            }
        }
        catch (IOException ex) {
            _log.error("Error listening for connections on " + this.localPort, ex);
            this.notifyEvent("openBaseClientResult", "error");
            Object object = this.sockLock;
            synchronized (object) {
                this.mySockets.clear();
            }
            this.open = false;
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            List list = this._waitingSockets;
            synchronized (list) {
                this._waitingSockets.notifyAll();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageConnection(Socket s) {
        if (s == null) {
            return;
        }
        if (this._numConnectionBuilders <= 0) {
            new I2PThread(new BlockingRunner(s), "Clinet run").start();
            return;
        }
        if (this._maxWaitTime > 0) {
            SimpleTimer.getInstance().addEvent(new CloseEvent(s), this._maxWaitTime);
        }
        List list = this._waitingSockets;
        synchronized (list) {
            this._waitingSockets.add(s);
            this._waitingSockets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        Object object = this.sockLock;
        synchronized (object) {
            this.mySockets.retainAll(this.sockMgr.listSockets());
            if (!forced && this.mySockets.size() != 0) {
                this.l.log("There are still active connections!");
                _log.debug("can't close: there are still active connections!");
                Iterator it = this.mySockets.iterator();
                while (it.hasNext()) {
                    this.l.log("->" + it.next());
                }
                return false;
            }
            I2PSession session = this.sockMgr.getSession();
            if (session != null) {
                this.getTunnel().removeSession(session);
            }
            this.l.log("Closing client " + this.toString());
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            this.l.log("Client closed.");
            this.open = false;
        }
        object = this._waitingSockets;
        synchronized (object) {
            this._waitingSockets.notifyAll();
        }
        return true;
    }

    public static void closeSocket(Socket s) {
        try {
            s.close();
        }
        catch (IOException ex) {
            _log.error("Could not close socket", ex);
        }
    }

    protected abstract void clientConnectionRun(Socket var1);

    private class TunnelConnectionBuilder
    implements Runnable {
        private TunnelConnectionBuilder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket s = null;
            while (I2PTunnelClientBase.this.open) {
                try {
                    List list = I2PTunnelClientBase.this._waitingSockets;
                    synchronized (list) {
                        if (I2PTunnelClientBase.this._waitingSockets.size() <= 0) {
                            I2PTunnelClientBase.this._waitingSockets.wait();
                        } else {
                            s = (Socket)I2PTunnelClientBase.this._waitingSockets.remove(0);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (s != null) {
                    long before = System.currentTimeMillis();
                    I2PTunnelClientBase.this.clientConnectionRun(s);
                    long total = System.currentTimeMillis() - before;
                    I2PTunnelClientBase.this._context.statManager().addRateData("i2ptunnel.client.buildRunTime", total, 0L);
                }
                s = null;
            }
        }
    }

    private class CloseEvent
    implements SimpleTimer.TimedEvent {
        private Socket _s;

        public CloseEvent(Socket s) {
            this._s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            int remaining = 0;
            boolean stillWaiting = false;
            List list = I2PTunnelClientBase.this._waitingSockets;
            synchronized (list) {
                stillWaiting = I2PTunnelClientBase.this._waitingSockets.remove(this._s);
                remaining = I2PTunnelClientBase.this._waitingSockets.size();
            }
            if (stillWaiting) {
                try {
                    this._s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (_log.shouldLog(20)) {
                    I2PTunnelClientBase.this._context.statManager().addRateData("i2ptunnel.client.closeBacklog", remaining, 0L);
                    _log.info("Closed a waiting socket because of backlog");
                }
            } else {
                I2PTunnelClientBase.this._context.statManager().addRateData("i2ptunnel.client.closeNoBacklog", remaining, 0L);
            }
        }
    }

    private class BlockingRunner
    implements Runnable {
        private Socket _s;

        public BlockingRunner(Socket s) {
            this._s = s;
        }

        public void run() {
            I2PTunnelClientBase.this.clientConnectionRun(this._s);
        }
    }
}

