/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.HTTPResponseOutputStream;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class I2PTunnelHTTPServer
extends I2PTunnelServer {
    private static final Log _log = new Log(I2PTunnelHTTPServer.class);
    private String _spoofHost;
    private static final String HASH_HEADER = "X-I2P-DestHash";

    public I2PTunnelHTTPServer(InetAddress host, int port, String privData, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, l, notifyThis, tunnel);
        this._spoofHost = spoofHost;
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpserver.blockingHandleTime", "how long the blocking handle takes to complete", "I2PTunnel", new long[]{60000L, 600000L, 10800000L});
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpNullWorkaround", "How often an http server works around a streaming lib or i2ptunnel bug", "I2PTunnel", new long[]{60000L, 600000L});
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, File privkey, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privkey, privkeyname, l, notifyThis, tunnel);
        this._spoofHost = spoofHost;
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpserver.blockingHandleTime", "how long the blocking handle takes to complete", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L, 10800000L});
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpNullWorkaround", "How often an http server works around a streaming lib or i2ptunnel bug", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L});
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, InputStream privData, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, privkeyname, l, notifyThis, tunnel);
        this._spoofHost = spoofHost;
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpserver.blockingHandleTime", "how long the blocking handle takes to complete", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L, 10800000L});
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpNullWorkaround", "How often an http server works around a streaming lib or i2ptunnel bug", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L});
    }

    protected void blockingHandle(I2PSocket socket) {
        long afterSocket;
        long afterAccept;
        block14: {
            afterAccept = this.getTunnel().getContext().clock().now();
            afterSocket = -1L;
            try {
                boolean useGZIP;
                String val;
                socket.setReadTimeout(5000L);
                InputStream in = socket.getInputStream();
                StringBuffer command = new StringBuffer(128);
                Properties headers = this.readHeaders(in, command);
                headers.setProperty(HASH_HEADER, socket.getPeerDestination().calculateHash().toBase64());
                if (this._spoofHost != null && this._spoofHost.trim().length() > 0) {
                    headers.setProperty("Host", this._spoofHost);
                }
                headers.setProperty("Connection", "close");
                String enc = headers.getProperty("Accept-encoding");
                String altEnc = headers.getProperty("X-Accept-encoding");
                headers.setProperty("Accept-encoding", "");
                String modifiedHeader = this.formatHeaders(headers, command);
                if (_log.shouldLog(10)) {
                    _log.debug("Modified header: [" + modifiedHeader + "]");
                }
                socket.setReadTimeout(this.readTimeout);
                Socket s = new Socket(this.remoteHost, this.remotePort);
                afterSocket = this.getTunnel().getContext().clock().now();
                Properties opts = this.getTunnel().getClientOptions();
                boolean allowGZIP = true;
                if (opts != null && (val = opts.getProperty("i2ptunnel.gzip")) != null && !Boolean.valueOf(val).booleanValue()) {
                    allowGZIP = false;
                }
                if (_log.shouldLog(20)) {
                    _log.info("HTTP server encoding header: " + enc + "/" + altEnc);
                }
                boolean bl = useGZIP = enc != null && enc.indexOf("x-i2p-gzip") >= 0;
                if (!useGZIP && altEnc != null && altEnc.indexOf("x-i2p-gzip") >= 0) {
                    useGZIP = true;
                }
                if (allowGZIP && useGZIP) {
                    I2PThread req = new I2PThread(new CompressedRequestor(s, socket, modifiedHeader), Thread.currentThread().getName() + ".hc");
                    req.start();
                } else {
                    new I2PTunnelRunner(s, socket, this.slock, null, modifiedHeader.getBytes(), null);
                }
            }
            catch (SocketException ex) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    if (_log.shouldLog(40)) {
                        _log.error("Error while closing the received i2p con", ex);
                    }
                }
            }
            catch (IOException ex) {
                if (!_log.shouldLog(30)) break block14;
                _log.warn("Error while receiving the new HTTP request", ex);
            }
        }
        long afterHandle = this.getTunnel().getContext().clock().now();
        long timeToHandle = afterHandle - afterAccept;
        this.getTunnel().getContext().statManager().addRateData("i2ptunnel.httpserver.blockingHandleTime", timeToHandle, 0L);
        if (timeToHandle > 1000L && _log.shouldLog(30)) {
            _log.warn("Took a while to handle the request [" + timeToHandle + ", socket create: " + (afterSocket - afterAccept) + "]");
        }
    }

    private String formatHeaders(Properties headers, StringBuffer command) {
        StringBuffer buf = new StringBuffer(command.length() + headers.size() * 64);
        buf.append(command.toString().trim()).append("\r\n");
        for (String string : headers.keySet()) {
            String val = headers.getProperty(string);
            buf.append(string.trim()).append(": ").append(val.trim()).append("\r\n");
        }
        buf.append("\r\n");
        return buf.toString();
    }

    private Properties readHeaders(InputStream in, StringBuffer command) throws IOException {
        Properties headers = new Properties();
        StringBuffer buf = new StringBuffer(128);
        boolean ok = DataHelper.readLine(in, command);
        if (!ok) {
            throw new IOException("EOF reached while reading the HTTP command [" + command.toString() + "]");
        }
        if (_log.shouldLog(10)) {
            _log.debug("Read the http command [" + command.toString() + "]");
        }
        int trimmed = 0;
        if (command.length() > 0) {
            for (int i = 0; i < command.length(); ++i) {
                if (command.charAt(i) != '\u0000') continue;
                command = command.deleteCharAt(i);
                --i;
                ++trimmed;
            }
        }
        if (trimmed > 0) {
            this.getTunnel().getContext().statManager().addRateData("i2ptunnel.httpNullWorkaround", trimmed, 0L);
        }
        while (true) {
            buf.setLength(0);
            ok = DataHelper.readLine(in, buf);
            if (!ok) {
                throw new IOException("EOF reached before the end of the headers [" + buf.toString() + "]");
            }
            if (buf.length() == 0 || buf.charAt(0) == '\n' || buf.charAt(0) == '\r') {
                return headers;
            }
            int split = buf.indexOf(":");
            if (split <= 0) {
                throw new IOException("Invalid HTTP header, missing colon [" + buf.toString() + "]");
            }
            String name = buf.substring(0, split).trim();
            String value = null;
            value = buf.length() > split + 1 ? buf.substring(split + 1).trim() : "";
            if ("Accept-encoding".equalsIgnoreCase(name)) {
                name = "Accept-encoding";
            } else if ("X-Accept-encoding".equalsIgnoreCase(name)) {
                name = "X-Accept-encoding";
            } else if (HASH_HEADER.equalsIgnoreCase(name)) continue;
            headers.setProperty(name, value);
            if (!_log.shouldLog(10)) continue;
            _log.debug("Read the header [" + name + "] = [" + value + "]");
        }
    }

    private class InternalGZIPOutputStream
    extends GZIPOutputStream {
        public InternalGZIPOutputStream(OutputStream target) throws IOException {
            super(target);
        }

        public long getTotalRead() {
            try {
                return this.def.getTotalIn();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getTotalCompressed() {
            try {
                return this.def.getTotalOut();
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    private class CompressedResponseOutputStream
    extends HTTPResponseOutputStream {
        private InternalGZIPOutputStream _gzipOut;

        public CompressedResponseOutputStream(OutputStream o) {
            super(o);
        }

        protected boolean shouldCompress() {
            return true;
        }

        protected void finishHeaders() throws IOException {
            if (_log.shouldLog(20)) {
                _log.info("Including x-i2p-gzip as the content encoding in the response");
            }
            this.out.write("Content-encoding: x-i2p-gzip\r\n".getBytes());
            super.finishHeaders();
        }

        protected void beginProcessing() throws IOException {
            if (_log.shouldLog(20)) {
                _log.info("Beginning compression processing");
            }
            this._gzipOut = new InternalGZIPOutputStream(this.out);
            this.out = this._gzipOut;
        }

        public long getTotalRead() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalRead();
            }
            return 0L;
        }

        public long getTotalCompressed() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalCompressed();
            }
            return 0L;
        }
    }

    private class Sender
    implements Runnable {
        private OutputStream _out;
        private InputStream _in;
        private String _name;

        public Sender(OutputStream out, InputStream in, String name) {
            this._out = out;
            this._in = in;
            this._name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block24: {
                IOException ioe222;
                block22: {
                    block21: {
                        if (_log.shouldLog(20)) {
                            _log.info(this._name + ": Begin sending");
                        }
                        byte[] buf = new byte[16384];
                        int read = 0;
                        int total = 0;
                        while ((read = this._in.read(buf)) != -1) {
                            if (_log.shouldLog(20)) {
                                _log.info(this._name + ": read " + read + " and sending through the stream");
                            }
                            this._out.write(buf, 0, read);
                            total += read;
                        }
                        if (!_log.shouldLog(20)) break block21;
                        _log.info(this._name + ": Done sending: " + total);
                    }
                    Object var5_5 = null;
                    if (this._out == null) break block22;
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (this._in != null) {
                    try {
                        this._in.close();
                    }
                    catch (IOException ioe222) {}
                }
                break block24;
                {
                    catch (IOException ioe3) {
                        IOException ioe222;
                        if (_log.shouldLog(10)) {
                            _log.debug("Error sending", ioe3);
                        }
                        Object var5_6 = null;
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        if (this._in != null) {
                            try {
                                this._in.close();
                            }
                            catch (IOException ioe222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222;
                    Object var5_7 = null;
                    if (this._out != null) {
                        try {
                            this._out.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (this._in != null) {
                        try {
                            this._in.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private class CompressedRequestor
    implements Runnable {
        private Socket _webserver;
        private I2PSocket _browser;
        private String _headers;

        public CompressedRequestor(Socket webserver, I2PSocket browser, String headers) {
            this._webserver = webserver;
            this._browser = browser;
            this._headers = headers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block42: {
                IOException ioe222222;
                InputStream serverin;
                InputStream browserin;
                OutputStream browserout;
                OutputStream serverout;
                block36: {
                    block35: {
                        if (_log.shouldLog(20)) {
                            _log.info("Compressed requestor running");
                        }
                        serverout = null;
                        browserout = null;
                        browserin = null;
                        serverin = null;
                        serverout = this._webserver.getOutputStream();
                        if (_log.shouldLog(20)) {
                            _log.info("request headers: " + this._headers);
                        }
                        serverout.write(this._headers.getBytes());
                        browserin = this._browser.getInputStream();
                        I2PThread sender = new I2PThread(new Sender(serverout, browserin, "server: browser to server"), Thread.currentThread().getName() + "hcs");
                        sender.start();
                        browserout = this._browser.getOutputStream();
                        serverin = this._webserver.getInputStream();
                        CompressedResponseOutputStream compressedOut = new CompressedResponseOutputStream(browserout);
                        Sender s = new Sender(compressedOut, serverin, "server: server to browser");
                        if (_log.shouldLog(20)) {
                            _log.info("Before pumping the compressed response");
                        }
                        s.run();
                        if (!_log.shouldLog(20)) break block35;
                        _log.info("After pumping the compressed response: " + compressedOut.getTotalRead() + "/" + compressedOut.getTotalCompressed());
                    }
                    Object var9_9 = null;
                    if (browserout == null) break block36;
                    try {
                        browserout.close();
                    }
                    catch (IOException ioe222222) {
                        // empty catch block
                    }
                }
                if (serverout != null) {
                    try {
                        serverout.close();
                    }
                    catch (IOException ioe222222) {
                        // empty catch block
                    }
                }
                if (browserin != null) {
                    try {
                        browserin.close();
                    }
                    catch (IOException ioe222222) {
                        // empty catch block
                    }
                }
                if (serverin != null) {
                    try {
                        serverin.close();
                    }
                    catch (IOException ioe222222) {}
                }
                break block42;
                {
                    catch (IOException ioe3) {
                        IOException ioe222222;
                        if (_log.shouldLog(30)) {
                            _log.warn("error compressing", ioe3);
                        }
                        Object var9_10 = null;
                        if (browserout != null) {
                            try {
                                browserout.close();
                            }
                            catch (IOException ioe222222) {
                                // empty catch block
                            }
                        }
                        if (serverout != null) {
                            try {
                                serverout.close();
                            }
                            catch (IOException ioe222222) {
                                // empty catch block
                            }
                        }
                        if (browserin != null) {
                            try {
                                browserin.close();
                            }
                            catch (IOException ioe222222) {
                                // empty catch block
                            }
                        }
                        if (serverin != null) {
                            try {
                                serverin.close();
                            }
                            catch (IOException ioe222222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222222;
                    Object var9_11 = null;
                    if (browserout != null) {
                        try {
                            browserout.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    if (serverout != null) {
                        try {
                            serverout.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    if (browserin != null) {
                        try {
                            browserin.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    if (serverin != null) {
                        try {
                            serverin.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

