/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.List;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class I2PTunnelRunner
extends I2PThread
implements I2PSocket.SocketErrorListener {
    private static final Log _log = new Log(I2PTunnelRunner.class);
    private static volatile long __runnerId;
    private long _runnerId;
    static int MAX_PACKET_SIZE;
    static final int NETWORK_BUFFER_SIZE;
    private Socket s;
    private I2PSocket i2ps;
    Object slock;
    Object finishLock = new Object();
    boolean finished = false;
    HashMap ostreams;
    HashMap sockets;
    byte[] initialI2PData;
    byte[] initialSocketData;
    private long lastActivityOn;
    private long startedOn;
    private List sockList;
    private Runnable onTimeout;
    private long totalSent;
    private long totalReceived;
    private volatile long __forwarderId;

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List sockList) {
        this(s, i2ps, slock, initialI2PData, null, sockList, null);
    }

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List sockList) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null);
    }

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List sockList, Runnable onTimeout) {
        this(s, i2ps, slock, initialI2PData, null, sockList, onTimeout);
    }

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List sockList, Runnable onTimeout) {
        this.sockList = sockList;
        this.s = s;
        this.i2ps = i2ps;
        this.slock = slock;
        this.initialI2PData = initialI2PData;
        this.initialSocketData = initialSocketData;
        this.onTimeout = onTimeout;
        this.lastActivityOn = -1L;
        this.startedOn = Clock.getInstance().now();
        if (_log.shouldLog(20)) {
            _log.info("I2PTunnelRunner started");
        }
        this._runnerId = ++__runnerId;
        this.__forwarderId = i2ps.hashCode();
        this.setName("I2PTunnelRunner " + this._runnerId);
        this.start();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getLastActivityOn() {
        return this.lastActivityOn;
    }

    private void updateActivity() {
        this.lastActivityOn = Clock.getInstance().now();
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    protected InputStream getSocketIn() throws IOException {
        return this.s.getInputStream();
    }

    protected OutputStream getSocketOut() throws IOException {
        return this.s.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block43: {
            block42: {
                IOException ex22222;
                block41: {
                    InputStream in = this.getSocketIn();
                    OutputStream out = this.getSocketOut();
                    this.i2ps.setSocketErrorListener(this);
                    InputStream i2pin = this.i2ps.getInputStream();
                    OutputStream i2pout = this.i2ps.getOutputStream();
                    if (this.initialI2PData != null) {
                        Object object = this.slock;
                        synchronized (object) {
                            i2pout.write(this.initialI2PData);
                        }
                    }
                    if (this.initialSocketData != null) {
                        out.write(this.initialSocketData);
                    }
                    if (_log.shouldLog(10)) {
                        _log.debug("Initial data " + (this.initialI2PData != null ? this.initialI2PData.length : 0) + " written to I2P, " + (this.initialSocketData != null ? this.initialSocketData.length : 0) + " written to the socket, starting forwarders");
                    }
                    StreamForwarder t1 = new StreamForwarder(in, i2pout, true);
                    StreamForwarder t2 = new StreamForwarder(i2pin, out, false);
                    Object object = this.finishLock;
                    synchronized (object) {
                        while (!this.finished) {
                            this.finishLock.wait();
                        }
                    }
                    if (_log.shouldLog(10)) {
                        _log.debug("At least one forwarder completed, closing and joining");
                    }
                    if (this.onTimeout != null) {
                        if (_log.shouldLog(10)) {
                            _log.debug("runner has a timeout job, totalReceived = " + this.totalReceived + " totalSent = " + this.totalSent + " job = " + this.onTimeout);
                        }
                        if (this.totalSent <= 0L && this.totalReceived <= 0L) {
                            this.onTimeout.run();
                        }
                    }
                    this.close(out, in, i2pout, i2pin, this.s, this.i2ps, t1, t2);
                    Object var10_13 = null;
                    this.removeRef();
                    try {
                        if (this.s != null) {
                            this.s.close();
                        }
                    }
                    catch (IOException ex22222) {
                        if (!_log.shouldLog(40)) break block41;
                        _log.error("Could not close java socket", ex22222);
                    }
                }
                if (this.i2ps == null) break block43;
                try {
                    this.i2ps.close();
                }
                catch (IOException ex22222) {
                    if (!_log.shouldLog(40)) break block42;
                    _log.error("Could not close I2PSocket", ex22222);
                }
            }
            this.i2ps.setSocketErrorListener(null);
            {
                break block43;
                catch (InterruptedException ex) {
                    block45: {
                        IOException ex22222;
                        block44: {
                            if (_log.shouldLog(40)) {
                                _log.error("Interrupted", ex);
                            }
                            Object var10_14 = null;
                            this.removeRef();
                            try {
                                if (this.s != null) {
                                    this.s.close();
                                }
                            }
                            catch (IOException ex22222) {
                                if (!_log.shouldLog(40)) break block44;
                                _log.error("Could not close java socket", ex22222);
                            }
                        }
                        if (this.i2ps == null) break block43;
                        try {
                            this.i2ps.close();
                        }
                        catch (IOException ex22222) {
                            if (!_log.shouldLog(40)) break block45;
                            _log.error("Could not close I2PSocket", ex22222);
                        }
                    }
                    this.i2ps.setSocketErrorListener(null);
                    break block43;
                }
                catch (IOException ex) {
                    block47: {
                        IOException ex22222;
                        block46: {
                            if (_log.shouldLog(10)) {
                                _log.debug("Error forwarding", ex);
                            }
                            Object var10_15 = null;
                            this.removeRef();
                            try {
                                if (this.s != null) {
                                    this.s.close();
                                }
                            }
                            catch (IOException ex22222) {
                                if (!_log.shouldLog(40)) break block46;
                                _log.error("Could not close java socket", ex22222);
                            }
                        }
                        if (this.i2ps == null) break block43;
                        try {
                            this.i2ps.close();
                        }
                        catch (IOException ex22222) {
                            if (!_log.shouldLog(40)) break block47;
                            _log.error("Could not close I2PSocket", ex22222);
                        }
                    }
                    this.i2ps.setSocketErrorListener(null);
                    break block43;
                }
                catch (Exception e) {
                    block49: {
                        IOException ex22222;
                        block48: {
                            if (_log.shouldLog(40)) {
                                _log.error("Internal error", e);
                            }
                            Object var10_16 = null;
                            this.removeRef();
                            try {
                                if (this.s != null) {
                                    this.s.close();
                                }
                            }
                            catch (IOException ex22222) {
                                if (!_log.shouldLog(40)) break block48;
                                _log.error("Could not close java socket", ex22222);
                            }
                        }
                        if (this.i2ps == null) break block43;
                        try {
                            this.i2ps.close();
                        }
                        catch (IOException ex22222) {
                            if (!_log.shouldLog(40)) break block49;
                            _log.error("Could not close I2PSocket", ex22222);
                        }
                    }
                    this.i2ps.setSocketErrorListener(null);
                }
            }
            catch (Throwable throwable) {
                IOException ex22222;
                block50: {
                    Object var10_17 = null;
                    this.removeRef();
                    try {
                        if (this.s != null) {
                            this.s.close();
                        }
                    }
                    catch (IOException ex22222) {
                        if (!_log.shouldLog(40)) break block50;
                        _log.error("Could not close java socket", ex22222);
                    }
                }
                if (this.i2ps != null) {
                    block51: {
                        try {
                            this.i2ps.close();
                        }
                        catch (IOException ex22222) {
                            if (!_log.shouldLog(40)) break block51;
                            _log.error("Could not close I2PSocket", ex22222);
                        }
                    }
                    this.i2ps.setSocketErrorListener(null);
                }
                throw throwable;
            }
        }
    }

    protected void close(OutputStream out, InputStream in, OutputStream i2pout, InputStream i2pin, Socket s, I2PSocket i2ps, Thread t1, Thread t2) throws InterruptedException, IOException {
        try {
            out.flush();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            i2pout.flush();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        in.close();
        i2pin.close();
        s.close();
        i2ps.close();
        t1.join(30000L);
        t2.join(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorOccurred() {
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRef() {
        if (this.sockList != null) {
            Object object = this.slock;
            synchronized (object) {
                this.sockList.remove(this.i2ps);
            }
        }
    }

    static {
        NETWORK_BUFFER_SIZE = MAX_PACKET_SIZE = 4096;
    }

    private class StreamForwarder
    extends I2PThread {
        InputStream in;
        OutputStream out;
        String direction;
        private boolean _toI2P;
        private ByteCache _cache;

        private StreamForwarder(InputStream in, OutputStream out, boolean toI2P) {
            this.in = in;
            this.out = out;
            this._toI2P = toI2P;
            this.direction = toI2P ? "toI2P" : "fromI2P";
            this._cache = ByteCache.getInstance(32, NETWORK_BUFFER_SIZE);
            this.setName("StreamForwarder " + I2PTunnelRunner.this._runnerId + "." + ++I2PTunnelRunner.this.__forwarderId);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            ByteArray ba;
            String to;
            String from;
            block49: {
                block48: {
                    block47: {
                        int len;
                        from = I2PTunnelRunner.this.i2ps.getThisDestination().calculateHash().toBase64().substring(0, 6);
                        to = I2PTunnelRunner.this.i2ps.getPeerDestination().calculateHash().toBase64().substring(0, 6);
                        if (_log.shouldLog(10)) {
                            _log.debug(this.direction + ": Forwarding between " + from + " and " + to);
                        }
                        ba = this._cache.acquire();
                        byte[] buffer = ba.getData();
                        while ((len = this.in.read(buffer)) != -1) {
                            this.out.write(buffer, 0, len);
                            if (this._toI2P) {
                                I2PTunnelRunner.this.totalSent += len;
                            } else {
                                I2PTunnelRunner.this.totalReceived += len;
                            }
                            if (len > 0) {
                                I2PTunnelRunner.this.updateActivity();
                            }
                            if (this.in.available() != 0) continue;
                            if (_log.shouldLog(10)) {
                                _log.debug(this.direction + ": " + len + " bytes flushed through to " + I2PTunnelRunner.this.i2ps.getPeerDestination().calculateHash().toBase64().substring(0, 6));
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (this.in.available() > 0) continue;
                            this.out.flush();
                        }
                        Object var9_11 = null;
                        this._cache.release(ba);
                        if (!_log.shouldLog(20)) break block47;
                        _log.info(this.direction + ": done forwarding between " + from + " and " + to);
                    }
                    try {
                        this.in.close();
                    }
                    catch (IOException ex2) {
                        if (!_log.shouldLog(30)) break block48;
                        _log.warn(this.direction + ": Error closing input stream", ex2);
                    }
                }
                try {
                    this.out.flush();
                }
                catch (IOException ioe) {
                    if (!_log.shouldLog(30)) break block49;
                    _log.warn(this.direction + ": Error flushing to close", ioe);
                }
            }
            Object object = I2PTunnelRunner.this.finishLock;
            synchronized (object) {
                I2PTunnelRunner.this.finished = true;
                I2PTunnelRunner.this.finishLock.notifyAll();
            }
            {
                catch (SocketException ex) {
                    block51: {
                        block50: {
                            Object object2 = I2PTunnelRunner.this.finishLock;
                            synchronized (object2) {
                                if (!I2PTunnelRunner.this.finished && _log.shouldLog(10)) {
                                    _log.debug(this.direction + ": Socket closed - error reading and writing", ex);
                                }
                            }
                            Object var9_12 = null;
                            this._cache.release(ba);
                            if (_log.shouldLog(20)) {
                                _log.info(this.direction + ": done forwarding between " + from + " and " + to);
                            }
                            try {
                                this.in.close();
                            }
                            catch (IOException ex2) {
                                if (!_log.shouldLog(30)) break block50;
                                _log.warn(this.direction + ": Error closing input stream", ex2);
                            }
                        }
                        try {
                            this.out.flush();
                        }
                        catch (IOException ioe) {
                            if (!_log.shouldLog(30)) break block51;
                            _log.warn(this.direction + ": Error flushing to close", ioe);
                        }
                    }
                    Object object3 = I2PTunnelRunner.this.finishLock;
                    synchronized (object3) {
                        I2PTunnelRunner.this.finished = true;
                        I2PTunnelRunner.this.finishLock.notifyAll();
                    }
                }
                catch (InterruptedIOException ex) {
                    block53: {
                        block52: {
                            if (_log.shouldLog(30)) {
                                _log.warn(this.direction + ": Closing connection due to timeout (error: \"" + ex.getMessage() + "\")");
                            }
                            Object var9_13 = null;
                            this._cache.release(ba);
                            if (_log.shouldLog(20)) {
                                _log.info(this.direction + ": done forwarding between " + from + " and " + to);
                            }
                            try {
                                this.in.close();
                            }
                            catch (IOException ex2) {
                                if (!_log.shouldLog(30)) break block52;
                                _log.warn(this.direction + ": Error closing input stream", ex2);
                            }
                        }
                        try {
                            this.out.flush();
                        }
                        catch (IOException ioe) {
                            if (!_log.shouldLog(30)) break block53;
                            _log.warn(this.direction + ": Error flushing to close", ioe);
                        }
                    }
                    Object object4 = I2PTunnelRunner.this.finishLock;
                    synchronized (object4) {
                        I2PTunnelRunner.this.finished = true;
                        I2PTunnelRunner.this.finishLock.notifyAll();
                    }
                }
                catch (IOException ex) {
                    block55: {
                        block54: {
                            if (!I2PTunnelRunner.this.finished && _log.shouldLog(30)) {
                                _log.warn(this.direction + ": Error forwarding", ex);
                            }
                            Object var9_14 = null;
                            this._cache.release(ba);
                            if (_log.shouldLog(20)) {
                                _log.info(this.direction + ": done forwarding between " + from + " and " + to);
                            }
                            try {
                                this.in.close();
                            }
                            catch (IOException ex2) {
                                if (!_log.shouldLog(30)) break block54;
                                _log.warn(this.direction + ": Error closing input stream", ex2);
                            }
                        }
                        try {
                            this.out.flush();
                        }
                        catch (IOException ioe) {
                            if (!_log.shouldLog(30)) break block55;
                            _log.warn(this.direction + ": Error flushing to close", ioe);
                        }
                    }
                    Object object5 = I2PTunnelRunner.this.finishLock;
                    synchronized (object5) {
                        I2PTunnelRunner.this.finished = true;
                        I2PTunnelRunner.this.finishLock.notifyAll();
                    }
                }
            }
            catch (Throwable throwable) {
                block57: {
                    block56: {
                        Object var9_15 = null;
                        this._cache.release(ba);
                        if (_log.shouldLog(20)) {
                            _log.info(this.direction + ": done forwarding between " + from + " and " + to);
                        }
                        try {
                            this.in.close();
                        }
                        catch (IOException ex2) {
                            if (!_log.shouldLog(30)) break block56;
                            _log.warn(this.direction + ": Error closing input stream", ex2);
                        }
                    }
                    try {
                        this.out.flush();
                    }
                    catch (IOException ioe) {
                        if (!_log.shouldLog(30)) break block57;
                        _log.warn(this.direction + ": Error flushing to close", ioe);
                    }
                }
                Object object6 = I2PTunnelRunner.this.finishLock;
                synchronized (object6) {
                    I2PTunnelRunner.this.finished = true;
                    I2PTunnelRunner.this.finishLock.notifyAll();
                }
                throw throwable;
            }
        }
    }
}

