/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.Base64;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class I2PTunnelServer
extends I2PTunnelTask
implements Runnable {
    private static final Log _log = new Log(I2PTunnelServer.class);
    protected I2PSocketManager sockMgr;
    protected I2PServerSocket i2pss;
    private Object lock = new Object();
    protected Object slock = new Object();
    protected InetAddress remoteHost;
    protected int remotePort;
    private boolean _usePool;
    private Logging l;
    private static final long DEFAULT_READ_TIMEOUT = -1L;
    protected long readTimeout = -1L;
    private static final boolean DEFAULT_USE_POOL = false;
    private static volatile long __serverId = 0L;
    private static final String PROP_HANDLER_COUNT = "i2ptunnel.blockingHandlerCount";
    private static final int DEFAULT_HANDLER_COUNT = 10;

    public I2PTunnelServer(InetAddress host, int port, String privData, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host + ":" + port + " <- " + privData, notifyThis, tunnel);
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(privData));
        String usePool = tunnel.getClientOptions().getProperty("i2ptunnel.usePool");
        this._usePool = usePool != null ? "true".equalsIgnoreCase(usePool) : false;
        this.init(host, port, bais, privData, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public I2PTunnelServer(InetAddress host, int port, File privkey, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host + ":" + port + " <- " + privkeyname, notifyThis, tunnel);
        String usePool = tunnel.getClientOptions().getProperty("i2ptunnel.usePool");
        this._usePool = usePool != null ? "true".equalsIgnoreCase(usePool) : false;
        FileInputStream fis = null;
        fis = new FileInputStream(privkey);
        this.init(host, port, fis, privkeyname, l);
        Object var12_10 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                _log.error("Error starting server", ioe);
                this.notifyEvent("openServerResult", "error");
                Object var12_11 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public I2PTunnelServer(InetAddress host, int port, InputStream privData, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host + ":" + port + " <- " + privkeyname, notifyThis, tunnel);
        String usePool = tunnel.getClientOptions().getProperty("i2ptunnel.usePool");
        this._usePool = usePool != null ? "true".equalsIgnoreCase(usePool) : false;
        this.init(host, port, privData, privkeyname, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InetAddress host, int port, InputStream privData, String privkeyname, Logging l) {
        this.l = l;
        this.remoteHost = host;
        this.remotePort = port;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getTunnel().getClientOptions());
        int portNum = 7654;
        if (this.getTunnel().port != null) {
            try {
                portNum = Integer.parseInt(this.getTunnel().port);
            }
            catch (NumberFormatException nfe) {
                _log.log(50, "Invalid port specified [" + this.getTunnel().port + "], reverting to " + portNum);
            }
        }
        while (this.sockMgr == null) {
            Object nfe = this.slock;
            synchronized (nfe) {
                this.sockMgr = I2PSocketManagerFactory.createManager(privData, this.getTunnel().host, portNum, props);
            }
            if (this.sockMgr != null) continue;
            _log.log(50, "Unable to create socket manager");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {}
        }
        this.sockMgr.setName("Server");
        this.getTunnel().addSession(this.sockMgr.getSession());
        l.log("Ready!");
        this.notifyEvent("openServerResult", "ok");
        this.open = true;
    }

    public void startRunning() {
        I2PThread t = new I2PThread(this);
        t.setName("Server " + ++__serverId);
        t.start();
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!forced && this.sockMgr.listSockets().size() != 0) {
                this.l.log("There are still active connections!");
                Iterator it = this.sockMgr.listSockets().iterator();
                while (it.hasNext()) {
                    this.l.log("->" + it.next());
                }
                return false;
            }
            this.l.log("Shutting down server " + this.toString());
            try {
                if (this.i2pss != null) {
                    this.i2pss.close();
                }
                this.getTunnel().removeSession(this.sockMgr.getSession());
                this.sockMgr.getSession().destroySession();
            }
            catch (I2PException ex) {
                _log.error("Error destroying the session", ex);
                System.exit(1);
            }
            this.l.log("Server shut down.");
            this.open = false;
            return true;
        }
    }

    protected int getHandlerCount() {
        int rv = 10;
        String cnt = this.getTunnel().getClientOptions().getProperty(PROP_HANDLER_COUNT);
        if (cnt != null) {
            try {
                rv = Integer.parseInt(cnt);
                if (rv <= 0) {
                    rv = 10;
                }
            }
            catch (NumberFormatException nfe) {
                rv = 10;
            }
        }
        return rv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.shouldUsePool()) {
            I2PServerSocket i2pss = this.sockMgr.getServerSocket();
            int handlers = this.getHandlerCount();
            int i = 0;
            while (true) {
                if (i >= handlers) {
                    return;
                }
                I2PThread handler = new I2PThread(new Handler(i2pss), "Handle Server " + i);
                handler.start();
                ++i;
            }
        }
        I2PServerSocket i2pss = this.sockMgr.getServerSocket();
        while (true) {
            try {
                while (true) {
                    I2PSocket i2ps;
                    if ((i2ps = i2pss.accept()) == null) {
                        throw new I2PException("I2PServerSocket closed");
                    }
                    new I2PThread(new Runnable(){

                        public void run() {
                            I2PTunnelServer.this.blockingHandle(i2ps);
                        }
                    }).start();
                }
            }
            catch (I2PException ipe) {
                if (_log.shouldLog(40)) {
                    _log.error("Error accepting - KILLING THE TUNNEL SERVER", ipe);
                }
                return;
            }
            catch (ConnectException ce) {
                if (!_log.shouldLog(40)) continue;
                _log.error("Error accepting", ce);
                continue;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public boolean shouldUsePool() {
        return this._usePool;
    }

    protected void blockingHandle(I2PSocket socket) {
        long afterAccept = I2PAppContext.getGlobalContext().clock().now();
        long afterSocket = -1L;
        try {
            socket.setReadTimeout(this.readTimeout);
            Socket s = new Socket(this.remoteHost, this.remotePort);
            afterSocket = I2PAppContext.getGlobalContext().clock().now();
            new I2PTunnelRunner(s, socket, this.slock, null, null);
        }
        catch (SocketException ex) {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                _log.error("Error while closing the received i2p con", ex);
            }
        }
        catch (IOException ex) {
            _log.error("Error while waiting for I2PConnections", ex);
        }
        long afterHandle = I2PAppContext.getGlobalContext().clock().now();
        long timeToHandle = afterHandle - afterAccept;
        if (timeToHandle > 1000L) {
            _log.warn("Took a while to handle the request [" + timeToHandle + ", socket create: " + (afterSocket - afterAccept) + "]");
        }
    }

    private class Handler
    implements Runnable {
        private I2PServerSocket _serverSocket;

        public Handler(I2PServerSocket serverSocket) {
            this._serverSocket = serverSocket;
        }

        public void run() {
            while (I2PTunnelServer.this.open) {
                try {
                    I2PTunnelServer.this.blockingHandle(this._serverSocket.accept());
                }
                catch (I2PException ex) {
                    _log.error("Error while waiting for I2PConnections", ex);
                    return;
                }
                catch (IOException ex) {
                    _log.error("Error while waiting for I2PConnections", ex);
                    return;
                }
            }
        }
    }
}

