/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.Socket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSServerFactory;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class I2PSOCKSTunnel
extends I2PTunnelClientBase {
    private static final Log _log = new Log(I2PSOCKSTunnel.class);
    protected Destination outProxyDest = null;

    public I2PSOCKSTunnel(int localPort, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(localPort, ownDest, l, notifyThis, "SOCKSHandler", tunnel);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openSOCKSTunnelResult", "error");
            return;
        }
        this.setName(this.getLocalPort() + " -> SOCKSTunnel");
        this.startRunning();
        this.notifyEvent("openSOCKSTunnelResult", "ok");
    }

    protected void clientConnectionRun(Socket s) {
        try {
            SOCKSServer serv = SOCKSServerFactory.createSOCKSServer(s);
            Socket clientSock = serv.getClientSocket();
            I2PSocket destSock = serv.getDestinationI2PSocket();
            new I2PTunnelRunner(clientSock, destSock, this.sockLock, null, this.mySockets);
        }
        catch (SOCKSException e) {
            _log.error("Error from SOCKS connection: " + e.getMessage());
            I2PSOCKSTunnel.closeSocket(s);
        }
    }
}

