/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class SOCKS5Server
extends SOCKSServer {
    private static final Log _log = new Log(SOCKS5Server.class);
    private static final int SOCKS_VERSION_5 = 5;
    private Socket clientSock = null;
    private boolean setupCompleted = false;

    public SOCKS5Server(Socket clientSock) {
        this.clientSock = clientSock;
    }

    public Socket getClientSocket() throws SOCKSException {
        this.setupServer();
        return this.clientSock;
    }

    protected void setupServer() throws SOCKSException {
        if (this.setupCompleted) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(this.clientSock.getInputStream());
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.init(in, out);
            this.manageRequest(in, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        this.setupCompleted = true;
    }

    private void init(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int nMethods = in.readByte() & 0xFF;
        boolean methodOk = false;
        int method = 255;
        for (int i = 0; i < nMethods && (method = in.readByte() & 0xFF) != 0; ++i) {
        }
        boolean canContinue = false;
        switch (method) {
            case 0: {
                _log.debug("no authentication required");
                this.sendInitReply(0, out);
                return;
            }
        }
        _log.debug("no suitable authentication methods found (" + Integer.toHexString(method) + ")");
        this.sendInitReply(255, out);
        throw new SOCKSException("Unsupported authentication method");
    }

    private void manageRequest(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int socksVer = in.readByte() & 0xFF;
        if (socksVer != 5) {
            _log.debug("error in SOCKS5 request (protocol != 5? wtf?)");
            throw new SOCKSException("Invalid protocol version in request");
        }
        int command = in.readByte() & 0xFF;
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                _log.debug("BIND command is not supported!");
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("BIND command not supported");
            }
            case 3: {
                _log.debug("UDP ASSOCIATE command is not supported!");
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("UDP ASSOCIATE command not supported");
            }
            default: {
                _log.debug("unknown command in request (" + Integer.toHexString(command) + ")");
                throw new SOCKSException("Invalid command in request");
            }
        }
        byte rsv = in.readByte();
        int addressType = in.readByte() & 0xFF;
        switch (addressType) {
            case 1: {
                this.connHostName = new String("");
                for (int i = 0; i < 4; ++i) {
                    int octet = in.readByte() & 0xFF;
                    this.connHostName = this.connHostName + Integer.toString(octet);
                    if (i == 3) continue;
                    this.connHostName = this.connHostName + ".";
                }
                _log.warn("IPV4 address type in request: " + this.connHostName + ". Is your client secure?");
                break;
            }
            case 3: {
                int addrLen = in.readByte() & 0xFF;
                if (addrLen == 0) {
                    _log.debug("0-sized address length? wtf?");
                    throw new SOCKSException("Illegal DOMAINNAME length");
                }
                byte[] addr = new byte[addrLen];
                in.readFully(addr);
                this.connHostName = new String(addr);
                _log.debug("DOMAINNAME address type in request: " + this.connHostName);
                break;
            }
            case 4: {
                _log.warn("IP V6 address type in request! Is your client secure? (IPv6 is not supported, anyway :-)");
                this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("IPV6 addresses not supported");
            }
            default: {
                _log.debug("unknown address type in request (" + Integer.toHexString(command) + ")");
                throw new SOCKSException("Invalid addresses type in request");
            }
        }
        this.connPort = in.readUnsignedShort();
        if (this.connPort == 0) {
            _log.debug("trying to connect to TCP port 0?  Dropping!");
            throw new SOCKSException("Invalid port number in request");
        }
    }

    protected void confirmConnection() throws SOCKSException {
        try {
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.sendRequestReply(0, 1, InetAddress.getByName("127.0.0.1"), null, 1, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
    }

    private void sendInitReply(int replyCode, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        reps.write(5);
        reps.write(replyCode);
        byte[] reply = reps.toByteArray();
        if (_log.shouldLog(10)) {
            _log.debug("Sending init reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private void sendRequestReply(int replyCode, int addressType, InetAddress inetAddr, String domainName, int bindPort, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        DataOutputStream dreps = new DataOutputStream(reps);
        dreps.write(5);
        dreps.write(replyCode);
        dreps.write(0);
        dreps.write(addressType);
        switch (addressType) {
            case 1: {
                dreps.write(inetAddr.getAddress());
                break;
            }
            case 3: {
                dreps.writeByte(domainName.length());
                dreps.writeBytes(domainName);
                break;
            }
            default: {
                _log.error("unknown address type passed to sendReply() (" + Integer.toHexString(addressType) + ")! wtf?");
                return;
            }
        }
        dreps.writeShort(bindPort);
        byte[] reply = reps.toByteArray();
        if (_log.shouldLog(10)) {
            _log.debug("Sending request reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private class Reply {
        private static final int SUCCEEDED = 0;
        private static final int GENERAL_SOCKS_SERVER_FAILURE = 1;
        private static final int CONNECTION_NOT_ALLOWED_BY_RULESET = 2;
        private static final int NETWORK_UNREACHABLE = 3;
        private static final int HOST_UNREACHABLE = 4;
        private static final int CONNECTION_REFUSED = 5;
        private static final int TTL_EXPIRED = 6;
        private static final int COMMAND_NOT_SUPPORTED = 7;
        private static final int ADDRESS_TYPE_NOT_SUPPORTED = 8;

        private Reply() {
        }
    }

    private class Command {
        private static final int CONNECT = 1;
        private static final int BIND = 2;
        private static final int UDP_ASSOCIATE = 3;

        private Command() {
        }
    }

    private class AddressType {
        private static final int IPV4 = 1;
        private static final int DOMAINNAME = 3;
        private static final int IPV6 = 4;

        private AddressType() {
        }
    }

    private class Method {
        private static final int NO_AUTH_REQUIRED = 0;
        private static final int NO_ACCEPTABLE_METHODS = 255;

        private Method() {
        }
    }
}

