/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.web;

import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.i2ptunnel.web.IndexBean;

public class EditBean
extends IndexBean {
    public static boolean staticIsClient(int tunnel) {
        TunnelControllerGroup group = TunnelControllerGroup.getInstance();
        List controllers = group.getControllers();
        if (controllers.size() > tunnel) {
            TunnelController cur = (TunnelController)controllers.get(tunnel);
            if (cur == null) {
                return false;
            }
            return "client".equals(cur.getType()) || "httpclient".equals(cur.getType()) || "ircclient".equals(cur.getType());
        }
        return false;
    }

    public String getTargetHost(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getTargetHost();
        }
        return "127.0.0.1";
    }

    public String getTargetPort(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getTargetPort() != null) {
            return tun.getTargetPort();
        }
        return "";
    }

    public String getSpoofedHost(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getSpoofedHost();
        }
        return "";
    }

    public String getPrivateKeyFile(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null && tun.getPrivKeyFile() != null) {
            return tun.getPrivKeyFile();
        }
        return "";
    }

    public boolean startAutomatically(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getStartOnLoad();
        }
        return false;
    }

    public boolean isSharedClient(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return "true".equalsIgnoreCase(tun.getSharedClient());
        }
        return true;
    }

    public boolean shouldDelay(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts != null) {
                String delay = opts.getProperty("i2p.streaming.connectDelay");
                return delay != null && !"0".equals(delay);
            }
            return false;
        }
        return false;
    }

    public boolean isInteractive(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts != null) {
                String wsiz = opts.getProperty("i2p.streaming.maxWindowSize");
                return wsiz != null && "1".equals(wsiz);
            }
            return false;
        }
        return false;
    }

    public int getTunnelDepth(int tunnel, int defaultLength) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts != null) {
                String len = opts.getProperty("inbound.length");
                if (len == null) {
                    return defaultLength;
                }
                try {
                    return Integer.parseInt(len);
                }
                catch (NumberFormatException nfe) {
                    return defaultLength;
                }
            }
            return defaultLength;
        }
        return defaultLength;
    }

    public int getTunnelQuantity(int tunnel, int defaultQuantity) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts != null) {
                String len = opts.getProperty("inbound.quantity");
                if (len == null) {
                    return defaultQuantity;
                }
                try {
                    return Integer.parseInt(len);
                }
                catch (NumberFormatException nfe) {
                    return defaultQuantity;
                }
            }
            return defaultQuantity;
        }
        return defaultQuantity;
    }

    public int getTunnelBackupQuantity(int tunnel, int defaultBackupQuantity) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts != null) {
                String len = opts.getProperty("inbound.backupQuantity");
                if (len == null) {
                    return defaultBackupQuantity;
                }
                try {
                    return Integer.parseInt(len);
                }
                catch (NumberFormatException nfe) {
                    return defaultBackupQuantity;
                }
            }
            return defaultBackupQuantity;
        }
        return defaultBackupQuantity;
    }

    public int getTunnelVariance(int tunnel, int defaultVariance) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts != null) {
                String len = opts.getProperty("inbound.lengthVariance");
                if (len == null) {
                    return defaultVariance;
                }
                try {
                    return Integer.parseInt(len);
                }
                catch (NumberFormatException nfe) {
                    return defaultVariance;
                }
            }
            return defaultVariance;
        }
        return defaultVariance;
    }

    public String getI2CPHost(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getI2CPHost();
        }
        return "localhost";
    }

    public String getI2CPPort(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            return tun.getI2CPPort();
        }
        return "7654";
    }

    public String getCustomOptions(int tunnel) {
        TunnelController tun = this.getController(tunnel);
        if (tun != null) {
            Properties opts = EditBean.getOptions(tun);
            if (opts == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer(64);
            int i = 0;
            for (String string : opts.keySet()) {
                String val = opts.getProperty(string);
                if ("inbound.length".equals(string) || "outbound.length".equals(string) || "inbound.lengthVariance".equals(string) || "outbound.lengthVariance".equals(string) || "inbound.backupQuantity".equals(string) || "outbound.backupQuantity".equals(string) || "inbound.quantity".equals(string) || "outbound.quantity".equals(string) || "inbound.nickname".equals(string) || "outbound.nickname".equals(string) || "i2p.streaming.connectDelay".equals(string) || "i2p.streaming.maxWindowSize".equals(string)) continue;
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(string).append('=').append(val);
                ++i;
            }
            return buf.toString();
        }
        return "";
    }

    private static Properties getOptions(TunnelController controller) {
        if (controller == null) {
            return null;
        }
        String opts = controller.getClientOptions();
        StringTokenizer tok = new StringTokenizer(opts);
        Properties props = new Properties();
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            int eq = pair.indexOf(61);
            if (eq <= 0 || eq >= pair.length()) continue;
            String key = pair.substring(0, eq);
            String val = pair.substring(eq + 1);
            props.setProperty(key, val);
        }
        return props;
    }
}

