#!/bin/sh

INST_DIR=/opt/i2p/

echo
echo "FINISHING I2P INSTALLATION. PLEASE WAIT."

cd $INST_DIR
sh postinstall.sh || (
  echo "ERROR: failed execution of postinstall.sh. Please"
  echo "cd into i2p installation /opt/i2p/ and run "
  echo "postinstall.sh manually with ./postinstall.sh"
  exit 1
)

sleep 3

sh i2prouter stop || exit 1

echo
echo "Installation finished. i2p start/stop script have been"
echo "installed on /etc/rc.d /opt/i2p/. You should chmod +x"
echo '/etc/rc.d/rc.i2p and put "/etc/rc.d/rc.i2p start" on '
echo "/etc/rc.d/rc.local if you want i2p start at boot."

exit
