/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.util.Log;
import org.mortbay.http.HttpListener;
import org.mortbay.jetty.Server;

public class ConfigClientsHandler
extends FormHandler {
    private Log _log = ContextHelper.getContext(null).logManager().getLog(ConfigClientsHandler.class);
    private Map _settings;

    protected void processForm() {
        if (this._action.startsWith("Save Client")) {
            this.saveClientChanges();
        } else if (this._action.startsWith("Save WebApp")) {
            this.saveWebAppChanges();
        } else if (this._action.startsWith("Start ")) {
            String app = this._action.substring(6);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                this.startWebApp(app);
            }
        } else {
            this.addFormError("Unsupported " + this._action);
        }
    }

    public void setSettings(Map settings) {
        this._settings = new HashMap(settings);
    }

    private void saveClientChanges() {
        List clients = ClientAppConfig.getClientApps(this._context);
        for (int cur = 0; cur < clients.size(); ++cur) {
            ClientAppConfig ca = (ClientAppConfig)clients.get(cur);
            Object val = this._settings.get(cur + ".enabled");
            if ("webConsole".equals(ca.clientName)) continue;
            ca.disabled = val == null;
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice("Client configuration saved successfully - restart required to take effect");
    }

    private void startClient(int i) {
        List clients = ClientAppConfig.getClientApps(this._context);
        if (i >= clients.size()) {
            this.addFormError("Bad client index");
            return;
        }
        ClientAppConfig ca = (ClientAppConfig)clients.get(i);
        LoadClientAppsJob.runClient(ca.className, ca.clientName, LoadClientAppsJob.parseArgs(ca.args), this._log);
        this.addFormNotice("Client " + ca.clientName + " started");
    }

    private void saveWebAppChanges() {
        Properties props = RouterConsoleRunner.webAppProperties();
        Set<Object> keys = props.keySet();
        boolean cur = false;
        for (String string : keys) {
            if (!string.startsWith("webapps.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("webapps.".length(), string.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            if ("routerconsole".equals(app)) continue;
            props.setProperty(string, "" + (val != null));
        }
        RouterConsoleRunner.storeWebAppProperties(props);
        this.addFormNotice("WebApp configuration saved successfully - restart required to take effect");
    }

    private void startWebApp(String app) {
        Collection c = Server.getHttpServers();
        for (int i = 0; i < c.size(); ++i) {
            Server s = (Server)c.toArray()[i];
            HttpListener[] hl = s.getListeners();
            for (int j = 0; j < hl.length; ++j) {
                if (hl[j].getPort() != 7657) continue;
                try {
                    s.addWebApplication("/" + app, "./webapps/" + app + ".war").start();
                    this.addFormNotice("WebApp <a href=\"/" + app + "/\">" + app + "<a> started");
                }
                catch (Exception ioe) {
                    this.addFormError("Failed to start " + app + " " + ioe);
                }
                return;
            }
        }
        this.addFormError("Failed to find server");
    }
}

