/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Properties;
import java.util.TreeSet;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ContextHelper;

public class ConfigLoggingHelper {
    private RouterContext _context;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getLogFilePattern() {
        return this._context.logManager().getBaseLogfilename();
    }

    public String getRecordPattern() {
        return new String(this._context.logManager().getFormat());
    }

    public String getDatePattern() {
        return this._context.logManager().getDateFormatPattern();
    }

    public String getMaxFileSize() {
        int bytes = this._context.logManager().getFileSize();
        if (bytes == 0) {
            return "1m";
        }
        if (bytes > 0x40000000) {
            return bytes / 0x40000000 + "g";
        }
        if (bytes > 0x100000) {
            return bytes / 0x100000 + "m";
        }
        return bytes / 1024 + "k";
    }

    public String getLogLevelTable() {
        StringBuffer buf = new StringBuffer(32768);
        Properties limits = this._context.logManager().getLimits();
        TreeSet<String> sortedLogs = new TreeSet<String>();
        for (String string : limits.keySet()) {
            sortedLogs.add(string);
        }
        buf.append("<textarea name=\"levels\" rows=\"20\" cols=\"90\">");
        for (String string : sortedLogs) {
            String level = limits.getProperty(string);
            buf.append(string).append('=').append(level).append('\n');
        }
        buf.append("</textarea><br />\n");
        buf.append("<i>Add additional logging statements above. Example: net.i2p.router.tunnel=WARN</i><br>");
        buf.append("<i>Or put entries in the logger.config file. Example: logger.record.net.i2p.router.tunnel=WARN</i><br>");
        buf.append("<i>Valid levels are DEBUG, INFO, WARN, ERROR, CRIT</i>\n");
        return buf.toString();
    }

    public String getDefaultLogLevelBox() {
        String cur = this._context.logManager().getDefaultLimit();
        StringBuffer buf = new StringBuffer(128);
        buf.append("<select name=\"defaultloglevel\">\n");
        buf.append("<option value=\"DEBUG\" ");
        if ("DEBUG".equals(cur)) {
            buf.append(" selected=\"true\" ");
        }
        buf.append(">DEBUG</option>\n");
        buf.append("<option value=\"INFO\" ");
        if ("INFO".equals(cur)) {
            buf.append(" selected=\"true\" ");
        }
        buf.append(">INFO</option>\n");
        buf.append("<option value=\"WARN\" ");
        if ("WARN".equals(cur)) {
            buf.append(" selected=\"true\" ");
        }
        buf.append(">WARN</option>\n");
        buf.append("<option value=\"ERROR\" ");
        if ("ERROR".equals(cur)) {
            buf.append(" selected=\"true\" ");
        }
        buf.append(">ERROR</option>\n");
        buf.append("<option value=\"CRIT\" ");
        if ("CRIT".equals(cur)) {
            buf.append(" selected=\"true\" ");
        }
        buf.append(">CRIT</option>\n");
        buf.append("</select>\n");
        return buf.toString();
    }
}

