/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.RouterAddress;
import net.i2p.router.LoadTestManager;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.web.ContextHelper;

public class ConfigNetHelper {
    private RouterContext _context;
    public static final String PROP_I2NP_TCP_HOSTNAME = "i2np.tcp.hostname";
    public static final String PROP_I2NP_TCP_PORT = "i2np.tcp.port";
    public static final String PROP_I2NP_UDP_PORT = "i2np.udp.port";
    public static final String PROP_I2NP_INTERNAL_UDP_PORT = "i2np.udp.internalPort";
    public static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    public static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    public static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoip";
    public static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoport";
    public static final String PROP_INBOUND_KBPS = "i2np.bandwidth.inboundKBytesPerSecond";
    public static final String PROP_OUTBOUND_KBPS = "i2np.bandwidth.outboundKBytesPerSecond";
    public static final String PROP_INBOUND_BURST_KBPS = "i2np.bandwidth.inboundBurstKBytesPerSecond";
    public static final String PROP_OUTBOUND_BURST_KBPS = "i2np.bandwidth.outboundBurstKBytesPerSecond";
    public static final String PROP_INBOUND_BURST = "i2np.bandwidth.inboundBurstKBytes";
    public static final String PROP_OUTBOUND_BURST = "i2np.bandwidth.outboundBurstKBytes";
    public static final String PROP_SHARE_PERCENTAGE = "router.sharePercentage";
    public static final int DEFAULT_SHARE_PERCENTAGE = 80;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getHostname() {
        return this._context.getProperty(PROP_I2NP_TCP_HOSTNAME);
    }

    public String getTcpPort() {
        int port = 8887;
        String val = this._context.getProperty(PROP_I2NP_TCP_PORT);
        if (val != null) {
            try {
                port = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "" + port;
    }

    public String getNtcphostname() {
        String hostname = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (hostname == null) {
            return "";
        }
        return hostname;
    }

    public String getNtcpport() {
        String port = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        if (port == null) {
            return "";
        }
        return port;
    }

    public String getUdpAddress() {
        RouterAddress addr = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (addr == null) {
            return "unknown";
        }
        UDPAddress ua = new UDPAddress(addr);
        return ua.toString();
    }

    public String getUdpIP() {
        RouterAddress addr = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (addr == null) {
            return "unknown";
        }
        UDPAddress ua = new UDPAddress(addr);
        if (ua.getHost() == null) {
            return "unknown";
        }
        return ua.getHost();
    }

    public String getUdpPort() {
        RouterAddress addr = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (addr == null) {
            return "unknown";
        }
        UDPAddress ua = new UDPAddress(addr);
        if (ua.getPort() <= 0) {
            return "unknown";
        }
        return "" + ua.getPort();
    }

    public String getEnableTimeSyncChecked() {
        String disabled = this._context.getProperty("time.disabled", "false");
        if (disabled != null && "true".equalsIgnoreCase(disabled)) {
            return "";
        }
        return " checked ";
    }

    public String getHiddenModeChecked() {
        String enabled = this._context.getProperty("router.hiddenMode", "false");
        if (enabled != null && "true".equalsIgnoreCase(enabled)) {
            return " checked ";
        }
        return "";
    }

    public String getDynamicKeysChecked() {
        String enabled = this._context.getProperty("router.dynamicKeys", "false");
        if (enabled != null && "true".equalsIgnoreCase(enabled)) {
            return " checked ";
        }
        return "";
    }

    public String getTcpAutoPortChecked() {
        String enabled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_PORT, "false");
        if (enabled != null && "true".equalsIgnoreCase(enabled)) {
            return " checked ";
        }
        return "";
    }

    public String getTcpAutoIPChecked() {
        String enabled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "false");
        if (enabled != null && "true".equalsIgnoreCase(enabled)) {
            return " checked ";
        }
        return "";
    }

    public String getRequireIntroductionsChecked() {
        short status = this._context.commSystem().getReachabilityStatus();
        switch (status) {
            case 0: {
                if ("true".equalsIgnoreCase(this._context.getProperty("i2np.udp.forceIntroducers", "false"))) {
                    return "checked=\"true\"";
                }
                return "";
            }
            case 1: 
            case 2: {
                return "checked=\"true\"";
            }
            case 4: {
                if ("true".equalsIgnoreCase(this._context.getProperty("i2np.udp.forceIntroducers", "false"))) {
                    return "checked=\"true\"";
                }
                return "";
            }
        }
        return "checked=\"true\"";
    }

    public String getInboundRate() {
        String rate = this._context.getProperty(PROP_INBOUND_KBPS);
        if (rate != null) {
            return rate;
        }
        return "32";
    }

    public String getOutboundRate() {
        String rate = this._context.getProperty(PROP_OUTBOUND_KBPS);
        if (rate != null) {
            return rate;
        }
        return "16";
    }

    public String getInboundBurstRate() {
        String rate = this._context.getProperty(PROP_INBOUND_BURST_KBPS);
        if (rate != null) {
            return rate;
        }
        return "48";
    }

    public String getOutboundBurstRate() {
        String rate = this._context.getProperty(PROP_OUTBOUND_BURST_KBPS);
        if (rate != null) {
            return rate;
        }
        return "32";
    }

    public String getInboundBurstFactorBox() {
        String rate = this._context.getProperty(PROP_INBOUND_BURST_KBPS);
        String burst = this._context.getProperty(PROP_INBOUND_BURST);
        int numSeconds = 1;
        if (burst != null && rate != null) {
            int rateKBps = 0;
            int burstKB = 0;
            try {
                rateKBps = Integer.parseInt(rate);
                burstKB = Integer.parseInt(burst);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (rateKBps > 0 && burstKB > 0) {
                numSeconds = burstKB / rateKBps;
            }
        }
        return ConfigNetHelper.getBurstFactor(numSeconds, "inboundburstfactor");
    }

    public String getOutboundBurstFactorBox() {
        String rate = this._context.getProperty(PROP_OUTBOUND_BURST_KBPS);
        String burst = this._context.getProperty(PROP_OUTBOUND_BURST);
        int numSeconds = 1;
        if (burst != null && rate != null) {
            int rateKBps = 0;
            int burstKB = 0;
            try {
                rateKBps = Integer.parseInt(rate);
                burstKB = Integer.parseInt(burst);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (rateKBps > 0 && burstKB > 0) {
                numSeconds = burstKB / rateKBps;
            }
        }
        return ConfigNetHelper.getBurstFactor(numSeconds, "outboundburstfactor");
    }

    private static String getBurstFactor(int numSeconds, String name) {
        StringBuffer buf = new StringBuffer(256);
        buf.append("<select name=\"").append(name).append("\">\n");
        boolean found = false;
        for (int i = 10; i <= 60; i += 10) {
            buf.append("<option value=\"").append(i).append("\" ");
            if (i == numSeconds) {
                buf.append("selected ");
                found = true;
            } else if (i == 60 && !found) {
                buf.append("selected ");
            }
            buf.append(">");
            buf.append(i).append(" seconds</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getEnableLoadTesting() {
        if (LoadTestManager.isEnabled(this._context)) {
            return " checked ";
        }
        return "";
    }

    public String getSharePercentageBox() {
        String pctStr = this._context.getProperty(PROP_SHARE_PERCENTAGE);
        int pct = 80;
        if (pctStr != null) {
            try {
                pct = Integer.parseInt(pctStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("<select name=\"sharePercentage\">\n");
        boolean found = false;
        for (int i = 30; i <= 100; i += 10) {
            buf.append("<option value=\"").append(i).append("\" ");
            if (pct == i) {
                buf.append("selected=\"true\" ");
                found = true;
            } else if (i == 80 && !found) {
                buf.append("selected=\"true\" ");
            }
            buf.append(">Up to ").append(i).append("%</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public int getShareBandwidth() {
        String irate = this._context.getProperty(PROP_INBOUND_KBPS, "32");
        String orate = this._context.getProperty(PROP_OUTBOUND_KBPS, "16");
        String pctStr = this._context.getProperty(PROP_SHARE_PERCENTAGE, "80");
        if (irate != null && orate != null && pctStr != null) {
            try {
                int irateKBps = Integer.parseInt(irate);
                int orateKBps = Integer.parseInt(orate);
                if (irateKBps < 0 || orateKBps < 0) {
                    return 12;
                }
                int pct = Integer.parseInt(pctStr);
                return (int)((float)pct * (float)Math.min(irateKBps, orateKBps) / 100.0f);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 12;
    }
}

