/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ContextHelper;

public class ConfigRestartBean {
    public static String getNonce() {
        RouterContext ctx = ContextHelper.getContext(null);
        String nonce = System.getProperty("console.nonce");
        if (nonce == null) {
            nonce = "" + ctx.random().nextLong();
            System.setProperty("console.nonce", nonce);
        }
        return nonce;
    }

    public static String renderStatus(String urlBase, String action, String nonce) {
        RouterContext ctx = ContextHelper.getContext(null);
        String systemNonce = ConfigRestartBean.getNonce();
        if (nonce != null && systemNonce.equals(nonce) && action != null) {
            if ("shutdownImmediate".equals(action)) {
                ctx.router().addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(3));
                ctx.router().shutdown(3);
            } else if ("cancelShutdown".equals(action)) {
                ctx.router().cancelGracefulShutdown();
            } else if ("restartImmediate".equals(action)) {
                ctx.router().addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(4));
                ctx.router().shutdown(4);
            } else if ("restart".equals(action)) {
                ctx.router().addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(5));
                ctx.router().shutdownGracefully(5);
            } else if ("shutdown".equals(action)) {
                ctx.router().addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(2));
                ctx.router().shutdownGracefully();
            }
        }
        boolean shuttingDown = ConfigRestartBean.isShuttingDown(ctx);
        boolean restarting = ConfigRestartBean.isRestarting(ctx);
        long timeRemaining = ctx.router().getShutdownTimeRemaining();
        if (shuttingDown) {
            if (timeRemaining <= 0L) {
                return "<b>Shutdown imminent</b>";
            }
            return "<b>Shutdown in " + DataHelper.formatDuration(timeRemaining) + "</b><br />" + "<a href=\"" + urlBase + "?consoleNonce=" + systemNonce + "&amp;action=shutdownImmediate\">Shutdown immediately</a><br />" + "<a href=\"" + urlBase + "?consoleNonce=" + systemNonce + "&amp;action=cancelShutdown\">Cancel shutdown</a> ";
        }
        if (restarting) {
            if (timeRemaining <= 0L) {
                return "<b>Restart imminent</b>";
            }
            return "<b>Restart in " + DataHelper.formatDuration(timeRemaining) + "</b><br />" + "<a href=\"" + urlBase + "?consoleNonce=" + systemNonce + "&amp;action=restartImmediate\">Restart immediately</a><br />" + "<a href=\"" + urlBase + "?consoleNonce=" + systemNonce + "&amp;action=cancelShutdown\">Cancel restart</a> ";
        }
        return "<a href=\"" + urlBase + "?consoleNonce=" + systemNonce + "&amp;action=restart\" title=\"Graceful restart\">Restart</a> " + "<a href=\"" + urlBase + "?consoleNonce=" + systemNonce + "&amp;action=shutdown\" title=\"Graceful shutdown\">Shutdown</a>";
    }

    private static boolean isShuttingDown(RouterContext ctx) {
        return 2 == ctx.router().scheduledGracefulExitCode();
    }

    private static boolean isRestarting(RouterContext ctx) {
        return 5 == ctx.router().scheduledGracefulExitCode();
    }
}

